/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.anttasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.commandline.Arg;
import org.apache.rat.utils.CasedString;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;
import org.apache.tools.ant.Task;

public abstract class BaseAntTask
extends Task {
    private static final Map<String, String> xlateName = new HashMap<String, String>();
    private static final List<String> unsupportedArgs = new ArrayList<String>();
    protected final Map<String, List<String>> args = new HashMap<String, List<String>>();

    public static String createName(String longOpt) {
        String name = StringUtils.defaultIfEmpty(xlateName.get(longOpt), longOpt).toLowerCase(Locale.ROOT);
        return new CasedString(CasedString.StringCase.KEBAB, name).toCase(CasedString.StringCase.CAMEL);
    }

    public static List<String> unsupportedArgs() {
        return Collections.unmodifiableList(unsupportedArgs);
    }

    protected List<String> args() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : this.args.entrySet()) {
            result.add("--" + entry.getKey());
            result.addAll(entry.getValue().stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return result;
    }

    private String argsKey(Option opt) {
        return StringUtils.defaultIfEmpty(opt.getLongOpt(), opt.getKey());
    }

    private boolean validateSet(String key) {
        Arg arg = Arg.findArg(key);
        if (arg != null) {
            Option opt = arg.find(key);
            Option main = arg.option();
            if (opt.isDeprecated()) {
                this.args.remove(this.argsKey(main));
                return true;
            }
            for (Option o : arg.group().getOptions()) {
                if (o.equals(main) || !this.args.containsKey(this.argsKey(o))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void setArg(String key, String value) {
        if (this.validateSet(key)) {
            ArrayList<String> values = new ArrayList<String>();
            if (DefaultLog.getInstance().isEnabled(Log.Level.DEBUG)) {
                DefaultLog.getInstance().debug(String.format("Adding [%s] to %s", String.join((CharSequence)", ", values), key));
            }
            values.add(value);
            this.args.put(key, values);
        }
    }

    public List<String> getArg(String key) {
        return this.args.get(key);
    }

    protected void addArg(String key, String[] value) {
        if (this.validateSet(key)) {
            List<String> values;
            if (DefaultLog.getInstance().isEnabled(Log.Level.DEBUG)) {
                DefaultLog.getInstance().debug(String.format("Adding [%s] to %s", String.join((CharSequence)", ", Arrays.asList(value)), key));
            }
            if ((values = this.args.get(key)) == null) {
                values = new ArrayList<String>();
                this.args.put(key, values);
            }
            values.addAll(Arrays.asList(value));
        }
    }

    protected void addArg(String key, String value) {
        if (this.validateSet(key)) {
            List<String> values = this.args.get(key);
            if (DefaultLog.getInstance().isEnabled(Log.Level.DEBUG)) {
                DefaultLog.getInstance().debug(String.format("Adding [%s] to %s", String.join((CharSequence)", ", Arrays.asList(value)), key));
            }
            if (values == null) {
                values = new ArrayList<String>();
                this.args.put(key, values);
            }
            values.add(value);
        }
    }

    protected void removeArg(String key) {
        this.args.remove(key);
    }

    protected BaseAntTask() {
    }

    public void setCopyright(String copyright) {
        this.setArg("copyright", copyright);
    }

    public void setEditCopyright(String editCopyright) {
        this.setArg("edit-copyright", editCopyright);
    }

    public void setForce(boolean force) {
        if (force) {
            this.setArg("force", null);
        } else {
            this.removeArg("force");
        }
    }

    public void setEditOverwrite(boolean editOverwrite) {
        if (editOverwrite) {
            this.setArg("edit-overwrite", null);
        } else {
            this.removeArg("edit-overwrite");
        }
    }

    public void setAddLicense(boolean addLicense) {
        if (addLicense) {
            this.setArg("addLicense", null);
        } else {
            this.removeArg("addLicense");
        }
    }

    public void setEditLicense(boolean editLicense) {
        if (editLicense) {
            this.setArg("edit-license", null);
        } else {
            this.removeArg("edit-license");
        }
    }

    public void setConfigurationNoDefaults(boolean configurationNoDefaults) {
        if (configurationNoDefaults) {
            this.setArg("configuration-no-defaults", null);
        } else {
            this.removeArg("configuration-no-defaults");
        }
    }

    public void setNoDefaultLicenses(boolean noDefaultLicenses) {
        if (noDefaultLicenses) {
            this.setArg("no-default-licenses", null);
        } else {
            this.removeArg("no-default-licenses");
        }
    }

    public void setLicensesApprovedFile(String licensesApprovedFile) {
        this.setArg("licenses-approved-file", licensesApprovedFile);
    }

    public void setLicenseFamiliesApprovedFile(String licenseFamiliesApprovedFile) {
        this.setArg("license-families-approved-file", licenseFamiliesApprovedFile);
    }

    public void setLicensesDeniedFile(String licensesDeniedFile) {
        this.setArg("licenses-denied-file", licensesDeniedFile);
    }

    public void setLicenseFamiliesDeniedFile(String licenseFamiliesDeniedFile) {
        this.setArg("license-families-denied-file", licenseFamiliesDeniedFile);
    }

    public void setExcludeFile(String excludeFile) {
        this.setArg("exclude-file", excludeFile);
    }

    public void setInputExcludeFile(String inputExcludeFile) {
        this.setArg("input-exclude-file", inputExcludeFile);
    }

    public void setInputExcludeSize(String inputExcludeSize) {
        this.setArg("input-exclude-size", inputExcludeSize);
    }

    public void setInputIncludeFile(String inputIncludeFile) {
        this.setArg("input-include-file", inputIncludeFile);
    }

    public void setIncludesFile(String includesFile) {
        this.setArg("includes-file", includesFile);
    }

    public void setScanHiddenDirectories(boolean scanHiddenDirectories) {
        if (scanHiddenDirectories) {
            this.setArg("scan-hidden-directories", null);
        } else {
            this.removeArg("scan-hidden-directories");
        }
    }

    public void setOutputStyle(String outputStyle) {
        this.setArg("output-style", outputStyle);
    }

    public void setStylesheet(String stylesheet) {
        this.setArg("stylesheet", stylesheet);
    }

    public void setXml(boolean xml) {
        if (xml) {
            this.setArg("xml", null);
        } else {
            this.removeArg("xml");
        }
    }

    public void setOutputLicenses(String outputLicenses) {
        this.setArg("output-licenses", outputLicenses);
    }

    public void setListLicenses(String listLicenses) {
        this.setArg("list-licenses", listLicenses);
    }

    public void setOutputFamilies(String outputFamilies) {
        this.setArg("output-families", outputFamilies);
    }

    public void setListFamilies(String listFamilies) {
        this.setArg("list-families", listFamilies);
    }

    public void setDryRun(boolean dryRun) {
        if (dryRun) {
            this.setArg("dry-run", null);
        } else {
            this.removeArg("dry-run");
        }
    }

    public void setOut(String out) {
        this.setArg("out", out);
    }

    public void setOutputFile(String outputFile) {
        this.setArg("output-file", outputFile);
    }

    public void setOutputArchive(String outputArchive) {
        this.setArg("output-archive", outputArchive);
    }

    public void setOutputStandard(String outputStandard) {
        this.setArg("output-standard", outputStandard);
    }

    public void setHelpLicenses(boolean helpLicenses) {
        if (helpLicenses) {
            this.setArg("help-licenses", null);
        } else {
            this.removeArg("help-licenses");
        }
    }

    public Config createConfig() {
        return new Config();
    }

    public Licenses createLicenses() {
        return new Licenses();
    }

    public LicensesApproved createLicensesApproved() {
        return new LicensesApproved();
    }

    public LicensesApprovedFile createLicensesApprovedFile() {
        return new LicensesApprovedFile();
    }

    public LicenseFamiliesApproved createLicenseFamiliesApproved() {
        return new LicenseFamiliesApproved();
    }

    public LicenseFamiliesApprovedFile createLicenseFamiliesApprovedFile() {
        return new LicenseFamiliesApprovedFile();
    }

    public LicensesDenied createLicensesDenied() {
        return new LicensesDenied();
    }

    public LicensesDeniedFile createLicensesDeniedFile() {
        return new LicensesDeniedFile();
    }

    public LicenseFamiliesDenied createLicenseFamiliesDenied() {
        return new LicenseFamiliesDenied();
    }

    public LicenseFamiliesDeniedFile createLicenseFamiliesDeniedFile() {
        return new LicenseFamiliesDeniedFile();
    }

    public CounterMax createCounterMax() {
        return new CounterMax();
    }

    public CounterMin createCounterMin() {
        return new CounterMin();
    }

    public Exclude createExclude() {
        return new Exclude();
    }

    public InputExclude createInputExclude() {
        return new InputExclude();
    }

    public ExcludeFile createExcludeFile() {
        return new ExcludeFile();
    }

    public InputExcludeFile createInputExcludeFile() {
        return new InputExcludeFile();
    }

    public InputExcludeStd createInputExcludeStd() {
        return new InputExcludeStd();
    }

    public InputExcludeSize createInputExcludeSize() {
        return new InputExcludeSize();
    }

    public InputInclude createInputInclude() {
        return new InputInclude();
    }

    public Include createInclude() {
        return new Include();
    }

    public InputIncludeFile createInputIncludeFile() {
        return new InputIncludeFile();
    }

    public IncludesFile createIncludesFile() {
        return new IncludesFile();
    }

    public InputIncludeStd createInputIncludeStd() {
        return new InputIncludeStd();
    }

    public InputExcludeParsedScm createInputExcludeParsedScm() {
        return new InputExcludeParsedScm();
    }

    public Out createOut() {
        return new Out();
    }

    public OutputFile createOutputFile() {
        return new OutputFile();
    }

    static {
        xlateName.put("addLicense", "add-license");
        unsupportedArgs.add("log-level");
        unsupportedArgs.add("dir");
        unsupportedArgs.add("help");
    }

    public class Config
    extends Child {
        Config() {
            super("config");
        }
    }

    public class Licenses
    extends Child {
        Licenses() {
            super("licenses");
        }
    }

    public class LicensesApproved
    extends Child {
        LicensesApproved() {
            super("licenses-approved");
        }
    }

    public class LicensesApprovedFile
    extends Child {
        LicensesApprovedFile() {
            super("licenses-approved-file");
        }
    }

    public class LicenseFamiliesApproved
    extends Child {
        LicenseFamiliesApproved() {
            super("license-families-approved");
        }
    }

    public class LicenseFamiliesApprovedFile
    extends Child {
        LicenseFamiliesApprovedFile() {
            super("license-families-approved-file");
        }
    }

    public class LicensesDenied
    extends Child {
        LicensesDenied() {
            super("licenses-denied");
        }
    }

    public class LicensesDeniedFile
    extends Child {
        LicensesDeniedFile() {
            super("licenses-denied-file");
        }
    }

    public class LicenseFamiliesDenied
    extends Child {
        LicenseFamiliesDenied() {
            super("license-families-denied");
        }
    }

    public class LicenseFamiliesDeniedFile
    extends Child {
        LicenseFamiliesDeniedFile() {
            super("license-families-denied-file");
        }
    }

    public class CounterMax
    extends Child {
        CounterMax() {
            super("counter-max");
        }
    }

    public class CounterMin
    extends Child {
        CounterMin() {
            super("counter-min");
        }
    }

    public class Exclude
    extends Child {
        Exclude() {
            super("exclude");
        }
    }

    public class InputExclude
    extends Child {
        InputExclude() {
            super("input-exclude");
        }
    }

    public class ExcludeFile
    extends Child {
        ExcludeFile() {
            super("exclude-file");
        }
    }

    public class InputExcludeFile
    extends Child {
        InputExcludeFile() {
            super("input-exclude-file");
        }
    }

    public class InputExcludeStd
    extends Child {
        InputExcludeStd() {
            super("input-exclude-std");
        }
    }

    public class InputExcludeSize
    extends Child {
        InputExcludeSize() {
            super("input-exclude-size");
        }
    }

    public class InputInclude
    extends Child {
        InputInclude() {
            super("input-include");
        }
    }

    public class Include
    extends Child {
        Include() {
            super("include");
        }
    }

    public class InputIncludeFile
    extends Child {
        InputIncludeFile() {
            super("input-include-file");
        }
    }

    public class IncludesFile
    extends Child {
        IncludesFile() {
            super("includes-file");
        }
    }

    public class InputIncludeStd
    extends Child {
        InputIncludeStd() {
            super("input-include-std");
        }
    }

    public class InputExcludeParsedScm
    extends Child {
        InputExcludeParsedScm() {
            super("input-exclude-parsed-scm");
        }
    }

    public class Out
    extends Child {
        Out() {
            super("out");
        }
    }

    public class OutputFile
    extends Child {
        OutputFile() {
            super("output-file");
        }
    }

    protected class Child {
        final String key;

        protected Child(String key) {
            this.key = key;
        }

        public void addText(String arg) {
            BaseAntTask.this.addArg(this.key, arg);
        }
    }
}

