/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import java.util.Collection;
import java.util.SortedSet;
import java.util.function.Predicate;
import org.apache.rat.ConfigurationException;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.analysis.DocumentHeaderAnalyser;
import org.apache.rat.analysis.TikaProcessor;
import org.apache.rat.analysis.UnknownLicense;
import org.apache.rat.api.Document;
import org.apache.rat.api.RatException;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.walker.ArchiveWalker;

public final class DefaultAnalyserFactory {
    private DefaultAnalyserFactory() {
    }

    public static IDocumentAnalyser createDefaultAnalyser(ReportConfiguration configuration) {
        SortedSet<ILicense> licenses = configuration.getLicenses(LicenseSetFactory.LicenseFilter.ALL);
        if (licenses.isEmpty()) {
            throw new ConfigurationException("At least one license must be defined");
        }
        DefaultLog.getInstance().debug("Licenses in Test");
        licenses.forEach(DefaultLog.getInstance()::debug);
        return new DefaultAnalyser(configuration, licenses);
    }

    private static final class DefaultAnalyser
    implements IDocumentAnalyser {
        private final Collection<ILicense> licenses;
        private final ReportConfiguration configuration;

        DefaultAnalyser(ReportConfiguration config, Collection<ILicense> licenses) {
            this.licenses = licenses;
            this.configuration = config;
        }

        private Predicate<ILicense> licenseFilter(ReportConfiguration.Processing proc) {
            return license -> {
                switch (proc) {
                    case PRESENCE: {
                        return !license.getLicenseFamily().equals(UnknownLicense.INSTANCE.getLicenseFamily());
                    }
                    case ABSENCE: {
                        return true;
                    }
                }
                return false;
            };
        }

        @Override
        public void analyse(Document document) throws RatDocumentAnalysisException {
            TikaProcessor.process(document);
            switch (document.getMetaData().getDocumentType()) {
                case STANDARD: {
                    Predicate<ILicense> licensePredicate = this.licenseFilter(this.configuration.getStandardProcessing()).negate();
                    new DocumentHeaderAnalyser(this.licenses).analyse(document);
                    if (this.configuration.getStandardProcessing() == Defaults.STANDARD_PROCESSING) break;
                    document.getMetaData().removeLicenses(licensePredicate);
                    break;
                }
                case ARCHIVE: {
                    Predicate<ILicense> licensePredicate = this.licenseFilter(this.configuration.getArchiveProcessing());
                    if (this.configuration.getArchiveProcessing() == ReportConfiguration.Processing.NOTIFICATION) break;
                    ArchiveWalker archiveWalker = new ArchiveWalker(document);
                    try {
                        for (Document doc : archiveWalker.getDocuments()) {
                            this.analyse(doc);
                            doc.getMetaData().licenses().filter(licensePredicate).forEach(lic -> document.getMetaData().reportOnLicense((ILicense)lic));
                        }
                        break;
                    }
                    catch (RatException e) {
                        throw new RatDocumentAnalysisException(e);
                    }
                }
            }
        }
    }
}

