/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.validator.routines.AbstractCalendarValidator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractCalendarValidatorTest {
    protected AbstractCalendarValidator validator;
    protected String[] patternValid = new String[]{"2005-01-01", "2005-12-31", "2004-02-29", "2005-04-30", "05-12-31", "2005-1-1", "05-1-1"};
    protected String[] localeValid = new String[]{"01/01/2005", "12/31/2005", "02/29/2004", "04/30/2005", "12/31/05", "1/1/2005", "1/1/05"};
    protected Date[] patternExpect = new Date[]{AbstractCalendarValidatorTest.createDate(null, 20050101, 0), AbstractCalendarValidatorTest.createDate(null, 20051231, 0), AbstractCalendarValidatorTest.createDate(null, 20040229, 0), AbstractCalendarValidatorTest.createDate(null, 20050430, 0), AbstractCalendarValidatorTest.createDate(null, 20051231, 0), AbstractCalendarValidatorTest.createDate(null, 20050101, 0), AbstractCalendarValidatorTest.createDate(null, 20050101, 0)};
    protected String[] patternInvalid = new String[]{"2005-00-01", "2005-01-00", "2005-13-03", "2005-04-31", "2005-03-32", "2005-02-29", "200X-01-01", "2005-0X-01", "2005-01-0X", "01/01/2005", "2005-01", "2005--01", "2005-01-"};
    protected String[] localeInvalid = new String[]{"01/00/2005", "00/01/2005", "13/01/2005", "04/31/2005", "03/32/2005", "02/29/2005", "01/01/200X", "01/0X/2005", "0X/01/2005", "01-01-2005", "01/2005", "01//2005"};

    protected static Calendar createCalendar(TimeZone zone, int date, int time) {
        Calendar calendar = zone == null ? Calendar.getInstance() : Calendar.getInstance(zone);
        int year = date / 10000 * 10000;
        int mth = date / 100 * 100 - year;
        int day = date - (year + mth);
        int hour = time / 10000 * 10000;
        int min = time / 100 * 100 - hour;
        int sec = time - (hour + min);
        calendar.set(1, year / 10000);
        calendar.set(2, mth / 100 - 1);
        calendar.set(5, day);
        calendar.set(11, hour / 10000);
        calendar.set(12, min / 100);
        calendar.set(13, sec);
        calendar.set(14, 0);
        return calendar;
    }

    protected static Date createDate(TimeZone zone, int date, int time) {
        Calendar calendar = AbstractCalendarValidatorTest.createCalendar(zone, date, time);
        return calendar.getTime();
    }

    @AfterEach
    protected void tearDown() {
        this.validator = null;
    }

    @Test
    void testFormat() {
        Object test = this.validator.parse("2005-11-28", "yyyy-MM-dd", null, null);
        Assertions.assertNotNull((Object)test, (String)"Test Date");
        Assertions.assertEquals((Object)"28.11.05", (Object)this.validator.format(test, "dd.MM.yy"), (String)"Format pattern");
        Assertions.assertEquals((Object)"11/28/05", (Object)this.validator.format(test, Locale.US), (String)"Format locale");
    }

    @Test
    void testLocaleInvalid() {
        for (int i = 0; i < this.localeInvalid.length; ++i) {
            String text = i + " value=[" + this.localeInvalid[i] + "] passed ";
            Object date = this.validator.parse(this.localeInvalid[i], null, Locale.US, null);
            Assertions.assertNull((Object)date, (String)("validateObj() " + text + date));
            Assertions.assertFalse((boolean)this.validator.isValid(this.localeInvalid[i], Locale.US), (String)("isValid() " + text));
        }
    }

    @Test
    void testLocaleValid() {
        for (int i = 0; i < this.localeValid.length; ++i) {
            String text = i + " value=[" + this.localeValid[i] + "] failed ";
            Object date = this.validator.parse(this.localeValid[i], null, Locale.US, null);
            Assertions.assertNotNull((Object)date, (String)("validateObj() " + text + date));
            Assertions.assertTrue((boolean)this.validator.isValid(this.localeValid[i], Locale.US), (String)("isValid() " + text));
            if (date instanceof Calendar) {
                date = ((Calendar)date).getTime();
            }
            Assertions.assertEquals((Object)this.patternExpect[i], (Object)date, (String)("compare " + text));
        }
    }

    @Test
    void testPatternInvalid() {
        for (int i = 0; i < this.patternInvalid.length; ++i) {
            String text = i + " value=[" + this.patternInvalid[i] + "] passed ";
            Object date = this.validator.parse(this.patternInvalid[i], "yy-MM-dd", null, null);
            Assertions.assertNull((Object)date, (String)("validateObj() " + text + date));
            Assertions.assertFalse((boolean)this.validator.isValid(this.patternInvalid[i], "yy-MM-dd"), (String)("isValid() " + text));
        }
    }

    @Test
    void testPatternValid() {
        for (int i = 0; i < this.patternValid.length; ++i) {
            String text = i + " value=[" + this.patternValid[i] + "] failed ";
            Object date = this.validator.parse(this.patternValid[i], "yy-MM-dd", null, null);
            Assertions.assertNotNull((Object)date, (String)("validateObj() " + text + date));
            Assertions.assertTrue((boolean)this.validator.isValid(this.patternValid[i], "yy-MM-dd"), (String)("isValid() " + text));
            if (date instanceof Calendar) {
                date = ((Calendar)date).getTime();
            }
            Assertions.assertEquals((Object)this.patternExpect[i], (Object)date, (String)("compare " + text));
        }
    }

    @Test
    void testSerialization() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this.validator);
            oos.flush();
        }
        catch (Exception e) {
            Assertions.fail((String)(this.validator.getClass().getName() + " error during serialization: " + e));
        }
        Object result = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());){
            ObjectInputStream ois = new ObjectInputStream(bais);
            result = ois.readObject();
        }
        catch (Exception e) {
            Assertions.fail((String)(this.validator.getClass().getName() + " error during deserialization: " + e));
        }
        Assertions.assertNotNull((Object)result);
    }
}

