/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.InterpolatorStringLookup;
import org.apache.commons.text.lookup.PropertiesStringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesStringLookupTest {
    private static final Path CURRENT_PATH = Paths.get("", new String[0]);
    private static final String DOC_RELATIVE = "src/test/resources/org/apache/commons/text/document.properties";
    private static final String DOC_ROOT = "/foo.txt";
    private static final String KEY = "mykey";
    private static final String KEY_RELATIVE = PropertiesStringLookup.toPropertyKey((String)"src/test/resources/org/apache/commons/text/document.properties", (String)"mykey");
    private static final String KEY_ROOT = PropertiesStringLookup.toPropertyKey((String)"/foo.txt", (String)"mykey");
    private static final Path[] NULL_PATH_ARRAY = null;

    public static void testFence(StringSubstitutor stringSubstitutor) {
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace("${properties:" + KEY_RELATIVE + "}"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> stringSubstitutor.replace("${file:UTF-8:/foo.txt}"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> stringSubstitutor.replace("${file:UTF-8:../foo.txt}"));
    }

    @Test
    void testFenceOne() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PropertiesStringLookup(new Path[]{CURRENT_PATH}).apply(KEY_ROOT));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PropertiesStringLookup(new Path[]{Paths.get("not a dir at all", new String[0]), CURRENT_PATH}).apply(KEY_ROOT));
    }

    @Test
    void testInterpolator() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace("${properties:" + KEY_RELATIVE + "}"));
    }

    @Test
    void testInterpolatorNestedColon() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        String replaced = stringSubstitutor.replace("$${properties:${sys:user.dir}/" + KEY_RELATIVE + "}");
        Assertions.assertEquals((Object)("${properties:" + System.getProperty("user.dir") + "/src/test/resources/org/apache/commons/text/document.properties::mykey}"), (Object)replaced);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace(replaced));
    }

    @Test
    void testInterpolatorReplace() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace("${properties:" + KEY_RELATIVE + "}"));
        InterpolatorStringLookup stringLookup = (InterpolatorStringLookup)stringSubstitutor.getStringLookup();
        stringLookup.getStringLookupMap().replace("file", StringLookupFactory.INSTANCE.fileStringLookup(new Path[]{CURRENT_PATH}));
        PropertiesStringLookupTest.testFence(stringSubstitutor);
    }

    @Test
    void testInterpolatorReplaceProperties() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace("${properties:" + KEY_RELATIVE + "}"));
        InterpolatorStringLookup stringLookup = (InterpolatorStringLookup)stringSubstitutor.getStringLookup();
        stringLookup.getStringLookupMap().replace("properties", StringLookupFactory.INSTANCE.propertiesStringLookup(new Path[]{CURRENT_PATH}));
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace("${properties:" + KEY_RELATIVE + "}"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> stringSubstitutor.replace("${properties:UTF-8:/foo.txt}"));
    }

    @Test
    void testInterpolatorWithParameterizedKey() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("KeyIsHere", KEY);
        StringSubstitutor stringSubstitutor = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(map));
        String replaced = stringSubstitutor.replace("$${properties:" + PropertiesStringLookup.toPropertyKey((String)DOC_RELATIVE, (String)"${KeyIsHere}}"));
        Assertions.assertEquals((Object)("${properties:" + PropertiesStringLookup.toPropertyKey((String)DOC_RELATIVE, (String)"mykey}")), (Object)replaced);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace(replaced));
    }

    @Test
    void testInterpolatorWithParameterizedKey2() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("KeyIsHere", KEY);
        StringSubstitutor stringSubstitutor = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(map));
        String replaced = stringSubstitutor.replace("$${properties:${sys:user.dir}/" + PropertiesStringLookup.toPropertyKey((String)DOC_RELATIVE, (String)"${KeyIsHere}}"));
        Assertions.assertEquals((Object)("${properties:" + System.getProperty("user.dir") + "/" + PropertiesStringLookup.toPropertyKey((String)DOC_RELATIVE, (String)"mykey}")), (Object)replaced);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace(replaced));
    }

    @Test
    void testMissingFile() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertiesStringLookup.INSTANCE.apply("MissingFile"));
    }

    @Test
    void testMissingFileWithKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertiesStringLookup.INSTANCE.apply(PropertiesStringLookup.toPropertyKey((String)"MissingFile", (String)"AnyKey")));
    }

    @Test
    void testMissingKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertiesStringLookup.INSTANCE.apply(DOC_RELATIVE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PropertiesStringLookup(new Path[0]).apply(DOC_RELATIVE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PropertiesStringLookup(NULL_PATH_ARRAY).apply(DOC_RELATIVE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PropertiesStringLookup(new Path[]{CURRENT_PATH}).apply(DOC_RELATIVE));
    }

    @Test
    void testNull() {
        Assertions.assertNull((Object)PropertiesStringLookup.INSTANCE.apply(null));
        Assertions.assertNull((Object)new PropertiesStringLookup(new Path[0]).apply(null));
        Assertions.assertNull((Object)new PropertiesStringLookup(NULL_PATH_ARRAY).apply(null));
        Assertions.assertNull((Object)new PropertiesStringLookup(new Path[]{CURRENT_PATH}).apply(null));
    }

    @Test
    void testOne() {
        Assertions.assertEquals((Object)"Hello World!", (Object)PropertiesStringLookup.INSTANCE.apply(KEY_RELATIVE));
        Assertions.assertEquals((Object)"Hello World!", (Object)new PropertiesStringLookup(new Path[0]).apply(KEY_RELATIVE));
        Assertions.assertEquals((Object)"Hello World!", (Object)new PropertiesStringLookup(NULL_PATH_ARRAY).apply(KEY_RELATIVE));
        Assertions.assertEquals((Object)"Hello World!", (Object)new PropertiesStringLookup(new Path[]{CURRENT_PATH}).apply(KEY_RELATIVE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PropertiesStringLookup(new Path[]{CURRENT_PATH}).apply(KEY_ROOT));
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)PropertiesStringLookup.INSTANCE.toString().isEmpty());
        Assertions.assertFalse((boolean)new PropertiesStringLookup(new Path[0]).toString().isEmpty());
        Assertions.assertFalse((boolean)new PropertiesStringLookup(NULL_PATH_ARRAY).toString().isEmpty());
        Assertions.assertFalse((boolean)new PropertiesStringLookup(new Path[]{CURRENT_PATH}).toString().isEmpty());
    }
}

