/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.ClassFunctions;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.NestedTestBean;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.TestFunctions;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.ri.model.dynabeans.DynaBeanModelTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractBeanModelTest
extends AbstractJXPathTest {
    private JXPathContext context;

    protected abstract Object createContextBean();

    protected abstract AbstractFactory getAbstractFactory();

    private int relativeProperty(PropertyPointer holder, int offset) {
        String[] names = holder.getPropertyNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals("integers")) continue;
            return i + offset;
        }
        return -1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.context = JXPathContext.newContext((Object)this.createContextBean());
        this.context.setLocale(Locale.US);
        this.context.setFactory(this.getAbstractFactory());
    }

    @Test
    public void testAttributeLang() {
        this.assertXPathValue(this.context, "@xml:lang", "en-US");
        this.assertXPathValue(this.context, "count(@xml:*)", 1.0);
        this.assertXPathValue(this.context, "lang('en')", Boolean.TRUE);
        this.assertXPathValue(this.context, "lang('fr')", Boolean.FALSE);
    }

    @Test
    public void testAttributeName() {
        this.assertXPathValue(this.context, "nestedBean[@name = 'int']", 1);
        this.assertXPathPointer(this.context, "nestedBean[@name = 'int']", "/nestedBean/int");
    }

    @Test
    public void testAxisAncestor() {
        this.assertXPathValue(this.context, "int/ancestor::root = /", Boolean.TRUE);
        this.assertXPathValue(this.context, "count(beans/name/ancestor-or-self::node())", 5.0);
        this.assertXPathValue(this.context, "beans/name/ancestor-or-self::node()[3] = /", Boolean.TRUE);
    }

    @Test
    public void testAxisAttribute() {
        this.assertXPathValue(this.context, "count(@*)", 21.0);
        this.assertXPathValueLenient(this.context, "@foo", null);
    }

    @Test
    public void testAxisChild() {
        this.assertXPathValue(this.context, "boolean", Boolean.FALSE);
        this.assertXPathPointer(this.context, "boolean", "/boolean");
        this.assertXPathPointerIterator(this.context, "boolean", AbstractBeanModelTest.list("/boolean"));
        this.assertXPathValue(this.context, "count(set)", 3.0);
        this.assertXPathValueIterator(this.context, "foo:boolean", AbstractBeanModelTest.list());
        this.assertXPathValue(this.context, "count(*)", 21.0);
        this.assertXPathValue(this.context, "count(child::node())", 21.0);
    }

    @Test
    public void testAxisChildNestedBean() {
        this.assertXPathValue(this.context, "nestedBean/name", "Name 0");
        this.assertXPathPointer(this.context, "nestedBean/name", "/nestedBean/name");
        this.assertXPathPointerIterator(this.context, "nestedBean/name", AbstractBeanModelTest.list("/nestedBean/name"));
    }

    @Test
    public void testAxisChildNestedCollection() {
        this.assertXPathValueIterator(this.context, "integers", AbstractBeanModelTest.list(1, 2, 3, 4));
        this.assertXPathPointer(this.context, "integers", "/integers");
        this.assertXPathPointerIterator(this.context, "integers", AbstractBeanModelTest.list("/integers[1]", "/integers[2]", "/integers[3]", "/integers[4]"));
    }

    @Test
    public void testAxisDescendant() {
        this.assertXPathValue(this.context, "count(descendant::node())", 65.0);
        this.assertXPathValue(this.context, "count(descendant::root)", 0.0);
        this.assertXPathValue(this.context, "count(descendant::name)", 7.0);
    }

    @Test
    public void testAxisDescendantOrSelf() {
        this.assertXPathValueIterator(this.context, "descendant-or-self::name", AbstractBeanModelTest.set("Name 1", "Name 2", "Name 3", "Name 6", "Name 0", "Name 5", "Name 4"));
        this.assertXPathValueIterator(this.context, "//name", AbstractBeanModelTest.set("Name 1", "Name 2", "Name 3", "Name 6", "Name 0", "Name 5", "Name 4"));
        this.assertXPathValue(this.context, "count(descendant-or-self::root)", 1.0);
        this.assertXPathValue(this.context, "count(nestedBean//.)", 7.0);
        this.assertXPathValue(this.context, "count(//self::beans)", 2.0);
        this.assertXPathValue(this.context, "count(descendant-or-self::node())", 66.0);
    }

    @Test
    public void testAxisFollowing() {
        this.assertXPathValue(this.context, "count(nestedBean/strings[2]/following::node())", 21.0);
        this.assertXPathValue(this.context, "count(nestedBean/strings[2]/following::strings)", 7.0);
    }

    @Test
    public void testAxisFollowingSibling() {
        this.assertXPathValue(this.context, "count(/nestedBean/following-sibling::node())", 8.0);
        this.assertXPathValue(this.context, "count(/nestedBean/following-sibling::object)", 1.0);
        this.assertXPathValue(this.context, "count(/nestedBean/boolean/../following-sibling::node())", 8.0);
        this.assertXPathValue(this.context, "count(/nestedBean/boolean/../following-sibling::object)", 1.0);
        this.assertXPathValue(this.context, "count(/descendant::boolean/following-sibling::node())", 53.0);
        this.assertXPathValue(this.context, "count(/descendant::boolean/following-sibling::name)", 7.0);
    }

    @Test
    public void testAxisParent() {
        this.assertXPathValue(this.context, "count(/beans/..)", 1.0);
        this.assertXPathValue(this.context, "count(//..)", 9.0);
        this.assertXPathValue(this.context, "count(//../..)", 2.0);
        this.assertXPathValueIterator(this.context, "//parent::beans/name", AbstractBeanModelTest.list("Name 1", "Name 2"));
    }

    @Test
    public void testAxisPreceding() {
        this.assertXPathValue(this.context, "count(beans[2]/int/preceding::node())", 8.0);
        this.assertXPathValue(this.context, "count(beans[2]/int/preceding::boolean)", 2.0);
    }

    @Test
    public void testAxisPrecedingSibling() {
        this.assertXPathValue(this.context, "count(/boolean/preceding-sibling::node())", 2.0);
        this.assertXPathValue(this.context, "count(/nestedBean/int/../preceding-sibling::node())", 12.0);
        this.assertXPathValue(this.context, "count(/descendant::int/preceding-sibling::node())", 10.0);
    }

    @Test
    public void testAxisSelf() {
        this.assertXPathValue(this.context, "self::node() = /", Boolean.TRUE);
        this.assertXPathValue(this.context, "self::root = /", Boolean.TRUE);
    }

    @Test
    public void testBooleanPredicate() {
        this.assertXPathValue(this.context, "beans[int > 2]/name", "Name 2");
        this.assertXPathValueIterator(this.context, "beans[int > 2]/name", AbstractBeanModelTest.list("Name 2"));
        this.assertXPathValueIterator(this.context, "beans[int >= 1]/name", AbstractBeanModelTest.list("Name 1", "Name 2"));
        this.assertXPathValueIterator(this.context, "beans[int < 2]/name", AbstractBeanModelTest.list("Name 1"));
        this.assertXPathValueIterator(this.context, "beans[int <= 3]/name", AbstractBeanModelTest.list("Name 1", "Name 2"));
        this.assertXPathValueIterator(this.context, "beans[1]/strings[string-length() = 8]", AbstractBeanModelTest.list("String 1", "String 2", "String 3"));
        this.assertXPathValueIterator(this.context, "//self::node()[name = 'Name 0']/name", AbstractBeanModelTest.list("Name 0"));
        this.assertXPathValue(this.context, "beans/strings[name(.)='strings'][2]", "String 2");
        this.assertXPathValueIterator(this.context, "//self::node()[name(.) = concat('n', 'a', 'm', 'e')]", AbstractBeanModelTest.list("Name 1", "Name 2", "Name 3", "Name 6", "Name 0", "Name 5", "Name 4"));
        this.assertXPathValueIterator(this.context, "integers[position()<3]", AbstractBeanModelTest.list(1, 2));
        this.context.getVariables().declareVariable("temp", this.context.getValue("beans"));
        this.assertXPathValueIterator(this.context, "$temp[int < 2]/int", AbstractBeanModelTest.list(1));
    }

    @Test
    public void testCoreFunctions() {
        this.assertXPathValue(this.context, "boolean(boolean)", Boolean.TRUE);
        this.assertXPathValue(this.context, "boolean(boolean = false())", Boolean.TRUE);
        this.assertXPathValue(this.context, "boolean(integers[position() < 3])", Boolean.TRUE);
        this.assertXPathValue(this.context, "boolean(integers[position() > 4])", Boolean.FALSE);
        this.assertXPathValue(this.context, "sum(integers)", 10.0);
        this.assertXPathValueAndPointer(this.context, "integers[last()]", 4, "/integers[4]");
        this.assertXPathValueAndPointer(this.context, "//strings[last()]", "String 3", "/beans[1]/strings[3]");
    }

    @Test
    public void testCreatePath() {
        this.context.setValue("nestedBean", null);
        this.assertXPathCreatePath(this.context, "/nestedBean/int", 1, "/nestedBean/int");
        Assertions.assertThrows(Exception.class, () -> this.assertXPathCreatePath(this.context, "/nestedBean/beans[last() + 1]", 1, "/nestedBean/beans[last() + 1]"), (String)"Exception thrown on invalid path for creation");
    }

    @Test
    public void testCreatePathAndSetValue() {
        this.context.setValue("nestedBean", null);
        this.assertXPathCreatePathAndSetValue(this.context, "/nestedBean/int", 2, "/nestedBean/int");
    }

    @Test
    public void testCreatePathAndSetValueCreateBeanExpandCollection() {
        this.context.setValue("nestedBean", null);
        this.assertXPathCreatePathAndSetValue(this.context, "/nestedBean/strings[2]", "Test", "/nestedBean/strings[2]");
    }

    @Test
    public void testCreatePathAndSetValueExpandExistingCollection() {
        this.assertXPathCreatePathAndSetValue(this.context, "/beans[3]/int", 2, "/beans[3]/int");
    }

    @Test
    public void testCreatePathAndSetValueExpandNewCollection() {
        this.context.setValue("beans", null);
        this.assertXPathCreatePathAndSetValue(this.context, "/beans[2]/int", 2, "/beans[2]/int");
    }

    @Test
    public void testCreatePathCreateBeanExpandCollection() {
        this.context.setValue("nestedBean", null);
        this.assertXPathCreatePath(this.context, "/nestedBean/strings[2]", "String 2", "/nestedBean/strings[2]");
    }

    @Test
    public void testCreatePathExpandExistingCollection() {
        this.assertXPathCreatePathAndSetValue(this.context, "/integers[5]", 3, "/integers[5]");
    }

    @Test
    public void testCreatePathExpandExistingCollectionAndSetProperty() {
        this.assertXPathCreatePath(this.context, "/beans[3]/int", 1, "/beans[3]/int");
    }

    @Test
    public void testCreatePathExpandNewCollection() {
        this.context.setValue("beans", null);
        this.assertXPathCreatePath(this.context, "/beans[2]/int", 1, "/beans[2]/int");
    }

    @Test
    public void testDocumentOrder() {
        this.assertDocumentOrder(this.context, "boolean", "int", -1);
        this.assertDocumentOrder(this.context, "integers[1]", "integers[2]", -1);
        this.assertDocumentOrder(this.context, "integers[1]", "integers[1]", 0);
        this.assertDocumentOrder(this.context, "nestedBean/int", "nestedBean", 1);
        this.assertDocumentOrder(this.context, "nestedBean/int", "nestedBean/strings", -1);
        this.assertDocumentOrder(this.context, "nestedBean/int", "object/int", -1);
    }

    @Test
    public void testIndexPredicate() {
        this.assertXPathValue(this.context, "integers[2]", 2);
        this.assertXPathPointer(this.context, "integers[2]", "/integers[2]");
        this.assertXPathPointerIterator(this.context, "integers[2]", AbstractBeanModelTest.list("/integers[2]"));
        this.assertXPathValue(this.context, "beans[1]/name", "Name 1");
        this.assertXPathPointer(this.context, "beans[1]/name", "/beans[1]/name");
        this.assertXPathValueIterator(this.context, "beans[1]/strings", AbstractBeanModelTest.list("String 1", "String 2", "String 3"));
        this.assertXPathValueIterator(this.context, "beans/strings[2]", AbstractBeanModelTest.list("String 2", "String 2"));
        this.assertXPathValue(this.context, "beans/strings[2]", "String 2");
        this.assertXPathValue(this.context, "(beans/strings[2])[1]", "String 2");
    }

    private void testIndividual(int relativePropertyIndex, int offset, boolean useStartLocation, boolean reverse, int expected) {
        PropertyOwnerPointer root = (PropertyOwnerPointer)NodePointer.newNodePointer((QName)new QName(null, "root"), (Object)this.createContextBean(), (Locale)Locale.getDefault());
        PropertyPointer start = null;
        if (useStartLocation) {
            start = root.getPropertyPointer();
            start.setPropertyIndex(this.relativeProperty(start, relativePropertyIndex));
            start.setIndex(offset);
        }
        NodeIterator it = root.childIterator((NodeTest)new NodeNameTest(new QName(null, "integers")), reverse, (NodePointer)start);
        int size = 0;
        while (it.setPosition(it.getPosition() + 1)) {
            ++size;
        }
        Assertions.assertEquals((int)expected, (int)size, (String)("ITERATIONS: Individual, relativePropertyIndex=" + relativePropertyIndex + ", offset=" + offset + ", useStartLocation=" + useStartLocation + ", reverse=" + reverse));
    }

    @Test
    public void testIndividualIterators() {
        this.testIndividual(1, 0, true, false, 0);
        this.testIndividual(-1, 0, true, false, 4);
        this.testIndividual(0, -1, true, true, 4);
        this.testIndividual(1, -1, true, true, 4);
        this.testIndividual(-1, -1, true, true, 0);
        this.testIndividual(0, 1, true, false, 2);
        this.testIndividual(0, 1, true, true, 1);
        this.testIndividual(0, 0, false, false, 4);
        this.testIndividual(0, 0, false, true, 4);
    }

    @Test
    public void testIterateAndSet() {
        JXPathContext context = JXPathContext.newContext((Object)this.createContextBean());
        Iterator it = context.iteratePointers("beans/int");
        int i = 5;
        while (it.hasNext()) {
            NodePointer pointer = (NodePointer)it.next();
            pointer.setValue((Object)i++);
        }
        it = context.iteratePointers("beans/int");
        ArrayList<Object> actual = new ArrayList<Object>();
        while (it.hasNext()) {
            actual.add(((Pointer)it.next()).getValue());
        }
        Assertions.assertEquals((Object)AbstractBeanModelTest.list(5, 6), actual, (String)"Iterating <beans/int>");
    }

    @Test
    public void testIteratePointerSetValue() {
        JXPathContext context = JXPathContext.newContext((Object)this.createContextBean());
        this.assertXPathValue(context, "/beans[1]/name", "Name 1");
        this.assertXPathValue(context, "/beans[2]/name", "Name 2");
        context.setValue("/beans[2]/name", (Object)"Name 2 set");
        this.assertXPathValue(context, "/beans[2]/name", "Name 2 set");
        context.setValue("/beans[2]/name", (Object)"Name 2");
        this.assertXPathValue(context, "/beans[2]/name", "Name 2");
        int iterCount = 0;
        Iterator iter = context.iteratePointers("/beans/name");
        while (iter.hasNext()) {
            ++iterCount;
            Pointer pointer = (Pointer)iter.next();
            String s = (String)pointer.getValue();
            s = s + "suffix";
            pointer.setValue((Object)s);
            Assertions.assertEquals((Object)s, (Object)pointer.getValue(), (String)"pointer.getValue");
            Assertions.assertEquals((Object)s, (Object)context.getValue(pointer.asPath()), (String)"context.getValue");
        }
        Assertions.assertEquals((int)2, (int)iterCount, (String)"Iteration count");
        this.assertXPathValue(context, "/beans[1]/name", "Name 1suffix");
        this.assertXPathValue(context, "/beans[2]/name", "Name 2suffix");
    }

    @Test
    public void testIteratePropertyArrayWithHasNext() {
        JXPathContext context = JXPathContext.newContext((Object)this.createContextBean());
        Iterator it = context.iteratePointers("/integers");
        ArrayList<String> actual = new ArrayList<String>();
        while (it.hasNext()) {
            actual.add(((Pointer)it.next()).asPath());
        }
        Assertions.assertEquals((Object)AbstractBeanModelTest.list("/integers[1]", "/integers[2]", "/integers[3]", "/integers[4]"), actual, (String)"Iterating 'hasNext'/'next'</integers>");
    }

    @Test
    public void testIteratePropertyArrayWithoutHasNext() {
        JXPathContext context = JXPathContext.newContext((Object)this.createContextBean());
        Iterator it = context.iteratePointers("/integers");
        ArrayList<String> actual = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            actual.add(((Pointer)it.next()).toString());
        }
        Assertions.assertEquals((Object)AbstractBeanModelTest.list("/integers[1]", "/integers[2]", "/integers[3]", "/integers[4]"), actual, (String)"Iterating 'next'</integers>");
    }

    private void testMultiple(int propertyIndex, int offset, boolean useStartLocation, boolean reverse, int expected) {
        PropertyOwnerPointer root = (PropertyOwnerPointer)NodePointer.newNodePointer((QName)new QName(null, "root"), (Object)this.createContextBean(), (Locale)Locale.getDefault());
        PropertyPointer start = null;
        if (useStartLocation) {
            start = root.getPropertyPointer();
            start.setPropertyIndex(propertyIndex);
            start.setIndex(offset);
        }
        NodeIterator it = root.childIterator(null, reverse, (NodePointer)start);
        int size = 0;
        while (it.setPosition(it.getPosition() + 1)) {
            ++size;
        }
        Assertions.assertEquals((int)expected, (int)size, (String)("ITERATIONS: Multiple, propertyIndex=" + propertyIndex + ", offset=" + offset + ", useStartLocation=" + useStartLocation + ", reverse=" + reverse));
    }

    @Test
    public void testMultipleIterators() {
        this.testMultiple(0, 0, true, false, 20);
        this.testMultiple(3, 0, true, false, 16);
        this.testMultiple(3, -1, true, true, 8);
        this.testMultiple(3, 0, true, true, 4);
        this.testMultiple(0, 0, false, false, 21);
        this.testMultiple(0, 0, false, true, 21);
        this.testMultiple(3, 1, true, false, 15);
        this.testMultiple(3, 3, true, false, 13);
    }

    @Test
    public void testRelativeContextAbsolutePath() {
        JXPathContext relative = this.context.getRelativeContext(this.context.getPointer("nestedBean"));
        this.assertXPathValueAndPointer(relative, "/integers[2]", 2, "/integers[2]");
    }

    @Test
    public void testRelativeContextInheritance() {
        this.context.setFunctions((Functions)new ClassFunctions(TestFunctions.class, "test"));
        JXPathContext relative = this.context.getRelativeContext(this.context.getPointer("nestedBean"));
        this.assertXPathValue(relative, "test:countPointers(strings)", 3);
    }

    @Test
    public void testRelativeContextParent() {
        JXPathContext relative = this.context.getRelativeContext(this.context.getPointer("nestedBean"));
        this.assertXPathValueAndPointer(relative, "../integers[2]", 2, "/integers[2]");
    }

    @Test
    public void testRelativeContextRelativePath() {
        JXPathContext relative = this.context.getRelativeContext(this.context.getPointer("nestedBean"));
        this.assertXPathValueAndPointer(relative, "int", 1, "/nestedBean/int");
    }

    @Test
    public void testRemoveAllArrayElements() {
        this.context.removeAll("nestedBean/strings");
        this.assertXPathValueIterator(this.context, "nestedBean/strings", AbstractBeanModelTest.list());
    }

    @Test
    public void testRemoveAllListElements() {
        this.context.removeAll("list");
        this.assertXPathValueIterator(this.context, "list", this instanceof DynaBeanModelTest ? AbstractBeanModelTest.list(null, null, null) : AbstractBeanModelTest.list());
    }

    @Test
    public void testRemoveAllMapEntries() {
        this.context.removeAll("map/*");
        this.assertXPathValue(this.context, "map", Collections.EMPTY_MAP);
    }

    @Test
    public void testRemovePathArrayElement() {
        this.context.removePath("nestedBean/strings[1]");
        Assertions.assertEquals((Object)"String 2", (Object)this.context.getValue("nestedBean/strings[1]"), (String)"Remove array element");
    }

    @Test
    public void testRemovePathBeanValue() {
        this.context.removePath("nestedBean");
        Assertions.assertNull((Object)this.context.getValue("nestedBean"), (String)"Remove collection element");
    }

    @Test
    public void testRemovePathPropertyValue() {
        this.context.removePath("nestedBean/int");
        Assertions.assertEquals((Object)0, (Object)this.context.getValue("nestedBean/int"), (String)"Remove property value");
    }

    @Test
    public void testRoot() {
        this.assertXPathValueAndPointer(this.context, "/", this.context.getContextBean(), "/");
    }

    @Test
    public void testSetCollectionElement() {
        this.assertXPathSetValue(this.context, "integers[2]", 5);
        this.assertXPathSetValue(this.context, "integers[2]", new int[]{6}, 6);
    }

    @Test
    public void testSetContextDependentNode() {
        this.assertXPathSetValue(this.context, "integers[position() = 1]", 8);
        this.assertXPathSetValue(this.context, "beans[name = 'Name 1']/int", 9);
    }

    @Test
    public void testSetNonPrimitiveValue() {
        this.assertXPathSetValue(this.context, "beans[2]", null);
        this.context.setValue("beans[2]", (Object)new NestedTestBean("Name 9"));
        Assertions.assertEquals((Object)"Name 9", (Object)this.context.getValue("beans[2]/name"), (String)"Modified <beans[2]/name>");
    }

    @Test
    public void testSetPropertyValue() {
        this.assertXPathSetValue(this.context, "int", 2);
        this.assertXPathSetValue(this.context, "int", "3", 3);
        this.assertXPathSetValue(this.context, "int", new int[]{4}, 4);
        this.assertXPathSetValue(this.context, "@int", 10);
    }

    @Test
    public void testUnion() {
        this.assertXPathValueIterator(this.context, "integers | beans[1]/strings", AbstractBeanModelTest.list("String 1", "String 2", "String 3", 1, 2, 3, 4));
        this.assertXPathValue(this.context, "count((integers | beans[1]/strings)[contains(., '1')])", 2.0);
        this.assertXPathValue(this.context, "count((integers | beans[1]/strings)[name(.) = 'strings'])", 3.0);
        this.assertXPathValue(this.context, "(integers)[2]", 2);
    }
}

