/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.control;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.CompositeCacheAttributes;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheType;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;

public class CompositeCacheDiskUsageUnitTest
extends TestCase {
    private static final String CACHE_NAME = "testSpoolAllowed";

    public void setUp() {
        JCS.setConfigFilename((String)"/TestDiskCacheUsagePattern.ccf");
    }

    public void testSwapConfig() throws CacheException {
        CacheAccess swap = JCS.getInstance((String)"Swap");
        CompositeCacheDiskUsageUnitTest.assertEquals((Object)ICompositeCacheAttributes.DiskUsagePattern.SWAP, (Object)swap.getCacheAttributes().getDiskUsagePattern());
    }

    public void testUpdateConfig() throws CacheException {
        CacheAccess swap = JCS.getInstance((String)"Update");
        CompositeCacheDiskUsageUnitTest.assertEquals((Object)ICompositeCacheAttributes.DiskUsagePattern.UPDATE, (Object)swap.getCacheAttributes().getDiskUsagePattern());
    }

    public void testSpoolAllowed() {
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setCacheName(CACHE_NAME);
        cattr.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.SWAP);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxCache mock = new MockAuxCache();
        mock.cacheType = ICacheType.CacheType.DISK_CACHE;
        cache.setAuxCaches(Arrays.asList(new AuxiliaryCache[]{mock}));
        CacheElement inputElement = new CacheElement(CACHE_NAME, (Object)"key", (Object)"value");
        cache.spoolToDisk((ICacheElement)inputElement);
        CompositeCacheDiskUsageUnitTest.assertEquals((String)"Wrong number of calls to the disk cache update.", (int)1, (int)mock.updateCount);
        CompositeCacheDiskUsageUnitTest.assertEquals((String)"Wrong element updated.", (Object)inputElement, mock.lastUpdatedItem);
    }

    public void testSpoolNotAllowed() {
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setCacheName(CACHE_NAME);
        cattr.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.UPDATE);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxCache mock = new MockAuxCache();
        mock.cacheType = ICacheType.CacheType.DISK_CACHE;
        cache.setAuxCaches(Arrays.asList(new AuxiliaryCache[]{mock}));
        CacheElement inputElement = new CacheElement(CACHE_NAME, (Object)"key", (Object)"value");
        cache.spoolToDisk((ICacheElement)inputElement);
        CompositeCacheDiskUsageUnitTest.assertEquals((String)"Wrong number of calls to the disk cache update.", (int)0, (int)mock.updateCount);
    }

    public void testUpdateAllowed() throws IOException {
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setCacheName(CACHE_NAME);
        cattr.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.UPDATE);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxCache mock = new MockAuxCache();
        mock.cacheType = ICacheType.CacheType.DISK_CACHE;
        cache.setAuxCaches(Arrays.asList(new AuxiliaryCache[]{mock}));
        CacheElement inputElement = new CacheElement(CACHE_NAME, (Object)"key", (Object)"value");
        cache.updateAuxiliaries((ICacheElement)inputElement, true);
        CompositeCacheDiskUsageUnitTest.assertEquals((String)"Wrong number of calls to the disk cache update.", (int)1, (int)mock.updateCount);
        CompositeCacheDiskUsageUnitTest.assertEquals((String)"Wrong element updated.", (Object)inputElement, mock.lastUpdatedItem);
    }

    public void testUpdateAllowed_localFalse() throws IOException {
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setCacheName(CACHE_NAME);
        cattr.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.UPDATE);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxCache mock = new MockAuxCache();
        mock.cacheType = ICacheType.CacheType.DISK_CACHE;
        cache.setAuxCaches(Arrays.asList(new AuxiliaryCache[]{mock}));
        CacheElement inputElement = new CacheElement(CACHE_NAME, (Object)"key", (Object)"value");
        cache.updateAuxiliaries((ICacheElement)inputElement, false);
        CompositeCacheDiskUsageUnitTest.assertEquals((String)"Wrong number of calls to the disk cache update.", (int)1, (int)mock.updateCount);
        CompositeCacheDiskUsageUnitTest.assertEquals((String)"Wrong element updated.", (Object)inputElement, mock.lastUpdatedItem);
    }

    public void testUpdateNotAllowed() throws IOException {
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setCacheName(CACHE_NAME);
        cattr.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.SWAP);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxCache mock = new MockAuxCache();
        mock.cacheType = ICacheType.CacheType.DISK_CACHE;
        cache.setAuxCaches(Arrays.asList(new AuxiliaryCache[]{mock}));
        CacheElement inputElement = new CacheElement(CACHE_NAME, (Object)"key", (Object)"value");
        cache.updateAuxiliaries((ICacheElement)inputElement, true);
        CompositeCacheDiskUsageUnitTest.assertEquals((String)"Wrong number of calls to the disk cache update.", (int)0, (int)mock.updateCount);
    }

    public void testUpdateAllowed_withOtherCaches() throws IOException {
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setCacheName(CACHE_NAME);
        cattr.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.UPDATE);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxCache mock = new MockAuxCache();
        mock.cacheType = ICacheType.CacheType.DISK_CACHE;
        MockAuxCache mockLateral = new MockAuxCache();
        mockLateral.cacheType = ICacheType.CacheType.LATERAL_CACHE;
        cache.setAuxCaches(Arrays.asList(new AuxiliaryCache[]{mock, mockLateral}));
        CacheElement inputElement = new CacheElement(CACHE_NAME, (Object)"key", (Object)"value");
        cache.updateAuxiliaries((ICacheElement)inputElement, false);
        CompositeCacheDiskUsageUnitTest.assertEquals((String)"Wrong number of calls to the disk cache update.", (int)1, (int)mock.updateCount);
        CompositeCacheDiskUsageUnitTest.assertEquals((String)"Wrong element updated.", (Object)inputElement, mock.lastUpdatedItem);
        CompositeCacheDiskUsageUnitTest.assertEquals((String)"Wrong number of calls to the lateral cache update.", (int)1, (int)mockLateral.updateCount);
        CompositeCacheDiskUsageUnitTest.assertEquals((String)"Wrong element updated with lateral.", (Object)inputElement, mockLateral.lastUpdatedItem);
    }

    public static class MockAuxCache<K, V>
    extends AbstractAuxiliaryCache<K, V> {
        public ICacheElement<K, V> lastUpdatedItem;
        public int updateCount;
        public ICacheType.CacheType cacheType = ICacheType.CacheType.DISK_CACHE;

        public void reset() {
            this.updateCount = 0;
            this.lastUpdatedItem = null;
        }

        public void update(ICacheElement<K, V> ce) throws IOException {
            this.lastUpdatedItem = ce;
            ++this.updateCount;
        }

        public ICacheElement<K, V> get(K key) throws IOException {
            return null;
        }

        public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) {
            return new HashMap();
        }

        public boolean remove(K key) throws IOException {
            return false;
        }

        public void removeAll() throws IOException {
        }

        public void dispose() throws IOException {
        }

        public int getSize() {
            return 0;
        }

        public CacheStatus getStatus() {
            return CacheStatus.ALIVE;
        }

        public String getCacheName() {
            return null;
        }

        public Set<K> getKeySet() throws IOException {
            return null;
        }

        public IStats getStatistics() {
            return null;
        }

        public String getStats() {
            return null;
        }

        public ICacheType.CacheType getCacheType() {
            return this.cacheType;
        }

        public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
            return null;
        }

        public void setCacheEventLogger(ICacheEventLogger cacheEventLogger) {
        }

        public void setElementSerializer(IElementSerializer elementSerializer) {
        }

        public String getEventLoggingExtraInfo() {
            return null;
        }

        public Map<K, ICacheElement<K, V>> getMatching(String pattern) throws IOException {
            return Collections.emptyMap();
        }
    }
}

