/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.indexed;

import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.disk.DiskTestObject;
import org.apache.commons.jcs3.auxiliary.disk.indexed.DiskTestObjectUtil;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.utils.timing.SleepUtil;

public class IndexedDiskCacheOptimizationUnitTest
extends TestCase {
    public void testBasicOptimization() throws Exception {
        ICacheElement<Integer, DiskTestObject>[] elements;
        int removeCount = 50;
        IndexedDiskCacheAttributes cattr = new IndexedDiskCacheAttributes();
        cattr.setCacheName("testOptimization");
        cattr.setMaxKeySize(100);
        cattr.setOptimizeAtRemoveCount(50);
        cattr.setDiskPath("target/test-sandbox/testOptimization");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        disk.removeAll();
        int numberToInsert = 150;
        for (ICacheElement<Integer, DiskTestObject> element : elements = DiskTestObjectUtil.createCacheElementsWithTestObjectsOfVariableSizes(150, cattr.getCacheName())) {
            disk.processUpdate(element);
        }
        Thread.sleep(1000L);
        long sizeBeforeRemove = disk.getDataFileSize();
        for (int i = 0; i < 50; ++i) {
            disk.processRemove((Object)i);
        }
        SleepUtil.sleepAtLeast(1000L);
        disk.optimizeFile();
        long sizeAfterRemove = disk.getDataFileSize();
        long expectedSizeAfterRemove = DiskTestObjectUtil.totalSize(elements, 50, elements.length);
        if (expectedSizeAfterRemove != sizeAfterRemove) {
            SleepUtil.sleepAtLeast(2000L);
        }
        IndexedDiskCacheOptimizationUnitTest.assertTrue((String)("The post optimization size should be smaller.sizeAfterRemove=" + sizeAfterRemove + " sizeBeforeRemove= " + sizeBeforeRemove), (sizeAfterRemove < sizeBeforeRemove ? 1 : 0) != 0);
        IndexedDiskCacheOptimizationUnitTest.assertEquals((String)"The file size is not as expected size.", (long)expectedSizeAfterRemove, (long)sizeAfterRemove);
    }
}

