/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.block;

import java.util.HashSet;
import java.util.Map;
import junit.extensions.ActiveTestSuite;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;

public class BlockDiskCacheSameRegionConcurrentUnitTest
extends TestCase {
    public BlockDiskCacheSameRegionConcurrentUnitTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        ActiveTestSuite suite = new ActiveTestSuite();
        suite.addTest((Test)new BlockDiskCacheSameRegionConcurrentUnitTest("testBlockDiskCache1"){

            public void runTest() throws Exception {
                this.runTestForRegion("blockRegion4", 0, 200);
            }
        });
        suite.addTest((Test)new BlockDiskCacheSameRegionConcurrentUnitTest("testBlockDiskCache2"){

            public void runTest() throws Exception {
                this.runTestForRegion("blockRegion4", 1000, 1200);
            }
        });
        suite.addTest((Test)new BlockDiskCacheSameRegionConcurrentUnitTest("testBlockDiskCache3"){

            public void runTest() throws Exception {
                this.runTestForRegion("blockRegion4", 2000, 2200);
            }
        });
        suite.addTest((Test)new BlockDiskCacheSameRegionConcurrentUnitTest("testBlockDiskCache4"){

            public void runTest() throws Exception {
                this.runTestForRegion("blockRegion4", 2200, 5200);
            }
        });
        return suite;
    }

    public void setUp() throws Exception {
        JCS.setConfigFilename((String)"/TestBlockDiskCacheCon.ccf");
    }

    public void runTestForRegion(String region, int start, int end) throws Exception {
        int i;
        CacheAccess jcs = JCS.getInstance((String)region);
        for (i = start; i <= end; ++i) {
            jcs.put((Object)(i + ":key"), (Object)(region + " data " + i + "-" + region));
        }
        for (i = start; i <= end; ++i) {
            String key = i + ":key";
            String value = (String)jcs.get((Object)key);
            BlockDiskCacheSameRegionConcurrentUnitTest.assertEquals((String)("Wrong value for key [" + key + "]"), (String)(region + " data " + i + "-" + region), (String)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i2 = start; i2 <= end; ++i2) {
            keys.add(i2 + ":key");
        }
        Map elements = jcs.getCacheElements(keys);
        for (int i3 = start; i3 <= end; ++i3) {
            ICacheElement element = (ICacheElement)elements.get(i3 + ":key");
            BlockDiskCacheSameRegionConcurrentUnitTest.assertNotNull((String)("element " + i3 + ":key is missing"), (Object)element);
            BlockDiskCacheSameRegionConcurrentUnitTest.assertEquals((String)("value " + i3 + ":key"), (String)(region + " data " + i3 + "-" + region), (String)((String)element.getVal()));
        }
    }
}

