/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.TestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junitpioneer.jupiter.SetSystemProperty;

@SetSystemProperty.SetSystemProperties(value={@SetSystemProperty(key="org.apache.commons.exec.lenient", value="false"), @SetSystemProperty(key="org.apache.commons.exec.debug", value="true")})
public class StandAloneTest {
    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testDefaultExecutorBuilderFromFile() throws Exception {
        Path testScript = TestUtil.resolveScriptPathForOS("./src/test/scripts/standalone");
        DefaultExecutor exec = DefaultExecutor.builder().setThreadFactory(Executors.defaultThreadFactory()).setExecuteStreamHandler((ExecuteStreamHandler)new PumpStreamHandler()).setWorkingDirectory(new File(".")).get();
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine cl = new CommandLine(testScript);
        exec.execute(cl);
        Assertions.assertTrue((boolean)new File("./target/mybackup.gz").exists());
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testDefaultExecutorBuilderFromPath() throws Exception {
        Path testScript = TestUtil.resolveScriptPathForOS("./src/test/scripts/standalone");
        DefaultExecutor exec = DefaultExecutor.builder().setThreadFactory(Executors.defaultThreadFactory()).setExecuteStreamHandler((ExecuteStreamHandler)new PumpStreamHandler()).setWorkingDirectory(Paths.get(".", new String[0])).get();
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine cl = new CommandLine(testScript);
        exec.execute(cl);
        Assertions.assertTrue((boolean)new File("./target/mybackup.gz").exists());
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testDefaultExecutorDefaultBuilder() throws Exception {
        Path testScript = TestUtil.resolveScriptPathForOS("./src/test/scripts/standalone");
        DefaultExecutor exec = DefaultExecutor.builder().get();
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine cl = new CommandLine(testScript);
        exec.execute(cl);
        Assertions.assertTrue((boolean)new File("./target/mybackup.gz").exists());
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testDefaultExecutorFromFile() throws Exception {
        Path testScript = TestUtil.resolveScriptPathForOS("./src/test/scripts/standalone");
        DefaultExecutor exec = new DefaultExecutor();
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine cl = new CommandLine(testScript);
        exec.execute(cl);
        Assertions.assertTrue((boolean)new File("./target/mybackup.gz").exists());
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testDefaultExecutorFromPath() throws Exception {
        Path testScript = TestUtil.resolveScriptPathForOS("./src/test/scripts/standalone");
        DefaultExecutor exec = new DefaultExecutor();
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine cl = new CommandLine(testScript);
        exec.execute(cl);
        Assertions.assertTrue((boolean)new File("./target/mybackup.gz").exists());
    }
}

