/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.List;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.AbstractCombinerTest;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.OverrideCombiner;
import org.apache.commons.configuration2.tree.QueryResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOverrideCombiner
extends AbstractCombinerTest {
    private ImmutableNode checkTable(BaseHierarchicalConfiguration config) {
        Assertions.assertEquals((int)0, (int)config.getMaxIndex("database.tables.table"));
        HierarchicalConfiguration c = config.configurationAt("database.tables.table");
        Assertions.assertEquals((Object)"documents", (Object)c.getString("name"));
        Assertions.assertEquals((int)2, (int)c.getMaxIndex("fields.field.name"));
        Assertions.assertEquals((Object)"docname", (Object)c.getString("fields.field(1).name"));
        NodeHandler nodeHandler = config.getNodeModel().getNodeHandler();
        List nds = config.getExpressionEngine().query((Object)((ImmutableNode)nodeHandler.getRootNode()), "database.tables.table", nodeHandler);
        Assertions.assertFalse((boolean)nds.isEmpty());
        Assertions.assertFalse((boolean)((QueryResult)nds.get(0)).isAttributeResult());
        return (ImmutableNode)((QueryResult)nds.get(0)).getNode();
    }

    @Override
    protected NodeCombiner createCombiner() {
        return new OverrideCombiner();
    }

    @Test
    void testAttributes() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((int)1, (int)config.getInt("gui.level[@min]"));
        Assertions.assertEquals((int)2, (int)config.getInt("gui.level[@default]"));
        Assertions.assertEquals((int)0, (int)config.getMaxIndex("database.tables.table(0)[@id]"));
        Assertions.assertEquals((int)1, (int)config.getInt("database.tables.table(0)[@id]"));
    }

    @Test
    void testCombinedTableList() throws ConfigurationException {
        this.combiner.addListNode("table");
        this.checkTable(this.createCombinedConfiguration());
    }

    @Test
    void testCombinedTableNoList() throws ConfigurationException {
        this.checkTable(this.createCombinedConfiguration());
    }

    @Test
    void testCombineProperties() {
        PropertiesConfiguration c1 = new PropertiesConfiguration();
        c1.addProperty("x.y.simpleCase", (Object)false);
        c1.addProperty("x.y.between", (Object)false);
        c1.addProperty("x.y.isDistinctFrom", (Object)false);
        c1.addProperty("x.y", (Object)false);
        PropertiesConfiguration c2 = new PropertiesConfiguration();
        c2.addProperty("x.y", (Object)true);
        c2.addProperty("x.y.between", (Object)true);
        c2.addProperty("x.y.comparison", (Object)true);
        c2.addProperty("x.y.in", (Object)true);
        c2.addProperty("x.y.isDistinctFrom", (Object)true);
        c2.addProperty("x.y.simpleCase", (Object)true);
        CombinedConfiguration config = new CombinedConfiguration((NodeCombiner)new OverrideCombiner());
        config.addConfiguration((Configuration)c1);
        config.addConfiguration((Configuration)c2);
        Assertions.assertFalse((boolean)config.getBoolean("x.y"));
        Assertions.assertFalse((boolean)config.getBoolean("x.y.between"));
        Assertions.assertFalse((boolean)config.getBoolean("x.y.isDistinctFrom"));
        Assertions.assertFalse((boolean)config.getBoolean("x.y.simpleCase"));
        Assertions.assertTrue((boolean)config.getBoolean("x.y.in"));
        Assertions.assertTrue((boolean)config.getBoolean("x.y.comparison"));
        Assertions.assertEquals((int)6, (int)config.size());
    }

    @Test
    void testListFromFirstStructure() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((int)0, (int)config.getMaxIndex("net.service.url"));
        Assertions.assertEquals((Object)"http://service1.org", (Object)config.getString("net.service.url"));
        Assertions.assertFalse((boolean)config.containsKey("net.service.url[@type]"));
    }

    @Test
    void testListFromSecondStructure() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((int)3, (int)config.getMaxIndex("net.server.url"));
        Assertions.assertEquals((Object)"http://testsvr.com", (Object)config.getString("net.server.url(2)"));
    }

    @Test
    void testOverrideValues() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((Object)"Admin", (Object)config.getString("base.services.security.login.user"));
        Assertions.assertEquals((Object)"default", (Object)config.getString("base.services.security.login.user[@type]"));
        Assertions.assertEquals((Object)"BeamMeUp", (Object)config.getString("base.services.security.login.passwd"));
        Assertions.assertEquals((Object)"secret", (Object)config.getString("base.services.security.login.passwd[@type]"));
    }

    @Test
    void testSimpleValues() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((int)0, (int)config.getMaxIndex("gui.bgcolor"));
        Assertions.assertEquals((Object)"green", (Object)config.getString("gui.bgcolor"));
        Assertions.assertEquals((Object)"yellow", (Object)config.getString("gui.selcolor"));
        Assertions.assertEquals((Object)"blue", (Object)config.getString("gui.fgcolor"));
        Assertions.assertEquals((int)1, (int)config.getInt("gui.level"));
    }
}

