/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.features.SpotInstanceApi;
import org.jclouds.logging.Logger;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class SpotInstanceRequestActive
implements Predicate<SpotInstanceRequest> {
    private final AWSEC2Api client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public SpotInstanceRequestActive(AWSEC2Api client) {
        this.client = client;
    }

    public boolean apply(SpotInstanceRequest spot) {
        this.logger.trace("looking for state on spot %s", new Object[]{spot});
        try {
            spot = this.refresh(spot);
            this.logger.trace("%s: looking for spot state %s: currently: %s", new Object[]{spot.getId(), SpotInstanceRequest.State.ACTIVE, spot.getState()});
            if (spot.getState() == SpotInstanceRequest.State.CANCELLED || spot.getState() == SpotInstanceRequest.State.CLOSED) {
                throw new IllegalStateException(String.format("spot request %s %s", new Object[]{spot.getId(), spot.getState()}));
            }
            if (spot.getFaultCode() != null) {
                throw new IllegalStateException(String.format("spot request %s fault code(%s) message(%s)", spot.getId(), spot.getFaultCode(), spot.getFaultMessage()));
            }
            return spot.getState() == SpotInstanceRequest.State.ACTIVE;
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private SpotInstanceRequest refresh(SpotInstanceRequest spot) {
        return (SpotInstanceRequest)Iterables.getOnlyElement(((SpotInstanceApi)this.client.getSpotInstanceApi().get()).describeSpotInstanceRequestsInRegion(spot.getRegion(), spot.getId()));
    }
}

