/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.machine.pool;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.BasicLocationRegistry;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.core.objs.proxy.SpecialBrooklynObjectConstructor;
import org.apache.brooklyn.entity.machine.pool.ServerPoolLocation;
import org.apache.brooklyn.util.text.KeyValueParser;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPoolLocationResolver
implements LocationResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ServerPoolLocationResolver.class);
    private static final String PREFIX = "pool";
    public static final String POOL_SPEC = "pool:%s";
    private static final Pattern PATTERN = Pattern.compile("(pool|" + "pool".toUpperCase() + "):([a-zA-Z0-9]+)(:\\((.*)\\))?$");
    private static final Set<String> ACCEPTABLE_ARGS = ImmutableSet.of((Object)"name");
    private ManagementContext managementContext;

    public boolean isEnabled() {
        return LocationConfigUtils.isResolverPrefixEnabled((ManagementContext)this.managementContext, (String)this.getPrefix());
    }

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public String getPrefix() {
        return PREFIX;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        return BasicLocationRegistry.isResolverPrefixForSpec((LocationResolver)this, (String)spec, (boolean)true);
    }

    public LocationSpec newLocationSpecFromString(String spec, Map locationFlags, LocationRegistry registry) {
        Matcher matcher;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving location '" + spec + "' with flags " + Joiner.on((String)",").withKeyValueSeparator("=").join(locationFlags));
        }
        if (!(matcher = PATTERN.matcher(spec)).matches()) {
            String m = String.format("Invalid location '%s'; must specify either %s:entityId or %s:entityId:(key=argument)", spec, PREFIX, PREFIX);
            throw new IllegalArgumentException(m);
        }
        String argsPart = matcher.group(4);
        Map argsMap = argsPart != null ? KeyValueParser.parseMap((String)argsPart) : Collections.emptyMap();
        String namePart = (String)argsMap.get("name");
        if (!ACCEPTABLE_ARGS.containsAll(argsMap.keySet())) {
            Sets.SetView illegalArgs = Sets.difference(argsMap.keySet(), ACCEPTABLE_ARGS);
            throw new IllegalArgumentException("Invalid location '" + spec + "'; illegal args " + illegalArgs + "; acceptable args are " + ACCEPTABLE_ARGS);
        }
        String poolLocId = matcher.group(2);
        if (Strings.isBlank((CharSequence)poolLocId)) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; pool's location id must be non-empty");
        }
        Location poolLoc = this.managementContext.getLocationManager().getLocation(poolLocId);
        if (poolLoc == null) {
            throw new IllegalArgumentException("Unknown ServerPool location id " + poolLocId + ", spec " + spec);
        }
        if (!(poolLoc instanceof ServerPoolLocation)) {
            throw new IllegalArgumentException("Invalid location id for ServerPool, spec " + spec + "; instead matches " + poolLoc);
        }
        return (LocationSpec)((LocationSpec)LocationSpec.create(ServerPoolLocation.class).configure(LocationConstructor.LOCATION, (Object)poolLoc)).configure(SpecialBrooklynObjectConstructor.Config.SPECIAL_CONSTRUCTOR, LocationConstructor.class);
    }

    @Beta
    public static class LocationConstructor
    implements SpecialBrooklynObjectConstructor {
        public static ConfigKey<Location> LOCATION = ConfigKeys.newConfigKey(Location.class, (String)"serverpoolresolver.location");

        public <T> T create(ManagementContext mgmt, Class<T> type, AbstractBrooklynObjectSpec<?, ?> spec) {
            return (T)Preconditions.checkNotNull(spec.getConfig().get(LOCATION), (Object)LOCATION.getName());
        }
    }
}

