/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.dsl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslDeferredSupplier;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.parse.PropertyAccess;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ValueResolver;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslDeferredPropertyAccess
extends BrooklynDslDeferredSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyAccess.class);
    BrooklynDslDeferredSupplier target;
    Object index;

    public DslDeferredPropertyAccess() {
    }

    public DslDeferredPropertyAccess(BrooklynDslDeferredSupplier target, Object index) {
        this.target = target;
        this.index = index;
    }

    public BrooklynDslDeferredSupplier getTarget() {
        return this.target;
    }

    public Object getIndex() {
        return this.index;
    }

    protected Object getIndexOnTarget(Object targetEvaluated) {
        Object targetResult = this.target.get();
        if (targetResult == null) {
            throw new IllegalStateException("Source was null when evaluating property '" + this.index + "' in " + this);
        }
        Exception failure = null;
        try {
            if (targetResult instanceof List) {
                return ((List)targetResult).get(Integer.parseInt(this.index.toString()));
            }
            if (targetResult instanceof Map) {
                return ((Map)targetResult).get(this.index);
            }
            if (this.index instanceof String) {
                String propName = (String)this.index;
                if (targetResult instanceof Configurable) {
                    return ((Configurable)targetResult).getConfig(ConfigKeys.newConfigKey(Object.class, (String)propName));
                }
                try {
                    Field field = targetResult.getClass().getDeclaredField(propName);
                    return field.get(targetResult);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Field " + propName + " not found on type " + targetResult.getClass(), (Throwable)e);
                    }
                    String getter = "get" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
                    try {
                        Method method = targetResult.getClass().getDeclaredMethod(getter, new Class[0]);
                        return method.invoke(targetResult, new Object[0]);
                    }
                    catch (Exception e2) {
                        Exceptions.propagateIfFatal((Throwable)e2);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Problem invoking method " + getter + " on type " + targetResult.getClass(), (Throwable)e2);
                        }
                        throw new IllegalStateException("Neither field and using getter)");
                    }
                }
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            failure = e;
        }
        throw new IllegalStateException("Unable to access property '" + this.index + "' on '" + targetResult + "' in " + this, failure);
    }

    public Task newTask() {
        return Tasks.builder().displayName("Retrieving property or index " + this.index).tag((Object)"TRANSIENT").dynamic(false).body((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ValueResolver r = Tasks.resolving((Object)DslDeferredPropertyAccess.this.target, Object.class).context(BrooklynDslDeferredSupplier.entity().getExecutionContext()).deep().immediately(false);
                return DslDeferredPropertyAccess.this.getIndexOnTarget(r);
            }
        }).build();
    }

    @JsonIgnore
    public Maybe getImmediately() {
        return this.target.getImmediately().transformNow(this::getIndexOnTarget);
    }

    public String toString() {
        if (this.dsl instanceof String && Strings.isNonBlank((CharSequence)((String)this.dsl))) {
            return (String)this.dsl;
        }
        return this.target + "[" + (this.index instanceof Integer ? this.index : StringEscapes.JavaStringEscapes.wrapJavaString((String)("" + this.index))) + "]";
    }
}

