/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.location.HardwareDetails;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineDetails;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.core.location.BasicHardwareDetails;
import org.apache.brooklyn.core.location.BasicMachineDetails;
import org.apache.brooklyn.core.location.BasicOsDetails;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.jclouds.JcloudsUtil;
import org.apache.brooklyn.location.jclouds.api.JcloudsLocationConfigPublic;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.config.ResolvingConfigBag;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.LoginCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsSshMachineLocation
extends SshMachineLocation
implements JcloudsMachineLocation {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsSshMachineLocation.class);
    @SetFromFlag
    JcloudsLocation jcloudsParent;
    @SetFromFlag
    @Deprecated
    NodeMetadata node;
    @SetFromFlag
    @Deprecated
    Template template;
    @SetFromFlag
    String nodeId;
    @SetFromFlag
    String imageId;
    @SetFromFlag
    Set<String> privateAddresses;
    @SetFromFlag
    Set<String> publicAddresses;
    @SetFromFlag
    String hostname;
    @SetFromFlag
    String privateHostname;
    private transient Optional<NodeMetadata> _node;
    private transient Optional<Template> _template;
    private transient Optional<Image> _image;

    public JcloudsSshMachineLocation() {
    }

    @Deprecated
    public JcloudsSshMachineLocation(Map<?, ?> flags, JcloudsLocation jcloudsParent, NodeMetadata node) {
        super(flags);
        this.jcloudsParent = jcloudsParent;
        this.init();
    }

    public void init() {
        if (this.jcloudsParent != null) {
            super.init();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Not doing init() of {} because parent not set; presuming rebinding", (Object)this);
        }
        this.clearDeprecatedProperties();
    }

    public void rebind() {
        super.rebind();
        if (this.jcloudsParent == null) {
            LOG.warn("Location {} does not have parent; cannot retrieve jclouds compute-service; later operations may fail (continuing)", (Object)this);
        }
        this.clearDeprecatedProperties();
    }

    protected void clearDeprecatedProperties() {
        if (this.node != null) {
            this.setNode(this.node);
        }
        if (this.template != null) {
            this.setTemplate(this.template);
        }
    }

    public String toVerboseString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.getId()).add("name", (Object)this.getDisplayName()).add("user", (Object)this.getUser()).add("address", (Object)this.getAddress()).add("port", this.getConfig(SSH_PORT)).add("node", this._node).add("nodeId", (Object)this.getJcloudsId()).add("imageId", (Object)this.getImageId()).add("privateAddresses", this.getPrivateAddresses()).add("publicAddresses", this.getPublicAddresses()).add("parentLocation", (Object)this.getParent()).add("osDetails", this.getOptionalOsDetails()).toString();
    }

    protected void setNode(NodeMetadata node) {
        this.node = null;
        this.config().removeKey("node");
        this.nodeId = node.getId();
        this.imageId = node.getImageId();
        this.publicAddresses = node.getPublicAddresses();
        this._node = Optional.of((Object)node);
        Boolean useMachinePublicAddressAsPrivateAddress = (Boolean)this.config().get(JcloudsLocationConfigPublic.USE_MACHINE_PUBLIC_ADDRESS_AS_PRIVATE_ADDRESS);
        if (useMachinePublicAddressAsPrivateAddress.booleanValue()) {
            LOG.debug("Overriding private address [" + node.getPrivateAddresses() + "] as public address [" + node.getPublicAddresses() + "] as config " + JcloudsLocationConfigPublic.USE_MACHINE_PUBLIC_ADDRESS_AS_PRIVATE_ADDRESS + " is set to true");
            this.privateAddresses = node.getPublicAddresses();
        } else {
            this.privateAddresses = node.getPrivateAddresses();
        }
    }

    protected void setTemplate(Template template) {
        this.template = null;
        this.config().removeKey("template");
        this._template = Optional.of((Object)template);
        this._image = Optional.fromNullable((Object)template.getImage());
    }

    protected ComputeService getComputeServiceOrNull() {
        JcloudsLocation parent = this.getParent();
        return parent != null ? parent.getComputeService() : null;
    }

    @Override
    public Optional<NodeMetadata> getOptionalNode() {
        if (this._node == null) {
            try {
                ComputeService computeService = this.getComputeServiceOrNull();
                if (computeService == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cannot get node for {}, because cannot get compute-service from parent {}", (Object)this, (Object)this.getParent());
                    }
                    this._node = Optional.absent();
                } else {
                    this._node = Optional.fromNullable((Object)computeService.getNodeMetadata(this.nodeId));
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Problem getting node-metadata for " + this + ", node id " + this.nodeId + " (continuing)", (Throwable)e);
                }
                this._node = Optional.absent();
            }
        }
        return this._node;
    }

    protected Optional<Image> getOptionalImage() {
        if (this._image == null) {
            if (this.imageId == null) {
                this._image = Optional.absent();
            } else {
                try {
                    ComputeService computeService = this.getComputeServiceOrNull();
                    if (computeService == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Cannot get image (with id {}) for {}, because cannot get compute-service from parent {}", new Object[]{this.imageId, this, this.getParent()});
                        }
                        this._image = Optional.absent();
                    } else {
                        this._image = Optional.fromNullable((Object)computeService.getImage(this.imageId));
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Problem getting image for " + this + ", image id " + this.imageId + " (continuing)", (Throwable)e);
                    }
                    this._image = Optional.absent();
                }
            }
        }
        return this._image;
    }

    @Deprecated
    protected Optional<Template> getOptionalTemplate() {
        if (this._template == null) {
            this._template = Optional.absent();
        }
        return this._template;
    }

    @Override
    @Deprecated
    public NodeMetadata getNode() {
        Optional<NodeMetadata> result = this.getOptionalNode();
        if (result.isPresent()) {
            return (NodeMetadata)result.get();
        }
        throw new IllegalStateException("Node " + this.nodeId + " not present in " + this.getParent());
    }

    @VisibleForTesting
    Optional<NodeMetadata> peekNode() {
        return this._node;
    }

    @Override
    public JcloudsLocation getParent() {
        return this.jcloudsParent;
    }

    public void setParent(Location newParent, boolean updateChildListParents) {
        if (newParent == null || newParent instanceof JcloudsLocation) {
            this.jcloudsParent = (JcloudsLocation)newParent;
        }
        super.setParent(newParent, updateChildListParents);
    }

    public String getHostname() {
        if (this.hostname == null) {
            Optional<NodeMetadata> node = this.getOptionalNode();
            if (node.isPresent()) {
                HostAndPort sshHostAndPort = this.getSshHostAndPort();
                Supplier<LoginCredentials> creds = this.getLoginCredentialsSupplier();
                this.hostname = this.jcloudsParent.getPublicHostname((NodeMetadata)node.get(), (Optional<HostAndPort>)Optional.of((Object)sshHostAndPort), creds, this.config().getBag());
                this.requestPersist();
            } else {
                this.hostname = JavaGroovyEquivalents.groovyTruth(this.getPublicAddresses()) ? this.getPublicAddresses().iterator().next() : (JavaGroovyEquivalents.groovyTruth(this.getPrivateAddresses()) ? this.getPrivateAddresses().iterator().next() : this.getAddress().getHostAddress());
            }
            LOG.debug("Resolved hostname {} for {}", (Object)this.hostname, (Object)this);
            this.requestPersist();
        }
        return this.hostname;
    }

    public Set<String> getPublicAddresses() {
        return this.publicAddresses == null ? ImmutableSet.of() : this.publicAddresses;
    }

    public Set<String> getPrivateAddresses() {
        return this.privateAddresses == null ? ImmutableSet.of() : this.privateAddresses;
    }

    @Override
    public String getSubnetHostname() {
        if (this.privateHostname == null) {
            Optional<NodeMetadata> node = this.getOptionalNode();
            if (node.isPresent()) {
                HostAndPort sshHostAndPort = this.getSshHostAndPort();
                Supplier<LoginCredentials> creds = this.getLoginCredentialsSupplier();
                this.privateHostname = this.jcloudsParent.getPrivateHostname((NodeMetadata)node.get(), (Optional<HostAndPort>)Optional.of((Object)sshHostAndPort), creds, this.config().getBag());
            } else {
                for (String p : this.getPrivateAddresses()) {
                    if (Networking.isLocalOnly((String)p)) continue;
                    this.privateHostname = p;
                    break;
                }
                if (Strings.isBlank((CharSequence)this.privateHostname) && JavaGroovyEquivalents.groovyTruth(this.getPublicAddresses())) {
                    this.privateHostname = this.getPublicAddresses().iterator().next();
                } else if (Strings.isBlank((CharSequence)this.privateHostname)) {
                    this.privateHostname = this.getHostname();
                }
            }
            this.requestPersist();
            LOG.debug("Resolved subnet hostname {} for {}", (Object)this.privateHostname, (Object)this);
        }
        return this.privateHostname;
    }

    public String getSubnetIp() {
        Optional<String> privateAddress = this.getPrivateAddress();
        if (privateAddress.isPresent()) {
            return (String)privateAddress.get();
        }
        if (JavaGroovyEquivalents.groovyTruth(this.getPublicAddresses())) {
            return this.getPublicAddresses().iterator().next();
        }
        return null;
    }

    protected Optional<String> getPrivateAddress() {
        for (String p : this.getPrivateAddresses()) {
            if (Networking.isLocalOnly((String)p)) continue;
            return Optional.of((Object)p);
        }
        return Optional.absent();
    }

    @Override
    public String getJcloudsId() {
        return this.nodeId;
    }

    protected String getImageId() {
        return this.imageId;
    }

    @Deprecated
    public String waitForPassword() {
        Optional<NodeMetadata> node = this.getOptionalNode();
        if (node.isPresent()) {
            if (this.jcloudsParent.getProvider().equals("aws-ec2")) {
                try {
                    return JcloudsUtil.waitForPasswordOnAws(this.jcloudsParent.getComputeService(), (NodeMetadata)node.get(), 15L, TimeUnit.MINUTES);
                }
                catch (TimeoutException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            LoginCredentials credentials = ((NodeMetadata)node.get()).getCredentials();
            return credentials != null ? (String)credentials.getOptionalPassword().orNull() : null;
        }
        throw new IllegalStateException("Node " + this.nodeId + " not present in " + this.getParent());
    }

    private Supplier<LoginCredentials> getLoginCredentialsSupplier() {
        return new Supplier<LoginCredentials>(){

            public LoginCredentials get() {
                return JcloudsSshMachineLocation.this.getLoginCredentials();
            }
        };
    }

    private LoginCredentials getLoginCredentials() {
        LocationConfigUtils.OsCredential creds = LocationConfigUtils.getOsCredential((ConfigBag)new ResolvingConfigBag(this.getManagementContext(), this.config().getBag()), (ResourceUtils)ResourceUtils.create((Object)this));
        return LoginCredentials.builder().user(this.getUser()).privateKey(creds.hasKey() ? creds.getPrivateKeyData() : null).password(creds.hasPassword() ? creds.getPassword() : null).build();
    }

    protected Optional<OsDetails> getOptionalOsDetails() {
        Optional machineDetails = this.getOptionalMachineDetails();
        OsDetails result = machineDetails.isPresent() ? ((MachineDetails)machineDetails.get()).getOsDetails() : null;
        return Optional.fromNullable((Object)result);
    }

    protected Optional<OperatingSystem> getOptionalOperatingSystem() {
        Optional<Image> image;
        OperatingSystem os;
        Optional<NodeMetadata> node = this.getOptionalNode();
        OperatingSystem operatingSystem = os = node.isPresent() ? ((NodeMetadata)node.get()).getOperatingSystem() : null;
        if (os == null && (image = this.getOptionalImage()).isPresent()) {
            os = ((Image)image.get()).getOperatingSystem();
        }
        return Optional.fromNullable((Object)os);
    }

    protected Optional<Hardware> getOptionalHardware() {
        Optional<NodeMetadata> node = this.getOptionalNode();
        return Optional.fromNullable(node.isPresent() ? ((NodeMetadata)node.get()).getHardware() : null);
    }

    protected MachineDetails detectMachineDetails() {
        Optional cpus;
        Optional ram;
        Optional name = Optional.absent();
        Optional version = Optional.absent();
        Optional architecture = Optional.absent();
        Optional<OperatingSystem> os = this.getOptionalOperatingSystem();
        Optional<Hardware> hardware = this.getOptionalHardware();
        if (os.isPresent()) {
            OsFamily family = ((OperatingSystem)os.get()).getFamily();
            String versionRaw = ((OperatingSystem)os.get()).getVersion();
            boolean is64Bit = ((OperatingSystem)os.get()).is64Bit();
            name = Optional.fromNullable(family != null && !OsFamily.UNRECOGNIZED.equals((Object)family) ? family.toString() : null);
            version = Optional.fromNullable((Object)(Strings.isNonBlank((CharSequence)versionRaw) ? versionRaw : null));
            architecture = Optional.fromNullable((Object)(is64Bit ? "x86_64" : "i386"));
        }
        Optional optional = ram = hardware.isPresent() ? Optional.fromNullable((Object)((Hardware)hardware.get()).getRam()) : Optional.absent();
        Optional optional2 = hardware.isPresent() ? Optional.fromNullable(((Hardware)hardware.get()).getProcessors() != null ? Integer.valueOf(((Hardware)hardware.get()).getProcessors().size()) : null) : (cpus = Optional.absent());
        if (name.isPresent() && version.isPresent() && architecture.isPresent() && ram.isPresent() && cpus.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Gathered machine details from Jclouds, skipping SSH test on {}", (Object)this);
            }
            BasicOsDetails osD = new BasicOsDetails((String)name.get(), (String)architecture.get(), (String)version.get());
            BasicHardwareDetails hwD = new BasicHardwareDetails((Integer)cpus.get(), (Integer)ram.get());
            return new BasicMachineDetails((HardwareDetails)hwD, (OsDetails)osD);
        }
        if (!this.isManaged() || "false".equalsIgnoreCase((String)this.getConfig(JcloudsLocation.WAIT_FOR_SSHABLE))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Machine details for {} missing from Jclouds, but skipping SSH test because {}. name={}, version={}, arch={}, ram={}, #cpus={}", new Object[]{this, this.isManaged() ? "waitForSshable=false" : "unmanaged", name, version, architecture, ram, cpus});
            }
            BasicOsDetails osD = new BasicOsDetails((String)name.orNull(), (String)architecture.orNull(), (String)version.orNull());
            BasicHardwareDetails hwD = new BasicHardwareDetails((Integer)cpus.orNull(), (Integer)ram.orNull());
            return new BasicMachineDetails((HardwareDetails)hwD, (OsDetails)osD);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Machine details for {} missing from Jclouds, using SSH test instead. name={}, version={}, arch={}, ram={}, #cpus={}", new Object[]{this, name, version, architecture, ram, cpus});
        }
        return super.detectMachineDetails();
    }

    public Map<String, String> toMetadataRecord() {
        JcloudsLocation parent = this.getParent();
        Optional<NodeMetadata> node = this.getOptionalNode();
        Optional<Hardware> hardware = this.getOptionalHardware();
        List processors = hardware.isPresent() ? ((Hardware)hardware.get()).getProcessors() : null;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(super.toMetadataRecord());
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "provider", parent != null ? parent.getProvider() : null);
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "account", parent != null ? parent.getIdentity() : null);
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "region", parent != null ? parent.getRegion() : null);
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "endpoint", parent != null ? parent.getEndpoint() : null);
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "serverId", this.getJcloudsId());
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "hostname", this.getHostname());
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "address", this.getAddress() != null ? this.getAddress().getHostAddress() : null);
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "subnetHostname", this.getSubnetHostname());
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "subnetAddress", this.getSubnetIp());
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "imageId", this.getImageId());
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "instanceTypeName", hardware.isPresent() ? ((Hardware)hardware.get()).getName() : null);
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "instanceTypeId", hardware.isPresent() ? ((Hardware)hardware.get()).getProviderId() : null);
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "ram", "" + (hardware.isPresent() ? Integer.valueOf(((Hardware)hardware.get()).getRam()) : null));
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "cpus", "" + (processors != null ? Integer.valueOf(processors.size()) : null));
        try {
            OsDetails osDetails = this.getOsDetails();
            this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "osName", osDetails.getName());
            this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "osArch", osDetails.getArch());
            this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "is64bit", osDetails.is64bit() ? "true" : "false");
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.warn("Unable to get OS Details for " + node + "; continuing", (Throwable)e);
        }
        return builder.build();
    }

    private void putIfNotNull(ImmutableMap.Builder<String, String> builder, String key, @Nullable String value) {
        if (value != null) {
            builder.put((Object)key, (Object)value);
        }
    }
}

