/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.google.common.collect.HashMultimap;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Set;

public class HashMultimapConverter
extends CollectionConverter {
    public HashMultimapConverter(Mapper mapper) {
        super(mapper);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        HashMultimap hashMultimap = (HashMultimap)source;
        writer.addAttribute("serialization", "custom");
        writer.startNode("unserializable-parents");
        writer.endNode();
        writer.startNode(HashMultimap.class.getCanonicalName());
        writer.startNode("default");
        writer.endNode();
        writer.startNode("int");
        writer.setValue("2");
        writer.endNode();
        writer.startNode("int");
        Set keys = hashMultimap.keys().elementSet();
        int distinctKeys = hashMultimap.asMap().size();
        writer.setValue(Integer.toString(distinctKeys));
        writer.endNode();
        keys.forEach(key -> {
            this.writeCompleteItem(key, context, writer);
            Set entry = hashMultimap.get(key);
            writer.startNode("int");
            writer.setValue(Integer.toString(entry.size()));
            writer.endNode();
            entry.forEach(child -> this.writeCompleteItem(child, context, writer));
        });
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        int extraDowns = 0;
        reader.moveDown();
        if (reader.getNodeName().equals("unserializable-parents")) {
            reader.moveUp();
            reader.moveDown();
        }
        if (reader.getNodeName().equals("com.google.common.collect.HashMultimap") || reader.getNodeName().equals("com.google.guava:com.google.common.collect.HashMultimap")) {
            reader.moveDown();
            ++extraDowns;
        }
        if (reader.getNodeName().equals("default")) {
            reader.moveUp();
            reader.moveDown();
        }
        reader.moveUp();
        reader.moveDown();
        String value = reader.getValue();
        int distinctKeys = Integer.parseInt(value);
        reader.moveUp();
        HashMultimap objectObjectHashMultimap = HashMultimap.create();
        for (int i = 0; i < distinctKeys; ++i) {
            Object key = this.readCompleteItem(reader, context, null);
            reader.moveDown();
            int children = Integer.parseInt(reader.getValue());
            reader.moveUp();
            for (int j = 0; j < children; ++j) {
                Object child = this.readCompleteItem(reader, context, null);
                objectObjectHashMultimap.put(key, child);
            }
        }
        while (extraDowns-- > 0) {
            reader.moveUp();
        }
        return objectObjectHashMultimap;
    }

    public boolean canConvert(Class type) {
        return HashMultimap.class.isAssignableFrom(type);
    }
}

