/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.resolve.jackson.JsonPassThroughDeserializer;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.workflow.WorkflowCommonConfig;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.WorkflowReplayUtils;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepResolution;
import org.apache.brooklyn.core.workflow.utils.WorkflowConcurrencyParser;
import org.apache.brooklyn.core.workflow.utils.WorkflowRetentionParser;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomWorkflowStep
extends WorkflowStepDefinition
implements WorkflowStepDefinition.WorkflowStepDefinitionWithSpecialDeserialization,
WorkflowStepDefinition.WorkflowStepDefinitionWithSubWorkflow {
    private static final Logger LOG = LoggerFactory.getLogger(CustomWorkflowStep.class);
    public static final String SHORTHAND_TYPE_NAME_DEFAULT = "workflow";
    public static final String TARGET_VAR_NAME_DEFAULT = "target";
    public static final String TARGET_INDEX_VAR_NAME_DEFAULT = "target_index";
    private static final String WORKFLOW_SETTING_SHORTHAND = "[ \"replayable\" ${replayable...} ] [ \"retention\" ${retention...} ] ";
    String shorthand;
    protected String retention;
    protected Object target;
    protected Object target_var_name;
    protected Object target_index_var_name;
    protected Object lock;
    protected Object concurrency;
    protected Map<String, Object> parameters;
    @JsonDeserialize(contentUsing=JsonPassThroughDeserializer.class)
    protected List<Object> steps;
    protected Object workflowOutput;
    protected Map<String, Object> reducing;

    public CustomWorkflowStep() {
    }

    public CustomWorkflowStep(String name, List<Object> steps) {
        this.name = name;
        this.steps = steps;
    }

    public CustomWorkflowStep(CustomWorkflowStep base) {
        this.retention = base.retention;
        this.target = base.target;
        this.target_var_name = base.target_var_name;
        this.target_index_var_name = base.target_index_var_name;
        this.lock = base.lock;
        this.concurrency = base.concurrency;
        this.parameters = base.parameters;
        this.steps = base.steps;
        this.workflowOutput = base.workflowOutput;
        this.reducing = base.reducing;
        this.id = base.id;
        this.name = base.name;
        this.metadata = base.metadata;
        this.userSuppliedShorthand = base.userSuppliedShorthand;
        this.shorthandTypeName = base.shorthandTypeName;
        this.input = base.input;
        this.next = base.next;
        this.condition = base.condition;
        this.output = base.output;
        this.replayable = base.replayable;
        this.idempotent = base.idempotent;
        this.timeout = base.timeout;
        this.onError = base.onError;
    }

    @JsonCreator
    public CustomWorkflowStep(List<Object> steps) {
        this.steps = steps;
    }

    @Override
    public void populateFromShorthand(String value) {
        if (this.shorthand == null) {
            if (SHORTHAND_TYPE_NAME_DEFAULT.equals(this.shorthandTypeName)) {
                this.shorthand = WORKFLOW_SETTING_SHORTHAND;
            } else {
                throw new IllegalStateException("Shorthand not supported for " + this.getNameOrDefault());
            }
        }
        if (this.input == null) {
            this.input = MutableMap.of();
        }
        this.populateFromShorthandTemplate(this.shorthand, value);
        this.replayable = (String)this.input.remove("replayable");
        this.retention = (String)this.input.remove("retention");
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        if (this.steps instanceof List) {
            if (this.steps.isEmpty()) {
                throw new IllegalArgumentException("Workflow `steps` must be supplied for a custom or nested workflow");
            }
            WorkflowStepResolution.resolveSteps(mgmt, this.steps, null);
        } else {
            if (this.steps != null) {
                throw new IllegalArgumentException("Workflow `steps` must be a list");
            }
            if (this.target != null) {
                throw new IllegalArgumentException("Workflow cannot take a `target` without `steps`");
            }
        }
    }

    @Override
    protected boolean isOutputHandledByTask() {
        return true;
    }

    @Override
    public List<Object> getOnError() {
        return null;
    }

    @Override
    @JsonIgnore
    public Object getConditionRaw() {
        if (this.target != null) {
            return null;
        }
        return super.getConditionRaw();
    }

    @Override
    protected Pair<WorkflowReplayUtils.ReplayableAtStepOption, Boolean> validateReplayableAndIdempotent() {
        return WorkflowReplayUtils.validateReplayableAndIdempotentAtStep(this.replayable, this.idempotent, true);
    }

    @Override
    @JsonIgnore
    public WorkflowStepDefinition.SubWorkflowsForReplay getSubWorkflowsForReplay(WorkflowStepInstanceExecutionContext context, boolean forced, boolean peekingOnly, boolean allowInternallyEvenIfDisabled) {
        return WorkflowReplayUtils.getSubWorkflowsForReplay(context, forced, peekingOnly, allowInternallyEvenIfDisabled, sw -> {
            sw.isResumableOnlyAtParent = true;
        });
    }

    @Override
    public Object doTaskBodyWithSubWorkflowsForReplay(WorkflowStepInstanceExecutionContext context, @Nonnull List<WorkflowExecutionContext> subworkflows, WorkflowStepDefinition.ReplayContinuationInstructions instructions) {
        boolean wasList = Boolean.TRUE.equals(this.getStepState((WorkflowStepInstanceExecutionContext)context).wasList);
        return this.runSubworkflowsWithConcurrency(context, subworkflows, this.getStepState((WorkflowStepInstanceExecutionContext)context).reducing, wasList, true, instructions);
    }

    void setStepState(WorkflowStepInstanceExecutionContext context, StepState state, boolean persist) {
        context.setStepState(state, persist);
    }

    @Override
    protected StepState getStepState(WorkflowStepInstanceExecutionContext context) {
        StepState result = (StepState)super.getStepState(context);
        if (result == null) {
            result = new StepState();
            this.setStepState(context, result, false);
        }
        return result;
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        if (this.retention != null) {
            context.getWorkflowExectionContext().updateRetentionFrom(WorkflowRetentionParser.parse(this.retention, context.getWorkflowExectionContext()).init(context.getWorkflowExectionContext()));
        }
        if (this.steps == null) {
            return context.getPreviousStepOutput();
        }
        Object targetR = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_INPUT, this.target, Object.class);
        if (targetR instanceof String) {
            targetR = this.getTargetFromString(context, (String)targetR);
        }
        MutableList nestedWorkflowContext = MutableList.of();
        boolean wasList = targetR instanceof Iterable;
        targetR = this.checkTarget(targetR);
        Map reducingV = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_INPUT, this.reducing, Map.class);
        AtomicInteger index = new AtomicInteger(0);
        ((Iterable)targetR).forEach(arg_0 -> this.lambda$doTaskBody$1(context, wasList, index, (List)nestedWorkflowContext, arg_0));
        StepState state = this.getStepState(context);
        state.wasList = wasList;
        state.reducing = reducingV;
        this.setStepState(context, state, false);
        WorkflowReplayUtils.setNewSubWorkflows(context, nestedWorkflowContext.stream().map(BrooklynTaskTags::tagForWorkflow).collect(Collectors.toList()), Tasks.current().getId());
        nestedWorkflowContext.forEach(n -> n.persist());
        return this.runSubworkflowsWithConcurrency(context, (List<WorkflowExecutionContext>)nestedWorkflowContext, reducingV, wasList, false, null);
    }

    protected Iterable checkTarget(Object targetR) {
        if (targetR instanceof Iterable) {
            return (Iterable)targetR;
        }
        if (targetR != null && !(targetR instanceof Entity)) {
            throw new IllegalArgumentException("Target of workflow must be an entity, a list, or an expression that resolves to a list");
        }
        return MutableList.of((Object)targetR);
    }

    private Object runSubworkflowsWithConcurrency(WorkflowStepInstanceExecutionContext context, List<WorkflowExecutionContext> nestedWorkflowContexts, Map reducingV, boolean wasList, boolean isReplaying, WorkflowStepDefinition.ReplayContinuationInstructions instructionsIfReplaying) {
        Object returnValue;
        LOG.debug("Running sub-workflows " + nestedWorkflowContexts);
        if (nestedWorkflowContexts.isEmpty()) {
            return reducingV != null ? reducingV : MutableList.of();
        }
        long ci = 1L;
        Object c = this.concurrency;
        if (c != null && wasList) {
            if (reducingV != null) {
                Maybe<Integer> cm = TypeCoercions.tryCoerce(c, Integer.class);
                if (cm.isAbsent() || (Integer)cm.get() != 1) {
                    throw new IllegalArgumentException("Concurrency cannot be used unless static value 1 when reducing");
                }
                ci = 1L;
            } else {
                if (!((c = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, c, Object.class)) instanceof Number)) {
                    if (c instanceof String) {
                        c = WorkflowConcurrencyParser.parse((String)c).apply(Double.valueOf(nestedWorkflowContexts.size()));
                    } else {
                        throw new IllegalArgumentException("Unsupported concurrency object: '" + c + "'");
                    }
                }
                if ((ci = (long)Math.floor(1.0E-6 + ((Number)c).doubleValue())) <= 0L) {
                    throw new IllegalArgumentException("Invalid concurrency value: " + ci + " (concurrency " + c + ", target size " + nestedWorkflowContexts.size() + ")");
                }
            }
        }
        AtomicInteger availableThreads = ci == 1L ? null : new AtomicInteger((int)ci);
        MutableList submitted = MutableList.of();
        MutableList delayedBecauseReducing = MutableList.of();
        WorkflowExecutionContext lastWorkflowRunBeforeReplay = null;
        MutableList errors = MutableList.of();
        for (int i = 0; i < nestedWorkflowContexts.size(); ++i) {
            Task task;
            if (availableThreads != null) {
                while (availableThreads.get() <= 0) {
                    try {
                        Tasks.withBlockingDetails("Waiting before running remaining " + (nestedWorkflowContexts.size() - i) + " instances because " + ci + " are currently running", () -> {
                            AtomicInteger atomicInteger = availableThreads;
                            synchronized (atomicInteger) {
                                availableThreads.wait(500L);
                            }
                            return null;
                        });
                    }
                    catch (Exception e2) {
                        throw Exceptions.propagate((Throwable)e2);
                    }
                }
            }
            if (!isReplaying) {
                task = (Task)nestedWorkflowContexts.get(i).getTask(false).get();
            } else {
                try {
                    Pair<Boolean, Object> check = WorkflowReplayUtils.checkReplayResumingInSubWorkflowAlsoReturningTaskOrResult("nested workflow " + (i + 1), context, nestedWorkflowContexts.get(i), instructionsIfReplaying, (w, e) -> {
                        throw new IllegalStateException("Sub workflow " + w + " is not replayable", (Throwable)e);
                    }, false);
                    if (((Boolean)check.getLeft()).booleanValue()) {
                        task = (Task)check.getRight();
                    } else {
                        task = null;
                        lastWorkflowRunBeforeReplay = nestedWorkflowContexts.get(i);
                    }
                }
                catch (Exception e3) {
                    errors.add(e3);
                    task = null;
                }
            }
            if (task == null) continue;
            if (Entities.isUnmanagingOrNoLongerManaged(context.getEntity())) {
                task.cancel(false);
                continue;
            }
            if (reducingV != null) {
                delayedBecauseReducing.add(Pair.of((Object)nestedWorkflowContexts.get(i), (Object)task));
                continue;
            }
            if (availableThreads != null) {
                availableThreads.decrementAndGet();
                ((EntityInternal)context.getEntity()).getExecutionContext().submit((Map)MutableMap.of((Object)"newTaskEndCallback", () -> {
                    availableThreads.incrementAndGet();
                    AtomicInteger atomicInteger = availableThreads;
                    synchronized (atomicInteger) {
                        availableThreads.notifyAll();
                    }
                }), (TaskAdaptable)task);
            }
            DynamicTasks.queue(task);
            submitted.add(task);
        }
        if (reducingV == null) {
            assert (delayedBecauseReducing.isEmpty());
            submitted.forEach(arg_0 -> CustomWorkflowStep.lambda$runSubworkflowsWithConcurrency$6((List)errors, arg_0));
            if (!errors.isEmpty()) {
                throw Exceptions.propagate((String)("Error" + (errors.size() > 1 ? "s" : "") + " running sub-workflow" + (nestedWorkflowContexts.size() > 1 ? "s" : "") + " in " + context.getWorkflowStepReference()), (Iterable)errors);
            }
        } else {
            assert (submitted.isEmpty());
            if (lastWorkflowRunBeforeReplay != null) {
                reducingV = CustomWorkflowStep.updateReducingWorkflowVarsFromLastStep(lastWorkflowRunBeforeReplay, (Map<String, Object>)reducingV);
            }
            for (Pair p : delayedBecauseReducing) {
                WorkflowExecutionContext wc = (WorkflowExecutionContext)p.getLeft();
                if (wc.getCurrentStepIndex() == null || wc.getCurrentStepIndex() == -1) {
                    wc.updateWorkflowScratchVariables((Map<String, Object>)reducingV);
                }
                ((Task)DynamicTasks.queue((TaskAdaptable)p.getRight())).getUnchecked();
                reducingV = CustomWorkflowStep.updateReducingWorkflowVarsFromLastStep(wc, (Map<String, Object>)reducingV);
            }
        }
        if (reducingV == null) {
            MutableList result = MutableList.of();
            nestedWorkflowContexts.forEach(arg_0 -> CustomWorkflowStep.lambda$runSubworkflowsWithConcurrency$7((List)result, arg_0));
            if (!wasList && result.size() != 1) {
                throw new IllegalStateException("Result mismatch, non-list target " + this.target + " yielded output " + result);
            }
            context.setOutput(result);
            returnValue = !wasList ? Iterables.getOnlyElement((Iterable)result) : result;
        } else {
            context.setOutput(reducingV);
            context.getWorkflowExectionContext().updateWorkflowScratchVariables((Map<String, Object>)reducingV);
            returnValue = reducingV;
        }
        return returnValue;
    }

    private static MutableMap<String, Object> updateReducingWorkflowVarsFromLastStep(WorkflowExecutionContext lastStep, Map<String, Object> prevWorkflowVars) {
        Map<String, Object> lastStepReducingWorkflowVars = lastStep.getWorkflowScratchVariables();
        Object lastStepOutput = lastStep.getOutput();
        MutableMap result = MutableMap.copyOf(prevWorkflowVars);
        prevWorkflowVars.keySet().forEach(k -> {
            result.put(k, lastStepReducingWorkflowVars.get(k));
            if (lastStepOutput instanceof Map && ((Map)lastStepOutput).containsKey(k)) {
                result.put(k, ((Map)lastStepOutput).get(k));
            }
        });
        return result;
    }

    protected Object getTargetFromString(WorkflowStepInstanceExecutionContext context, String target) {
        String[] numbers;
        if ("children".equals(target)) {
            return context.getEntity().getChildren();
        }
        if ("members".equals(target)) {
            if (!(context.getEntity() instanceof Group)) {
                throw new IllegalArgumentException("Cannot specify target 'members' when not on a group");
            }
            return ((Group)context.getEntity()).getMembers();
        }
        if (target.matches("-?[0-9]+\\.\\.-?[0-9]+") && (numbers = target.split("\\.\\.")).length == 2) {
            int max;
            int min = Integer.parseInt(numbers[0]);
            if (min > (max = Integer.parseInt(numbers[1]))) {
                throw new IllegalArgumentException("Invalid target range " + min + ".." + max);
            }
            MutableList result = MutableList.of();
            while (min <= max) {
                result.add(min++);
            }
            return result;
        }
        throw new IllegalArgumentException("Invalid target '" + target + "'; if a string, it must match a known keyword ('children' or 'members') or pattern (a range, '1..10')");
    }

    public String getNameOrDefault() {
        return this.getNameOrDefault(() -> Strings.isNonBlank((CharSequence)this.shorthandTypeName) ? this.shorthandTypeName : "custom step");
    }

    public String getNameOrDefault(Supplier<String> defaultSupplier) {
        return Strings.isNonBlank((CharSequence)this.getName()) ? this.getName() : (defaultSupplier == null ? null : defaultSupplier.get());
    }

    @Override
    public WorkflowStepDefinition applySpecialDefinition(ManagementContext mgmt, Object definition, String typeBestGuess, WorkflowStepDefinition.WorkflowStepDefinitionWithSpecialDeserialization firstParse) {
        BrooklynClassLoadingContext loader = RegisteredTypes.getCurrentClassLoadingContextOrManagement(mgmt);
        if (typeBestGuess == null || !(definition instanceof Map)) {
            throw new IllegalStateException("Should not be able to create a custom workflow definition from anything other than a map with a type");
        }
        CustomWorkflowStep result = (CustomWorkflowStep)firstParse;
        Map m = (Map)definition;
        for (String forbiddenKey : new String[]{"parameters"}) {
            if (!m.containsKey(forbiddenKey)) continue;
            throw new IllegalArgumentException("Not permitted to override '" + forbiddenKey + "' when using a workflow step");
        }
        if (!this.isPermittedToSetSteps(typeBestGuess)) {
            for (String forbiddenKey : new String[]{"steps"}) {
                if (!m.containsKey(forbiddenKey)) continue;
                throw new IllegalArgumentException("Not permitted to override '" + forbiddenKey + "' when using a custom workflow step");
            }
        }
        if (m.containsKey("output")) {
            try {
                CustomWorkflowStep base = (CustomWorkflowStep)BeanWithTypeUtils.convert(mgmt, MutableMap.of((Object)"type", (Object)typeBestGuess), TypeToken.of(CustomWorkflowStep.class), true, loader, false);
                result.workflowOutput = base.output;
            }
            catch (JsonProcessingException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        } else {
            result.workflowOutput = result.output;
            result.output = null;
        }
        return result;
    }

    protected boolean isPermittedToSetSteps(String typeBestGuess) {
        return typeBestGuess == null || SHORTHAND_TYPE_NAME_DEFAULT.equals(typeBestGuess) || CustomWorkflowStep.class.getName().equals(typeBestGuess);
    }

    protected WorkflowExecutionContext newWorkflow(WorkflowStepInstanceExecutionContext context, Object target, Integer targetIndexOrNull) {
        String targetString;
        if (this.steps == null) {
            throw new IllegalArgumentException("Cannot make new workflow with no steps");
        }
        String indexName = targetIndexOrNull == null ? "" : " " + (targetIndexOrNull + 1);
        String name = this.getNameOrDefault(null);
        name = name == null ? "Sub-workflow" + indexName : "Sub-workflow" + indexName + " for " + name;
        String string = targetString = target == null ? null : target.toString();
        if (targetString != null && targetString.length() < 60 && !Strings.isMultiLine((String)targetString)) {
            name = name + " (" + targetString + ")";
        }
        WorkflowExecutionContext nestedWorkflowContext = WorkflowExecutionContext.newInstanceUnpersistedWithParent((BrooklynObject)(target instanceof BrooklynObject ? (BrooklynObject)target : context.getEntity()), context.getWorkflowExectionContext(), WorkflowExecutionContext.WorkflowContextType.NESTED_WORKFLOW, name, this.getConfigForSubWorkflow(false), null, ConfigBag.newInstance(this.getInput()), null);
        String tivn = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_INPUT, this.target_index_var_name, String.class);
        if (targetIndexOrNull != null) {
            nestedWorkflowContext.updateWorkflowScratchVariable(tivn == null ? TARGET_INDEX_VAR_NAME_DEFAULT : tivn, targetIndexOrNull);
        }
        this.initializeSubWorkflowForTarget(context, target, nestedWorkflowContext);
        return nestedWorkflowContext;
    }

    protected void initializeSubWorkflowForTarget(WorkflowStepInstanceExecutionContext context, Object target, WorkflowExecutionContext nestedWorkflowContext) {
        String tvn = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_INPUT, this.target_var_name, String.class);
        nestedWorkflowContext.updateWorkflowScratchVariable(tvn == null ? TARGET_VAR_NAME_DEFAULT : tvn, target);
    }

    public WorkflowExecutionContext newWorkflowExecution(Entity entity, String name, ConfigBag extraConfig) {
        return this.newWorkflowExecution(entity, name, extraConfig, null);
    }

    public WorkflowExecutionContext newWorkflowExecution(Entity entity, String name, ConfigBag extraConfig, Map extraTaskFlags) {
        if (this.steps == null) {
            if (this.target != null) {
                throw new IllegalArgumentException("Steps are required for a workflow with a target");
            }
            this.steps = MutableList.of();
        }
        if (this.target == null) {
            return WorkflowExecutionContext.newInstancePersisted((BrooklynObject)entity, WorkflowExecutionContext.WorkflowContextType.NESTED_WORKFLOW, name, this.getConfigForSubWorkflow(true), null, ConfigBag.newInstance(this.getInput()).putAll(extraConfig), extraTaskFlags);
        }
        return WorkflowExecutionContext.newInstancePersisted((BrooklynObject)entity, WorkflowExecutionContext.WorkflowContextType.NESTED_WORKFLOW, name, ConfigBag.newInstance().configure(WorkflowCommonConfig.PARAMETER_DEFS, this.parameters).configure(WorkflowCommonConfig.STEPS, MutableList.of((Object)this)), null, ConfigBag.newInstance(this.getInput()).putAll(extraConfig), extraTaskFlags);
    }

    private ConfigBag getConfigForSubWorkflow(boolean isFlattened) {
        if (isFlattened && this.output != null && this.workflowOutput != null && !Objects.equals(this.output, this.workflowOutput)) {
            throw new IllegalArgumentException("Setting both 'output' and 'workflowOutput' is not supported for custom steps without target");
        }
        ConfigBag result = ConfigBag.newInstance().configure(WorkflowCommonConfig.PARAMETER_DEFS, this.parameters).configure(WorkflowCommonConfig.STEPS, this.steps).configure(WorkflowCommonConfig.INPUT, isFlattened ? this.input : null).configure(WorkflowCommonConfig.OUTPUT, isFlattened && this.workflowOutput == null ? this.output : this.workflowOutput).configure(WorkflowCommonConfig.RETENTION, this.retention).configure(WorkflowCommonConfig.REPLAYABLE, this.replayable).configure(WorkflowCommonConfig.IDEMPOTENT, this.idempotent).configure(WorkflowCommonConfig.ON_ERROR, this.onError).configure(WorkflowCommonConfig.TIMEOUT, this.timeout).configure(WorkflowCommonConfig.LOCK, this.lock).configure(WorkflowCommonConfig.CONDITION, this.target != null ? this.condition : null);
        MutableMap.copyOf(result.getAllConfigRaw()).forEach((k, v) -> {
            if (v == null) {
                result.remove((String)k);
            }
        });
        return result;
    }

    @VisibleForTesting
    public List<Object> peekSteps() {
        return this.steps;
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return null;
    }

    private static /* synthetic */ void lambda$runSubworkflowsWithConcurrency$7(List result, WorkflowExecutionContext nw) {
        result.add(nw.getOutput());
    }

    private static /* synthetic */ void lambda$runSubworkflowsWithConcurrency$6(List errors, Task t) {
        try {
            if (!t.isSubmitted() && !errors.isEmpty()) {
                return;
            }
            t.get();
        }
        catch (Throwable tt) {
            errors.add(tt);
        }
    }

    private /* synthetic */ void lambda$doTaskBody$1(WorkflowStepInstanceExecutionContext context, boolean wasList, AtomicInteger index, List nestedWorkflowContext, Object t) {
        String targetS;
        WorkflowExecutionContext nw = this.newWorkflow(context, t, wasList ? Integer.valueOf(index.getAndIncrement()) : null);
        Maybe<Task<Object>> mt = nw.getTaskCheckingConditionWithTarget(t);
        String string = targetS = wasList || t != null ? " for target '" + t + "'" : "";
        if (mt.isAbsent()) {
            LOG.debug("Step " + context.getWorkflowStepReference() + " skipping nested workflow " + nw.getWorkflowId() + targetS + "; condition not met");
        } else {
            LOG.debug("Step " + context.getWorkflowStepReference() + " launching nested workflow " + nw.getWorkflowId() + targetS + " in task " + nw.getTaskId());
            nestedWorkflowContext.add(nw);
        }
    }

    static class StepState {
        Boolean wasList;
        Map reducing;

        StepState() {
        }
    }
}

