/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.config.ConfigUtils;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.AbstractCatalogBundleResolver;
import org.apache.brooklyn.core.typereg.BasicManagedBundle;
import org.apache.brooklyn.core.typereg.BrooklynCatalogBundleResolver;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.osgi.BundleMaker;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.stream.InputStreamSource;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynBomYamlCatalogBundleResolver
extends AbstractCatalogBundleResolver {
    private static Logger LOG = LoggerFactory.getLogger(BrooklynBomYamlCatalogBundleResolver.class);
    public static final String FORMAT = "brooklyn-bom-yaml";

    public BrooklynBomYamlCatalogBundleResolver() {
        super(FORMAT, "Brooklyn catalog.bom YAML", "YAML map with a single brooklyn.catalog key");
    }

    @Override
    protected double scoreForNullFormat(Supplier<InputStream> f) {
        try (AbstractCatalogBundleResolver.FileTypeDetector detector = new AbstractCatalogBundleResolver.FileTypeDetector(f);){
            if (!detector.isPrintableText()) {
                double d = 0.001;
                return d;
            }
            if (!detector.isYaml()) {
                double d = 0.01;
                return d;
            }
            Object yaml = detector.getYaml().get();
            if (yaml instanceof Iterable) {
                Iterator yi = ((Iterable)yaml).iterator();
                if (!yi.hasNext()) {
                    double d = 0.0;
                    return d;
                }
                Object yo = yi.next();
                if (yi.hasNext()) {
                    double d = 0.01;
                    return d;
                }
                if (yo instanceof Map) {
                    if (((Map)yo).containsKey("brooklyn.catalog")) {
                        double d = 0.9;
                        return d;
                    }
                    double d = 0.1;
                    return d;
                }
                double d = 0.01;
                return d;
            }
            double d = 0.01;
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceWithError<OsgiBundleInstallationResult> install(Supplier<InputStream> input, BrooklynCatalogBundleResolver.BundleInstallationOptions options) {
        OsgiBundleInstallationResult result;
        String yaml;
        Map<?, ?> cm;
        try (AbstractCatalogBundleResolver.FileTypeDetector detector = new AbstractCatalogBundleResolver.FileTypeDetector(input);){
            detector.getYaml().get();
        }
        if (options == null) {
            options = new BrooklynCatalogBundleResolver.BundleInstallationOptions();
        }
        if ((cm = BasicBrooklynCatalog.getCatalogMetadata(yaml = Streams.readFullyString((InputStream)input.get()))) == null) {
            throw new IllegalStateException("No catalog meta data supplied. brooklyn.catalog must be specified");
        }
        VersionedName vn = BasicBrooklynCatalog.getVersionedName(cm, false);
        if (vn == null) {
            vn = new VersionedName("brooklyn-catalog-bom-" + Identifiers.makeRandomId((int)8), (String)null);
        }
        if (Strings.isBlank((CharSequence)vn.getVersionString())) {
            vn = new VersionedName(vn.getSymbolicName(), (String)ConfigUtils.getFirstAs(cm, String.class, "version", new String[0]).or((Object)"0.0.0-SNAPSHOT"));
        }
        LOG.debug("Wrapping supplied BOM as " + vn);
        Manifest mf = new Manifest();
        mf.getMainAttributes().putValue("Bundle-SymbolicName", vn.getSymbolicName());
        mf.getMainAttributes().putValue("Bundle-Version", vn.getOsgiVersionString());
        mf.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
        mf.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        mf.getMainAttributes().putValue("Brooklyn-Wrapped-BOM", Boolean.TRUE.toString());
        Object impliedHeaders = cm.get("catalog.osgi.wrap.headers");
        if (impliedHeaders instanceof Map) {
            ((Map)impliedHeaders).forEach((k, v) -> mf.getMainAttributes().putValue(Strings.toString((Object)k), Strings.toString((Object)v)));
        } else if (impliedHeaders != null) {
            throw new IllegalStateException("Must contain map of OSGi headers to insert in catalog.osgi.wrap.headers");
        }
        BundleMaker bm = new BundleMaker(this.mgmt);
        File bf = bm.createTempBundle(vn.getSymbolicName(), mf, (Map<ZipEntry, InputStream>)MutableMap.of((Object)new ZipEntry("catalog.bom"), (Object)new ByteArrayInputStream(yaml.getBytes())));
        try {
            Maybe<String> bundleIconUrl;
            BasicManagedBundle basicManagedBundle = new BasicManagedBundle(vn.getSymbolicName(), vn.getVersionString(), null, "brooklyn-bom-bundle", null, null, options.getDeleteable());
            if (cm.containsKey("tags") && cm.get("tags") instanceof Iterable) {
                basicManagedBundle.tags().addTags((Iterable)cm.get("tags"));
            }
            if ((bundleIconUrl = ConfigUtils.getFirstAs(cm, String.class, "bundleIconUrl", new String[0])).isPresentAndNonNull()) {
                basicManagedBundle.tags().addTag((Object)BrooklynTags.newIconUrlTag((String)bundleIconUrl.get()));
            }
            result = (OsgiBundleInstallationResult)((OsgiManager)((ManagementContextInternal)this.mgmt).getOsgiManager().get()).installBrooklynBomBundle(basicManagedBundle, (Supplier<InputStream>)InputStreamSource.of((String)("ZIP generated for " + vn + ": " + bf), (File)bf), options.isStart(), options.isLoadCatalogBom(), options.isForceUpdateOfNonSnapshots(), options.isValidateTypes(), options.isDeferredStart()).get();
        }
        finally {
            bf.delete();
        }
        if (result.getCode().isError()) {
            throw new IllegalStateException(result.getMessage());
        }
        ((BasicBrooklynCatalog)this.mgmt.getCatalog()).uninstallEmptyWrapperBundles();
        return ReferenceWithError.newInstanceWithoutError((Object)result);
    }
}

