/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import java.io.IOException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JacksonBetterDelegatingDeserializer
extends DelegatingDeserializer {
    private static final Logger log = LoggerFactory.getLogger(JacksonBetterDelegatingDeserializer.class);
    protected final Function<JsonDeserializer<?>, JacksonBetterDelegatingDeserializer> constructor;

    public JacksonBetterDelegatingDeserializer(JsonDeserializer<?> delagatee, Function<JsonDeserializer<?>, JacksonBetterDelegatingDeserializer> constructor) {
        super(JacksonBetterDelegatingDeserializer.newDelagatee(delagatee));
        this.constructor = constructor;
        if (this._delegatee instanceof CollectionDelegatingUntypedObjectDeserializer) {
            ((CollectionDelegatingUntypedObjectDeserializer)this._delegatee).init(this);
        }
    }

    protected static JsonDeserializer<?> newDelagatee(JsonDeserializer<?> delegatee) {
        if (delegatee instanceof UntypedObjectDeserializer) {
            return new CollectionDelegatingUntypedObjectDeserializer((UntypedObjectDeserializer)delegatee);
        }
        return delegatee;
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return (JsonDeserializer)this.constructor.apply(newDelegatee);
    }

    public Object deserialize(JsonParser jp1, DeserializationContext ctxt1) throws IOException {
        return this.deserializeWrapper(jp1, ctxt1, (jp2, ctxt2) -> {
            if (this._delegatee instanceof CollectionDelegatingUntypedObjectDeserializer) {
                return ((CollectionDelegatingUntypedObjectDeserializer)this._delegatee).deserializeReal((JsonParser)jp2, (DeserializationContext)ctxt2);
            }
            return this._delegatee.deserialize(jp2, ctxt2);
        });
    }

    public Object deserialize(JsonParser jp1, DeserializationContext ctxt1, Object intoValue) throws IOException {
        return this.deserializeWrapper(jp1, ctxt1, (jp2, ctxt2) -> {
            if (this._delegatee instanceof CollectionDelegatingUntypedObjectDeserializer) {
                return ((CollectionDelegatingUntypedObjectDeserializer)this._delegatee).deserializeReal((JsonParser)jp2, (DeserializationContext)ctxt2, intoValue);
            }
            if (jp2.currentToken() == JsonToken.VALUE_STRING && this._delegatee instanceof BeanDeserializer) {
                throw new IllegalStateException("String deserialization using BeanDeserializer is not supported for '" + intoValue + "'; coercion may fix, otherwise this will propagate and input cannot handle strings for " + this.getValueType());
            }
            return this._delegatee.deserialize(jp2, ctxt2, intoValue);
        });
    }

    protected abstract Object deserializeWrapper(JsonParser var1, DeserializationContext var2, BiFunctionThrowsIoException<JsonParser, DeserializationContext, Object> var3) throws IOException;

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer del;
        JavaType vt = ctxt.constructType(this._delegatee.handledType());
        if (vt == null) {
            vt = ctxt.getContextualType();
        }
        if ((del = ctxt.handleSecondaryContextualization(this._delegatee, property, vt)) == this._delegatee) {
            return this;
        }
        return this.newDelegatingInstance(del);
    }

    static interface BiFunctionThrowsIoException<I1, I2, O> {
        public O apply(I1 var1, I2 var2) throws IOException;
    }

    public static class CollectionDelegatingUntypedObjectDeserializer
    extends UntypedObjectDeserializer {
        DelegatingDeserializer outer;

        public CollectionDelegatingUntypedObjectDeserializer(UntypedObjectDeserializer base) {
            super(base, new UntypedObjectDeserializerInfoAccess(base).isNonMerging());
            if (this._mapDeserializer == null) {
                this._mapDeserializer = this;
            }
            if (this._listDeserializer == null) {
                this._listDeserializer = this;
            }
        }

        public void init(DelegatingDeserializer delegator) {
            this.outer = delegator;
        }

        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return this.outer.deserialize(p, ctxt);
        }

        public Object deserialize(JsonParser p, DeserializationContext ctxt, Object intoValue) throws IOException {
            return this.outer.deserialize(p, ctxt, intoValue);
        }

        public Object deserializeReal(JsonParser p, DeserializationContext ctxt) throws IOException {
            return super.deserialize(p, ctxt);
        }

        public Object deserializeReal(JsonParser p, DeserializationContext ctxt, Object intoValue) throws IOException {
            return super.deserialize(p, ctxt, intoValue);
        }
    }

    public static class UntypedObjectDeserializerInfoAccess
    extends UntypedObjectDeserializer {
        public UntypedObjectDeserializerInfoAccess(UntypedObjectDeserializer base) {
            super(base, null, null, null, null);
        }

        public boolean isNonMerging() {
            return this._nonMerging;
        }
    }
}

