/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs.proxy;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.brooklyn.util.javalang.AggregateClassLoader;

class ClassLoaderCache {
    private final ConcurrentMap<TypesKey, AggregateClassLoader> cache = Maps.newConcurrentMap();

    ClassLoaderCache() {
    }

    public AggregateClassLoader getClassLoaderForProxy(Class<?> clazz, Set<Class<?>> interfaces) {
        AggregateClassLoader oldVal;
        TypesKey typesKey = new TypesKey(clazz, interfaces);
        AggregateClassLoader result = (AggregateClassLoader)this.cache.get(typesKey);
        if (result == null && (oldVal = this.cache.putIfAbsent(typesKey, result = this.newClassLoader(clazz, interfaces))) != null) {
            result = oldVal;
        }
        return result;
    }

    private AggregateClassLoader newClassLoader(Class<?> clazz, Set<Class<?>> interfaces) {
        LinkedHashSet loaders = Sets.newLinkedHashSet();
        this.addClassLoaders(clazz, loaders);
        for (Class<?> iface : interfaces) {
            loaders.add(iface.getClassLoader());
        }
        AggregateClassLoader aggregateClassLoader = AggregateClassLoader.newInstanceWithNoLoaders();
        for (ClassLoader cl : loaders) {
            aggregateClassLoader.addLast(cl);
        }
        return aggregateClassLoader;
    }

    private void addClassLoaders(Class<?> type, Set<ClassLoader> loaders) {
        Class<?> superType;
        ClassLoader cl = type.getClassLoader();
        if (cl != null) {
            loaders.add(cl);
        }
        if ((superType = type.getSuperclass()) != null) {
            this.addClassLoaders(superType, loaders);
        }
        for (Class<?> iface : type.getInterfaces()) {
            this.addClassLoaders(iface, loaders);
        }
    }

    private static class TypesKey {
        final Class<?> type;
        final Set<Class<?>> interfaces;

        public TypesKey(Class<?> type, Set<Class<?>> interfaces) {
            this.type = (Class)Preconditions.checkNotNull(type, (Object)"type");
            this.interfaces = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(interfaces, (Object)"interfaces")));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.interfaces});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypesKey)) {
                return false;
            }
            TypesKey o = (TypesKey)obj;
            return Objects.equal(this.type, o.type) && Objects.equal(this.interfaces, o.interfaces);
        }
    }
}

