/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.location.BasicLocationRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinedLocationByIdResolver
implements LocationResolver {
    public static final Logger log = LoggerFactory.getLogger(DefinedLocationByIdResolver.class);
    public static final String ID = "id";
    private volatile ManagementContext managementContext;

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public boolean isEnabled() {
        return true;
    }

    public LocationSpec<? extends Location> newLocationSpecFromString(String spec, Map<?, ?> locationFlags, LocationRegistry registry) {
        String id = spec;
        if (spec.toLowerCase().startsWith("id:")) {
            id = spec.substring("id:".length());
        }
        LocationDefinition ld = registry.getDefinedLocationById(id);
        ld.getSpec();
        return (LocationSpec)((BasicLocationRegistry)registry).getLocationSpec(ld, locationFlags).get();
    }

    public String getPrefix() {
        return ID;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        if (BasicLocationRegistry.isResolverPrefixForSpec(this, spec, false)) {
            return true;
        }
        return registry.getDefinedLocationById(spec) != null;
    }
}

