/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;

@Immutable
public class WriteConcern
implements Serializable {
    private static final long serialVersionUID = 1884671104750417011L;
    private static final Map<String, WriteConcern> NAMED_CONCERNS;
    private final Object w;
    private final int wtimeout;
    private final boolean fsync;
    private final boolean j;
    public static final WriteConcern ACKNOWLEDGED;
    public static final WriteConcern UNACKNOWLEDGED;
    public static final WriteConcern FSYNCED;
    public static final WriteConcern JOURNALED;
    public static final WriteConcern REPLICA_ACKNOWLEDGED;
    public static final WriteConcern NORMAL;
    public static final WriteConcern SAFE;
    public static final WriteConcern MAJORITY;
    public static final WriteConcern FSYNC_SAFE;
    public static final WriteConcern JOURNAL_SAFE;
    public static final WriteConcern REPLICAS_SAFE;

    public WriteConcern() {
        this(0);
    }

    public WriteConcern(int w) {
        this(w, 0, false);
    }

    public WriteConcern(String w) {
        this(w, 0, false, false);
    }

    public WriteConcern(int w, int wtimeout) {
        this(w, wtimeout, false);
    }

    public WriteConcern(boolean fsync) {
        this(1, 0, fsync);
    }

    public WriteConcern(int w, int wtimeout, boolean fsync) {
        this(w, wtimeout, fsync, false);
    }

    public WriteConcern(int w, int wtimeout, boolean fsync, boolean j) {
        Assertions.isTrueArgument("w >= 0", w >= 0);
        this.w = w;
        this.wtimeout = wtimeout;
        this.fsync = fsync;
        this.j = j;
    }

    public WriteConcern(String w, int wtimeout, boolean fsync, boolean j) {
        this.w = Assertions.notNull("w", w);
        this.wtimeout = wtimeout;
        this.fsync = fsync;
        this.j = j;
    }

    public Object getWObject() {
        return this.w;
    }

    public int getW() {
        return (Integer)this.w;
    }

    public String getWString() {
        return (String)this.w;
    }

    public int getWtimeout() {
        return this.wtimeout;
    }

    public boolean getFsync() {
        return this.fsync();
    }

    public boolean fsync() {
        return this.fsync;
    }

    public boolean callGetLastError() {
        return this.isAcknowledged();
    }

    public boolean isServerDefault() {
        return this.w.equals(1) && this.wtimeout == 0 && !this.fsync && !this.j;
    }

    public BsonDocument asDocument() {
        if (!this.isAcknowledged()) {
            throw new IllegalStateException("The write is unacknowledged, so no document can be created");
        }
        BsonDocument document = new BsonDocument();
        this.addW(document);
        this.addWTimeout(document);
        this.addFSync(document);
        this.addJ(document);
        return document;
    }

    public boolean isAcknowledged() {
        if (this.w instanceof Integer) {
            return (Integer)this.w > 0;
        }
        return this.w != null;
    }

    public static WriteConcern valueOf(String name) {
        return NAMED_CONCERNS.get(name.toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteConcern that = (WriteConcern)o;
        if (this.fsync != that.fsync) {
            return false;
        }
        if (this.j != that.j) {
            return false;
        }
        if (this.wtimeout != that.wtimeout) {
            return false;
        }
        return this.w.equals(that.w);
    }

    public int hashCode() {
        int result = this.w.hashCode();
        result = 31 * result + this.wtimeout;
        result = 31 * result + (this.fsync ? 1 : 0);
        result = 31 * result + (this.j ? 1 : 0);
        return result;
    }

    public String toString() {
        return "WriteConcern{w=" + this.w + ", wtimeout=" + this.wtimeout + ", fsync=" + this.fsync + ", j=" + this.j;
    }

    public boolean getJ() {
        return this.j;
    }

    public WriteConcern withW(int w) {
        return new WriteConcern(w, this.getWtimeout(), this.getFsync(), this.getJ());
    }

    public WriteConcern withW(String w) {
        return new WriteConcern(w, this.getWtimeout(), this.getFsync(), this.getJ());
    }

    public WriteConcern withFsync(boolean fsync) {
        if (this.getWObject() instanceof Integer) {
            return new WriteConcern(this.getW(), this.getWtimeout(), fsync, this.getJ());
        }
        return new WriteConcern(this.getWString(), this.getWtimeout(), fsync, this.getJ());
    }

    public WriteConcern withJ(boolean j) {
        if (this.getWObject() instanceof Integer) {
            return new WriteConcern(this.getW(), this.getWtimeout(), this.getFsync(), j);
        }
        return new WriteConcern(this.getWString(), this.getWtimeout(), this.getFsync(), j);
    }

    private void addW(BsonDocument document) {
        if (this.w instanceof String) {
            document.put("w", new BsonString((String)this.w));
        } else {
            document.put("w", new BsonInt32((Integer)this.w));
        }
    }

    private void addJ(BsonDocument document) {
        if (this.j) {
            document.put("j", BsonBoolean.TRUE);
        }
    }

    private void addFSync(BsonDocument document) {
        if (this.fsync) {
            document.put("fsync", BsonBoolean.TRUE);
        }
    }

    private void addWTimeout(BsonDocument document) {
        if (this.wtimeout > 0) {
            document.put("wtimeout", new BsonInt32(this.wtimeout));
        }
    }

    public static Majority majorityWriteConcern(int wtimeout, boolean fsync, boolean j) {
        return new Majority(wtimeout, fsync, j);
    }

    static {
        ACKNOWLEDGED = new WriteConcern(1);
        UNACKNOWLEDGED = new WriteConcern(0);
        FSYNCED = new WriteConcern(true);
        JOURNALED = new WriteConcern(1, 0, false, true);
        REPLICA_ACKNOWLEDGED = new WriteConcern(2);
        NORMAL = UNACKNOWLEDGED;
        SAFE = ACKNOWLEDGED;
        MAJORITY = new WriteConcern("majority");
        FSYNC_SAFE = FSYNCED;
        JOURNAL_SAFE = JOURNALED;
        REPLICAS_SAFE = REPLICA_ACKNOWLEDGED;
        NAMED_CONCERNS = new HashMap<String, WriteConcern>();
        for (Field f : WriteConcern.class.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !f.getType().equals(WriteConcern.class)) continue;
            String key = f.getName().toLowerCase();
            try {
                NAMED_CONCERNS.put(key, (WriteConcern)f.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Majority
    extends WriteConcern {
        private static final long serialVersionUID = -4128295115883875212L;

        public Majority() {
            this(0, false, false);
        }

        public Majority(int wtimeout, boolean fsync, boolean j) {
            super("majority", wtimeout, fsync, j);
        }
    }
}

