/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.config;

import com.google.common.base.Preconditions;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.service.streamset.IdentityStreamPartitionConverter;
import org.apache.distributedlog.service.streamset.StreamPartitionConverter;

public class ServerConfiguration
extends CompositeConfiguration {
    private static ClassLoader defaultLoader = Thread.currentThread().getContextClassLoader();
    protected static final String SERVER_DLSN_VERSION = "server_dlsn_version";
    protected static final byte SERVER_DLSN_VERSION_DEFAULT = 1;
    protected static final String SERVER_DURABLE_WRITE_ENABLED = "server_durable_write_enabled";
    protected static final boolean SERVER_DURABLE_WRITE_ENABLED_DEFAULT = true;
    protected static final String SERVER_REGION_ID = "server_region_id";
    protected static final int SERVER_REGION_ID_DEFAULT = 0;
    protected static final String SERVER_PORT = "server_port";
    protected static final int SERVER_PORT_DEFAULT = 0;
    protected static final String SERVER_SHARD_ID = "server_shard";
    protected static final int SERVER_SHARD_ID_DEFAULT = -1;
    protected static final String SERVER_NUM_THREADS = "server_threads";
    protected static final int SERVER_NUM_THREADS_DEFAULT;
    protected static final String SERVER_ENABLE_PERSTREAM_STAT = "server_enable_perstream_stat";
    protected static final boolean SERVER_ENABLE_PERSTREAM_STAT_DEFAULT = true;
    protected static final String SERVER_GRACEFUL_SHUTDOWN_PERIOD_MS = "server_graceful_shutdown_period_ms";
    protected static final long SERVER_GRACEFUL_SHUTDOWN_PERIOD_MS_DEFAULT = 0L;
    public static final String SERVER_SERVICE_TIMEOUT_MS = "server_service_timeout_ms";
    public static final String SERVER_SERVICE_TIMEOUT_MS_OLD = "serviceTimeoutMs";
    public static final long SERVER_SERVICE_TIMEOUT_MS_DEFAULT = 0L;
    public static final String SERVER_WRITER_CLOSE_TIMEOUT_MS = "server_writer_close_timeout_ms";
    public static final long SERVER_WRITER_CLOSE_TIMEOUT_MS_DEFAULT = 1000L;
    public static final String SERVER_STREAM_PROBATION_TIMEOUT_MS = "server_stream_probation_timeout_ms";
    public static final String SERVER_STREAM_PROBATION_TIMEOUT_MS_OLD = "streamProbationTimeoutMs";
    public static final long SERVER_STREAM_PROBATION_TIMEOUT_MS_DEFAULT = 300000L;
    protected static final String SERVER_STREAM_PARTITION_CONVERTER_CLASS = "stream_partition_converter_class";
    protected static final String SERVER_USE_HOSTNAME_AS_ALLOCATOR_POOL_NAME = "server_use_hostname_as_allocator_pool_name";
    protected static final boolean SERVER_USE_HOSTNAME_AS_ALLOCATOR_POOL_NAME_DEFAULT = false;
    public static final String SERVER_RESOURCE_PLACEMENT_REFRESH_INTERVAL_S = "server_resource_placement_refresh_interval_sec";
    public static final int SERVER_RESOURCE_PLACEMENT_REFRESH_INTERVAL_DEFAULT = 120;

    public ServerConfiguration() {
        this.addConfiguration((Configuration)new SystemConfiguration());
    }

    public void loadConf(DistributedLogConfiguration dlConf) {
        this.addConfiguration((Configuration)dlConf);
    }

    public ServerConfiguration setDlsnVersion(byte version) {
        this.setProperty(SERVER_DLSN_VERSION, version);
        return this;
    }

    public byte getDlsnVersion() {
        return this.getByte(SERVER_DLSN_VERSION, (byte)1);
    }

    public ServerConfiguration enableDurableWrite(boolean enabled) {
        this.setProperty(SERVER_DURABLE_WRITE_ENABLED, enabled);
        return this;
    }

    public boolean isDurableWriteEnabled() {
        return this.getBoolean(SERVER_DURABLE_WRITE_ENABLED, true);
    }

    public ServerConfiguration setRegionId(int regionId) {
        this.setProperty(SERVER_REGION_ID, regionId);
        return this;
    }

    public int getRegionId() {
        return this.getInt(SERVER_REGION_ID, 0);
    }

    public ServerConfiguration setServerPort(int port) {
        this.setProperty(SERVER_PORT, port);
        return this;
    }

    public int getServerPort() {
        return this.getInt(SERVER_PORT, 0);
    }

    public ServerConfiguration setServerShardId(int shardId) {
        this.setProperty(SERVER_SHARD_ID, shardId);
        return this;
    }

    public int getServerShardId() {
        return this.getInt(SERVER_SHARD_ID, -1);
    }

    public int getServerThreads() {
        return this.getInt(SERVER_NUM_THREADS, SERVER_NUM_THREADS_DEFAULT);
    }

    public ServerConfiguration setServerThreads(int numThreads) {
        this.setProperty(SERVER_NUM_THREADS, numThreads);
        return this;
    }

    public ServerConfiguration setPerStreamStatEnabled(boolean enabled) {
        this.setProperty(SERVER_ENABLE_PERSTREAM_STAT, enabled);
        return this;
    }

    public boolean isPerStreamStatEnabled() {
        return this.getBoolean(SERVER_ENABLE_PERSTREAM_STAT, true);
    }

    public ServerConfiguration setGracefulShutdownPeriodMs(long periodMs) {
        this.setProperty(SERVER_GRACEFUL_SHUTDOWN_PERIOD_MS, periodMs);
        return this;
    }

    public long getGracefulShutdownPeriodMs() {
        return this.getLong(SERVER_GRACEFUL_SHUTDOWN_PERIOD_MS, 0L);
    }

    public long getServiceTimeoutMs() {
        return this.getLong(SERVER_SERVICE_TIMEOUT_MS, this.getLong(SERVER_SERVICE_TIMEOUT_MS_OLD, 0L));
    }

    public ServerConfiguration setServiceTimeoutMs(long timeoutMs) {
        this.setProperty(SERVER_SERVICE_TIMEOUT_MS, timeoutMs);
        return this;
    }

    public long getWriterCloseTimeoutMs() {
        return this.getLong(SERVER_WRITER_CLOSE_TIMEOUT_MS, 1000L);
    }

    public ServerConfiguration setWriterCloseTimeoutMs(long timeoutMs) {
        this.setProperty(SERVER_WRITER_CLOSE_TIMEOUT_MS, timeoutMs);
        return this;
    }

    public long getStreamProbationTimeoutMs() {
        return this.getLong(SERVER_STREAM_PROBATION_TIMEOUT_MS, this.getLong(SERVER_STREAM_PROBATION_TIMEOUT_MS_OLD, 300000L));
    }

    public ServerConfiguration setStreamProbationTimeoutMs(long timeoutMs) {
        this.setProperty(SERVER_STREAM_PROBATION_TIMEOUT_MS, timeoutMs);
        return this;
    }

    public ServerConfiguration setStreamPartitionConverterClass(Class<? extends StreamPartitionConverter> converterClass) {
        this.setProperty(SERVER_STREAM_PARTITION_CONVERTER_CLASS, converterClass.getName());
        return this;
    }

    public Class<? extends StreamPartitionConverter> getStreamPartitionConverterClass() throws ConfigurationException {
        return ReflectionUtils.getClass((Configuration)this, (String)SERVER_STREAM_PARTITION_CONVERTER_CLASS, IdentityStreamPartitionConverter.class, StreamPartitionConverter.class, (ClassLoader)defaultLoader);
    }

    public ServerConfiguration setUseHostnameAsAllocatorPoolName(boolean useHostname) {
        this.setProperty(SERVER_USE_HOSTNAME_AS_ALLOCATOR_POOL_NAME, useHostname);
        return this;
    }

    public boolean isUseHostnameAsAllocatorPoolName() {
        return this.getBoolean(SERVER_USE_HOSTNAME_AS_ALLOCATOR_POOL_NAME, false);
    }

    public ServerConfiguration setResourcePlacementRefreshInterval(int refreshIntervalSecs) {
        this.setProperty(SERVER_RESOURCE_PLACEMENT_REFRESH_INTERVAL_S, refreshIntervalSecs);
        return this;
    }

    public int getResourcePlacementRefreshInterval() {
        return this.getInt(SERVER_RESOURCE_PLACEMENT_REFRESH_INTERVAL_S, 120);
    }

    public void validate() {
        byte dlsnVersion = this.getDlsnVersion();
        Preconditions.checkArgument((dlsnVersion >= 0 && dlsnVersion <= 1 ? 1 : 0) != 0, (Object)("Unknown dlsn version " + dlsnVersion));
        Preconditions.checkArgument((this.getServerThreads() > 0 ? 1 : 0) != 0, (Object)("Invalid number of server threads : " + this.getServerThreads()));
        Preconditions.checkArgument((this.getServerShardId() >= 0 ? 1 : 0) != 0, (Object)("Invalid server shard id : " + this.getServerShardId()));
    }

    static {
        if (null == defaultLoader) {
            defaultLoader = DistributedLogConfiguration.class.getClassLoader();
        }
        SERVER_NUM_THREADS_DEFAULT = Runtime.getRuntime().availableProcessors();
    }
}

