/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import bk-shade.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.versioning.Version;
import org.apache.zookeeper.AsyncCallback;

public class CleanupLedgerManager
implements LedgerManager {
    private final LedgerManager underlying;
    private final ConcurrentMap<BookkeeperInternalCallbacks.GenericCallback, BookkeeperInternalCallbacks.GenericCallback> callbacks = new ConcurrentHashMap<BookkeeperInternalCallbacks.GenericCallback, BookkeeperInternalCallbacks.GenericCallback>();
    private boolean closed = false;
    private final ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();

    public CleanupLedgerManager(LedgerManager lm) {
        this.underlying = lm;
    }

    @VisibleForTesting
    public LedgerManager getUnderlying() {
        return this.underlying;
    }

    private void addCallback(BookkeeperInternalCallbacks.GenericCallback callback) {
        this.callbacks.put(callback, callback);
    }

    @Override
    public void registerLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
        this.underlying.registerLedgerMetadataListener(ledgerId, listener);
    }

    @Override
    public void unregisterLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
        this.underlying.unregisterLedgerMetadataListener(ledgerId, listener);
    }

    private BookkeeperInternalCallbacks.GenericCallback removeCallback(BookkeeperInternalCallbacks.GenericCallback callback) {
        return (BookkeeperInternalCallbacks.GenericCallback)this.callbacks.remove(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createLedgerMetadata(long lid, LedgerMetadata metadata, BookkeeperInternalCallbacks.GenericCallback<Void> cb) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                cb.operationComplete(-19, null);
                return;
            }
            this.underlying.createLedgerMetadata(lid, metadata, new CleanupGenericCallback<Void>(cb));
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLedgerMetadata(long ledgerId, Version version, BookkeeperInternalCallbacks.GenericCallback<Void> vb) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                vb.operationComplete(-19, null);
                return;
            }
            this.underlying.removeLedgerMetadata(ledgerId, version, new CleanupGenericCallback<Void>(vb));
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readLedgerMetadata(long ledgerId, BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> readCb) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                readCb.operationComplete(-19, null);
                return;
            }
            this.underlying.readLedgerMetadata(ledgerId, new CleanupGenericCallback<LedgerMetadata>(readCb));
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLedgerMetadata(long ledgerId, LedgerMetadata metadata, BookkeeperInternalCallbacks.GenericCallback<Void> cb) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                cb.operationComplete(-19, null);
                return;
            }
            this.underlying.writeLedgerMetadata(ledgerId, metadata, new CleanupGenericCallback<Void>(cb));
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> processor, final AsyncCallback.VoidCallback finalCb, final Object context, int successRc, final int failureRc) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                finalCb.processResult(failureRc, null, context);
                return;
            }
            final BookkeeperInternalCallbacks.GenericCallback<Void> stub = new BookkeeperInternalCallbacks.GenericCallback<Void>(){

                @Override
                public void operationComplete(int rc, Void result) {
                    finalCb.processResult(failureRc, null, context);
                }
            };
            this.addCallback(stub);
            this.underlying.asyncProcessLedgers(processor, new AsyncCallback.VoidCallback(){

                public void processResult(int rc, String path, Object ctx) {
                    if (null != CleanupLedgerManager.this.removeCallback(stub)) {
                        finalCb.processResult(rc, path, ctx);
                    }
                }
            }, context, successRc, failureRc);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    @Override
    public LedgerManager.LedgerRangeIterator getLedgerRanges() {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                ClosedLedgerRangeIterator closedLedgerRangeIterator = new ClosedLedgerRangeIterator();
                return closedLedgerRangeIterator;
            }
            LedgerManager.LedgerRangeIterator ledgerRangeIterator = this.underlying.getLedgerRanges();
            return ledgerRangeIterator;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    @Override
    public void close() throws IOException {
        HashSet keys;
        this.closeLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            keys = new HashSet(this.callbacks.keySet());
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        for (BookkeeperInternalCallbacks.GenericCallback key : keys) {
            BookkeeperInternalCallbacks.GenericCallback callback = (BookkeeperInternalCallbacks.GenericCallback)this.callbacks.remove(key);
            if (null == callback) continue;
            callback.operationComplete(-19, null);
        }
        this.underlying.close();
    }

    private static class ClosedLedgerRangeIterator
    implements LedgerManager.LedgerRangeIterator {
        private ClosedLedgerRangeIterator() {
        }

        @Override
        public boolean hasNext() throws IOException {
            throw new IOException("Ledger manager is closed.");
        }

        @Override
        public LedgerManager.LedgerRange next() throws IOException {
            throw new IOException("Ledger manager is closed.");
        }
    }

    private class CleanupGenericCallback<T>
    implements BookkeeperInternalCallbacks.GenericCallback<T> {
        private final BookkeeperInternalCallbacks.GenericCallback<T> cb;

        CleanupGenericCallback(BookkeeperInternalCallbacks.GenericCallback<T> cb) {
            this.cb = cb;
            CleanupLedgerManager.this.addCallback(cb);
        }

        @Override
        public void operationComplete(int rc, T result) {
            CleanupLedgerManager.this.closeLock.readLock().lock();
            try {
                if (!CleanupLedgerManager.this.closed && null != CleanupLedgerManager.this.removeCallback(this.cb)) {
                    this.cb.operationComplete(rc, result);
                }
            }
            finally {
                CleanupLedgerManager.this.closeLock.readLock().unlock();
            }
        }
    }
}

