/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import bk-shade.com.google.common.collect.ImmutableSet;
import bk-shade.com.google.common.collect.Sets;
import io.netty.util.HashedWheelTimer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.TopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.WeightedRandomSelection;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.Configurable;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.net.NetUtils;
import org.apache.bookkeeper.net.NetworkTopology;
import org.apache.bookkeeper.net.NetworkTopologyImpl;
import org.apache.bookkeeper.net.Node;
import org.apache.bookkeeper.net.ScriptBasedMapping;
import org.apache.bookkeeper.net.StabilizeNetworkTopology;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RackawareEnsemblePlacementPolicyImpl
extends TopologyAwareEnsemblePlacementPolicy {
    static final Logger LOG = LoggerFactory.getLogger(RackawareEnsemblePlacementPolicyImpl.class);
    boolean isWeighted;
    int maxWeightMultiple;
    private Map<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject> bookieInfoMap = new HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject>();
    private WeightedRandomSelection<TopologyAwareEnsemblePlacementPolicy.BookieNode> weightedSelection;
    public static final String REPP_DNS_RESOLVER_CLASS = "reppDnsResolverClass";
    public static final String REPP_RANDOM_READ_REORDERING = "ensembleRandomReadReordering";
    static final int RACKNAME_DISTANCE_FROM_LEAVES = 1;
    protected NetworkTopology topology;
    protected DNSToSwitchMapping dnsResolver;
    protected HashedWheelTimer timer;
    protected final Map<BookieSocketAddress, TopologyAwareEnsemblePlacementPolicy.BookieNode> knownBookies;
    protected TopologyAwareEnsemblePlacementPolicy.BookieNode localNode;
    protected final ReentrantReadWriteLock rwLock;
    protected ImmutableSet<BookieSocketAddress> readOnlyBookies = null;
    protected boolean reorderReadsRandom = false;
    protected boolean enforceDurability = false;
    protected int stabilizePeriodSeconds = 0;
    protected StatsLogger statsLogger = null;

    RackawareEnsemblePlacementPolicyImpl() {
        this(false);
    }

    RackawareEnsemblePlacementPolicyImpl(boolean enforceDurability) {
        this.enforceDurability = enforceDurability;
        this.topology = new NetworkTopologyImpl();
        this.knownBookies = new HashMap<BookieSocketAddress, TopologyAwareEnsemblePlacementPolicy.BookieNode>();
        this.rwLock = new ReentrantReadWriteLock();
    }

    protected TopologyAwareEnsemblePlacementPolicy.BookieNode createBookieNode(BookieSocketAddress addr) {
        return new TopologyAwareEnsemblePlacementPolicy.BookieNode(addr, this.resolveNetworkLocation(addr));
    }

    protected RackawareEnsemblePlacementPolicyImpl initialize(DNSToSwitchMapping dnsResolver, HashedWheelTimer timer, boolean reorderReadsRandom, int stabilizePeriodSeconds, boolean isWeighted, int maxWeightMultiple, StatsLogger statsLogger) {
        TopologyAwareEnsemblePlacementPolicy.BookieNode bn;
        this.statsLogger = statsLogger;
        this.reorderReadsRandom = reorderReadsRandom;
        this.stabilizePeriodSeconds = stabilizePeriodSeconds;
        this.dnsResolver = dnsResolver;
        this.timer = timer;
        this.topology = stabilizePeriodSeconds > 0 ? new StabilizeNetworkTopology(timer, stabilizePeriodSeconds) : new NetworkTopologyImpl();
        try {
            bn = this.createBookieNode(new BookieSocketAddress(InetAddress.getLocalHost().getHostAddress(), 0));
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to get local host address : ", (Throwable)e);
            bn = null;
        }
        this.localNode = bn;
        LOG.info("Initialize rackaware ensemble placement policy @ {} @ {} : {}.", new Object[]{this.localNode, null == this.localNode ? "Unknown" : this.localNode.getNetworkLocation(), dnsResolver.getClass().getName()});
        this.isWeighted = isWeighted;
        if (this.isWeighted) {
            this.maxWeightMultiple = maxWeightMultiple;
            this.weightedSelection = new WeightedRandomSelection(this.maxWeightMultiple);
            LOG.info("Weight based placement with max multiple of " + this.maxWeightMultiple);
        } else {
            LOG.info("Not weighted");
        }
        return this;
    }

    @Override
    public RackawareEnsemblePlacementPolicyImpl initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger) {
        DNSToSwitchMapping dnsResolver;
        if (optionalDnsResolver.isPresent()) {
            dnsResolver = optionalDnsResolver.get();
        } else {
            String dnsResolverName = conf.getString(REPP_DNS_RESOLVER_CLASS, ScriptBasedMapping.class.getName());
            try {
                dnsResolver = ReflectionUtils.newInstance(dnsResolverName, DNSToSwitchMapping.class);
                if (dnsResolver instanceof Configurable) {
                    ((Configurable)((Object)dnsResolver)).setConf((Configuration)conf);
                }
            }
            catch (RuntimeException re) {
                LOG.info("Failed to initialize DNS Resolver {}, used default subnet resolver.", (Object)dnsResolverName, (Object)re);
                dnsResolver = new DefaultResolver();
            }
        }
        return this.initialize(dnsResolver, timer, conf.getBoolean(REPP_RANDOM_READ_REORDERING, false), conf.getNetworkTopologyStabilizePeriodSeconds(), conf.getDiskWeightBasedPlacementEnabled(), conf.getBookieMaxWeightMultipleForWeightBasedPlacement(), statsLogger);
    }

    @Override
    public void uninitalize() {
    }

    protected String resolveNetworkLocation(BookieSocketAddress addr) {
        return NetUtils.resolveNetworkLocation(this.dnsResolver, addr.getSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BookieSocketAddress> onClusterChanged(Set<BookieSocketAddress> writableBookies, Set<BookieSocketAddress> readOnlyBookies) {
        this.rwLock.writeLock().lock();
        try {
            Set<BookieSocketAddress> oldBookieSet = this.knownBookies.keySet();
            ImmutableSet<BookieSocketAddress> leftBookies = Sets.difference(oldBookieSet, writableBookies).immutableCopy();
            ImmutableSet<BookieSocketAddress> joinedBookies = Sets.difference(writableBookies, oldBookieSet).immutableCopy();
            ImmutableSet<BookieSocketAddress> deadBookies = Sets.difference(leftBookies, readOnlyBookies).immutableCopy();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cluster changed : left bookies are {}, joined bookies are {}, while dead bookies are {}.", new Object[]{leftBookies, joinedBookies, deadBookies});
            }
            this.handleBookiesThatLeft(leftBookies);
            this.handleBookiesThatJoined(joinedBookies);
            if (this.isWeighted && (leftBookies.size() > 0 || joinedBookies.size() > 0)) {
                this.weightedSelection.updateMap(this.bookieInfoMap);
            }
            if (!readOnlyBookies.isEmpty()) {
                this.readOnlyBookies = ImmutableSet.copyOf(readOnlyBookies);
            }
            ImmutableSet<BookieSocketAddress> immutableSet = deadBookies;
            return immutableSet;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void handleBookiesThatLeft(Set<BookieSocketAddress> leftBookies) {
        for (BookieSocketAddress addr : leftBookies) {
            TopologyAwareEnsemblePlacementPolicy.BookieNode node = this.knownBookies.remove(addr);
            if (null == node) continue;
            this.topology.remove(node);
            if (this.isWeighted) {
                this.bookieInfoMap.remove(node);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Cluster changed : bookie {} left from cluster.", (Object)addr);
        }
    }

    @Override
    public void handleBookiesThatJoined(Set<BookieSocketAddress> joinedBookies) {
        for (BookieSocketAddress addr : joinedBookies) {
            TopologyAwareEnsemblePlacementPolicy.BookieNode node = this.createBookieNode(addr);
            this.topology.add(node);
            this.knownBookies.put(addr, node);
            if (this.isWeighted) {
                this.bookieInfoMap.putIfAbsent(node, new BookieInfoReader.BookieInfo());
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Cluster changed : bookie {} joined the cluster.", (Object)addr);
        }
    }

    protected Set<Node> convertBookiesToNodes(Set<BookieSocketAddress> excludeBookies) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (BookieSocketAddress addr : excludeBookies) {
            TopologyAwareEnsemblePlacementPolicy.BookieNode bn = this.knownBookies.get(addr);
            if (null == bn) {
                bn = this.createBookieNode(addr);
            }
            nodes.add(bn);
        }
        return nodes;
    }

    @Override
    public ArrayList<BookieSocketAddress> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        return this.newEnsembleInternal(ensembleSize, writeQuorumSize, excludeBookies, null, null);
    }

    protected ArrayList<BookieSocketAddress> newEnsembleInternal(int ensembleSize, int writeQuorumSize, Set<BookieSocketAddress> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentPredicate) throws BKException.BKNotEnoughBookiesException {
        return this.newEnsembleInternal(ensembleSize, writeQuorumSize, writeQuorumSize, excludeBookies, parentEnsemble, parentPredicate);
    }

    @Override
    public ArrayList<BookieSocketAddress> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Set<BookieSocketAddress> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentPredicate) throws BKException.BKNotEnoughBookiesException {
        return this.newEnsembleInternal(ensembleSize, writeQuorumSize, ackQuorumSize, excludeBookies, parentEnsemble, parentPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<BookieSocketAddress> newEnsembleInternal(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Set<BookieSocketAddress> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentPredicate) throws BKException.BKNotEnoughBookiesException {
        this.rwLock.readLock().lock();
        try {
            Set<Node> excludeNodes = this.convertBookiesToNodes(excludeBookies);
            TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble ensemble = new TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, 1, parentEnsemble, parentPredicate);
            Node prevNode = null;
            int numRacks = this.topology.getNumOfRacks();
            if (numRacks < 2) {
                List<TopologyAwareEnsemblePlacementPolicy.BookieNode> bns = this.selectRandom(ensembleSize, excludeNodes, TopologyAwareEnsemblePlacementPolicy.TruePredicate.instance, ensemble);
                ArrayList<BookieSocketAddress> addrs = new ArrayList<BookieSocketAddress>(ensembleSize);
                for (TopologyAwareEnsemblePlacementPolicy.BookieNode bn : bns) {
                    addrs.add(bn.getAddr());
                }
                ArrayList<BookieSocketAddress> arrayList = addrs;
                return arrayList;
            }
            for (int i = 0; i < ensembleSize; ++i) {
                String curRack = null == prevNode ? (null == this.localNode || this.localNode.getNetworkLocation().equals("/default-region/default-rack") ? "" : this.localNode.getNetworkLocation()) : "~" + prevNode.getNetworkLocation();
                prevNode = this.selectFromNetworkLocation(curRack, (Set)excludeNodes, (ITopologyAwareEnsemblePlacementPolicy.Predicate)ensemble, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble);
            }
            ArrayList<BookieSocketAddress> bookieList = ensemble.toList();
            if (ensembleSize != bookieList.size()) {
                LOG.error("Not enough {} bookies are available to form an ensemble : {}.", (Object)ensembleSize, bookieList);
                throw new BKException.BKNotEnoughBookiesException();
            }
            ArrayList<BookieSocketAddress> arrayList = bookieList;
            return arrayList;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BookieSocketAddress replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Collection<BookieSocketAddress> currentEnsemble, BookieSocketAddress bookieToReplace, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        this.rwLock.readLock().lock();
        try {
            excludeBookies.addAll(currentEnsemble);
            TopologyAwareEnsemblePlacementPolicy.BookieNode bn = this.knownBookies.get(bookieToReplace);
            if (null == bn) {
                bn = this.createBookieNode(bookieToReplace);
            }
            Set<Node> excludeNodes = this.convertBookiesToNodes(excludeBookies);
            excludeNodes.add(bn);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try to choose a new bookie to replace {}, excluding {}.", (Object)bookieToReplace, excludeNodes);
            }
            Node candidate = this.selectFromNetworkLocation(bn.getNetworkLocation(), (Set)excludeNodes, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.instance, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.instance);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bookie {} is chosen to replace bookie {}.", (Object)candidate, (Object)bn);
            }
            BookieSocketAddress bookieSocketAddress = ((TopologyAwareEnsemblePlacementPolicy.BookieNode)candidate).getAddr();
            return bookieSocketAddress;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBookieInfo(Map<BookieSocketAddress, BookieInfoReader.BookieInfo> bookieInfoMap) {
        if (!this.isWeighted) {
            LOG.info("bookieFreeDiskInfo callback called even without weighted placement policy being used.");
            return;
        }
        ArrayList<TopologyAwareEnsemblePlacementPolicy.BookieNode> allBookies = new ArrayList<TopologyAwareEnsemblePlacementPolicy.BookieNode>(this.knownBookies.values());
        HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject> map = new HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject>();
        for (TopologyAwareEnsemblePlacementPolicy.BookieNode bookie : allBookies) {
            if (bookieInfoMap.containsKey(bookie.getAddr())) {
                map.put(bookie, bookieInfoMap.get(bookie.getAddr()));
                continue;
            }
            map.put(bookie, new BookieInfoReader.BookieInfo());
        }
        this.rwLock.writeLock().lock();
        try {
            this.bookieInfoMap = map;
            this.weightedSelection.updateMap(this.bookieInfoMap);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public TopologyAwareEnsemblePlacementPolicy.BookieNode selectFromNetworkLocation(String networkLoc, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        try {
            return this.selectRandomFromRack(networkLoc, excludeBookies, predicate, ensemble);
        }
        catch (BKException.BKNotEnoughBookiesException e) {
            LOG.warn("Failed to choose a bookie from {} : excluded {}, fallback to choose bookie randomly from the cluster.", (Object)networkLoc, excludeBookies);
            return this.selectRandom(1, excludeBookies, predicate, ensemble).get(0);
        }
    }

    protected String getRemoteRack(TopologyAwareEnsemblePlacementPolicy.BookieNode node) {
        return "~" + node.getNetworkLocation();
    }

    private WeightedRandomSelection<TopologyAwareEnsemblePlacementPolicy.BookieNode> prepareForWeightedSelection(List<Node> leaves) {
        HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject> rackMap = new HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject>();
        for (Node n : leaves) {
            if (!(n instanceof TopologyAwareEnsemblePlacementPolicy.BookieNode)) continue;
            TopologyAwareEnsemblePlacementPolicy.BookieNode bookie = (TopologyAwareEnsemblePlacementPolicy.BookieNode)n;
            if (this.bookieInfoMap.containsKey(bookie)) {
                rackMap.put(bookie, this.bookieInfoMap.get(bookie));
                continue;
            }
            rackMap.put(bookie, new BookieInfoReader.BookieInfo());
        }
        if (rackMap.size() == 0) {
            return null;
        }
        WeightedRandomSelection<TopologyAwareEnsemblePlacementPolicy.BookieNode> wRSelection = new WeightedRandomSelection<TopologyAwareEnsemblePlacementPolicy.BookieNode>(this.maxWeightMultiple);
        wRSelection.updateMap(rackMap);
        return wRSelection;
    }

    protected TopologyAwareEnsemblePlacementPolicy.BookieNode selectRandomFromRack(String netPath, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        block8: {
            Node n;
            WeightedRandomSelection<TopologyAwareEnsemblePlacementPolicy.BookieNode> wRSelection = null;
            ArrayList<Node> leaves = new ArrayList<Node>(this.topology.getLeaves(netPath));
            if (!this.isWeighted) {
                Collections.shuffle(leaves);
            } else {
                if (CollectionUtils.subtract(leaves, excludeBookies).size() < 1) {
                    throw new BKException.BKNotEnoughBookiesException();
                }
                wRSelection = this.prepareForWeightedSelection(leaves);
                if (wRSelection == null) {
                    throw new BKException.BKNotEnoughBookiesException();
                }
            }
            Iterator it = leaves.iterator();
            HashSet<Node> bookiesSeenSoFar = new HashSet<Node>();
            do {
                if (this.isWeighted) {
                    if (bookiesSeenSoFar.size() != leaves.size()) {
                        n = wRSelection.getNextRandom();
                        bookiesSeenSoFar.add(n);
                        continue;
                    }
                    break block8;
                }
                if (!it.hasNext()) break block8;
                n = (Node)it.next();
            } while (excludeBookies.contains(n) || !(n instanceof TopologyAwareEnsemblePlacementPolicy.BookieNode) || !predicate.apply((TopologyAwareEnsemblePlacementPolicy.BookieNode)n, ensemble));
            TopologyAwareEnsemblePlacementPolicy.BookieNode bn = (TopologyAwareEnsemblePlacementPolicy.BookieNode)n;
            if (ensemble.addNode(bn)) {
                excludeBookies.add(bn);
            }
            return bn;
        }
        throw new BKException.BKNotEnoughBookiesException();
    }

    protected List<TopologyAwareEnsemblePlacementPolicy.BookieNode> selectRandom(int numBookies, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        return this.selectRandomInternal(null, numBookies, excludeBookies, predicate, ensemble);
    }

    protected List<TopologyAwareEnsemblePlacementPolicy.BookieNode> selectRandomInternal(List<TopologyAwareEnsemblePlacementPolicy.BookieNode> bookiesToSelectFrom, int numBookies, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        WeightedRandomSelection<TopologyAwareEnsemblePlacementPolicy.BookieNode> wRSelection = null;
        if (bookiesToSelectFrom == null) {
            wRSelection = this.weightedSelection;
            bookiesToSelectFrom = new ArrayList<TopologyAwareEnsemblePlacementPolicy.BookieNode>(this.knownBookies.values());
        }
        if (this.isWeighted) {
            if (CollectionUtils.subtract(bookiesToSelectFrom, excludeBookies).size() < numBookies) {
                throw new BKException.BKNotEnoughBookiesException();
            }
            if (wRSelection == null) {
                HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject> rackMap = new HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject>();
                for (TopologyAwareEnsemblePlacementPolicy.BookieNode n : bookiesToSelectFrom) {
                    if (excludeBookies.contains(n)) continue;
                    if (this.bookieInfoMap.containsKey(n)) {
                        rackMap.put(n, this.bookieInfoMap.get(n));
                        continue;
                    }
                    rackMap.put(n, new BookieInfoReader.BookieInfo());
                }
                wRSelection = new WeightedRandomSelection(this.maxWeightMultiple);
                wRSelection.updateMap(rackMap);
            }
        } else {
            Collections.shuffle(bookiesToSelectFrom);
        }
        ArrayList<TopologyAwareEnsemblePlacementPolicy.BookieNode> newBookies = new ArrayList<TopologyAwareEnsemblePlacementPolicy.BookieNode>(numBookies);
        Iterator<TopologyAwareEnsemblePlacementPolicy.BookieNode> it = bookiesToSelectFrom.iterator();
        HashSet<TopologyAwareEnsemblePlacementPolicy.BookieNode> bookiesSeenSoFar = new HashSet<TopologyAwareEnsemblePlacementPolicy.BookieNode>();
        while (numBookies > 0) {
            TopologyAwareEnsemblePlacementPolicy.BookieNode bookie;
            if (this.isWeighted) {
                if (bookiesSeenSoFar.size() == bookiesToSelectFrom.size()) break;
                bookie = wRSelection.getNextRandom();
                bookiesSeenSoFar.add(bookie);
            } else {
                if (!it.hasNext()) break;
                bookie = it.next();
            }
            if (excludeBookies.contains(bookie) || this.enforceDurability && !predicate.apply(bookie, ensemble) || !ensemble.addNode(bookie)) continue;
            excludeBookies.add(bookie);
            newBookies.add(bookie);
            --numBookies;
        }
        if (numBookies == 0) {
            return newBookies;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failed to find {} bookies : excludeBookies {}, allBookies {}.", new Object[]{numBookies, excludeBookies, bookiesToSelectFrom});
        }
        throw new BKException.BKNotEnoughBookiesException();
    }

    @Override
    public List<Integer> reorderReadSequence(ArrayList<BookieSocketAddress> ensemble, List<Integer> writeSet, Map<BookieSocketAddress, Long> bookieFailureHistory) {
        int ensembleSize = ensemble.size();
        ArrayList<Integer> finalList = new ArrayList<Integer>(writeSet.size());
        ArrayList<Long> observedFailuresList = new ArrayList<Long>(writeSet.size());
        ArrayList<Integer> readOnlyList = new ArrayList<Integer>(writeSet.size());
        ArrayList<Integer> unAvailableList = new ArrayList<Integer>(writeSet.size());
        for (Integer idx : writeSet) {
            BookieSocketAddress address = ensemble.get(idx);
            Long lastFailedEntryOnBookie = bookieFailureHistory.get(address);
            if (null == this.knownBookies.get(address)) {
                if (null == this.readOnlyBookies || !this.readOnlyBookies.contains(address)) {
                    unAvailableList.add(idx);
                    continue;
                }
                readOnlyList.add(idx);
                continue;
            }
            if (lastFailedEntryOnBookie == null || lastFailedEntryOnBookie < 0L) {
                finalList.add(idx);
                continue;
            }
            observedFailuresList.add(lastFailedEntryOnBookie * (long)ensembleSize + (long)idx.intValue());
        }
        if (this.reorderReadsRandom) {
            Collections.shuffle(finalList);
            Collections.shuffle(readOnlyList);
            Collections.shuffle(unAvailableList);
        }
        Collections.sort(observedFailuresList);
        Iterator<Integer> iterator = observedFailuresList.iterator();
        while (iterator.hasNext()) {
            long value = (Long)((Object)iterator.next());
            finalList.add((int)(value % (long)ensembleSize));
        }
        finalList.addAll(readOnlyList);
        finalList.addAll(unAvailableList);
        return finalList;
    }

    static class DefaultResolver
    implements DNSToSwitchMapping {
        DefaultResolver() {
        }

        @Override
        public List<String> resolve(List<String> names) {
            ArrayList<String> rNames = new ArrayList<String>(names.size());
            for (String name : names) {
                rNames.add("/default-region/default-rack");
            }
            return rNames;
        }

        @Override
        public void reloadCachedMappings() {
        }
    }
}

