/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.io;

import com.google.common.base.Preconditions;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.twitter.common.io.Codec;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.BitSet;

public class JsonCodec<T>
implements Codec<T> {
    private static final String ENCODING = "utf-8";
    private final Class<T> clazz;
    private final Gson gson;

    public static <T> JsonCodec<T> create(Class<T> clazz) {
        return new JsonCodec<T>(clazz, DefaultGsonHolder.instance);
    }

    public static <T> JsonCodec<T> create(Class<T> clazz, Gson gson) {
        return new JsonCodec<T>(clazz, gson);
    }

    private JsonCodec(Class<T> clazz, Gson gson) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull((Object)gson);
        this.clazz = clazz;
        this.gson = gson;
    }

    public static ExclusionStrategy getThriftExclusionStrategy() {
        return ThriftExclusionStrategy.instance;
    }

    public T deserialize(InputStream source) throws IOException {
        return (T)this.gson.fromJson((Reader)new InputStreamReader(source, ENCODING), this.clazz);
    }

    public void serialize(T item, OutputStream sink) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new UnflushableOutputStream(sink), ENCODING);
        this.gson.toJson(item, this.clazz, (Appendable)w);
        ((Writer)w).flush();
    }

    private static class UnflushableOutputStream
    extends FilterOutputStream {
        UnflushableOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void flush() throws IOException {
        }
    }

    private static final class ThriftExclusionStrategy
    implements ExclusionStrategy {
        static final ExclusionStrategy instance = new ThriftExclusionStrategy();

        private ThriftExclusionStrategy() {
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getDeclaredClass() == BitSet.class && f.getName().equals("__isset_bit_vector");
        }
    }

    private static final class DefaultGsonHolder {
        static final Gson instance = new Gson();

        private DefaultGsonHolder() {
        }
    }
}

