/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream.limiter;

import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.OverCapacityException;
import org.apache.distributedlog.limiter.ChainedRequestLimiter;
import org.apache.distributedlog.limiter.ComposableRequestLimiter;
import org.apache.distributedlog.limiter.RequestLimiter;
import org.apache.distributedlog.service.stream.StreamOp;
import org.apache.distributedlog.service.stream.limiter.DynamicRequestLimiter;
import org.apache.distributedlog.service.stream.limiter.RequestLimiterBuilder;

public class StreamRequestLimiter
extends DynamicRequestLimiter<StreamOp> {
    private final DynamicDistributedLogConfiguration dynConf;
    private final StatsLogger limiterStatLogger;
    private final String streamName;

    public StreamRequestLimiter(String streamName, DynamicDistributedLogConfiguration dynConf, StatsLogger statsLogger, Feature disabledFeature) {
        super(dynConf, statsLogger, disabledFeature);
        this.limiterStatLogger = statsLogger;
        this.dynConf = dynConf;
        this.streamName = streamName;
        this.limiter = this.build();
    }

    @Override
    public RequestLimiter<StreamOp> build() {
        RequestLimiterBuilder rpsHardLimiterBuilder = RequestLimiterBuilder.newRpsLimiterBuilder().statsLogger(this.limiterStatLogger.scope("rps_hard_limit")).limit(this.dynConf.getRpsHardWriteLimit()).overlimit(new ComposableRequestLimiter.OverlimitFunction<StreamOp>(){

            public void apply(StreamOp op) throws OverCapacityException {
                throw new OverCapacityException("Being rate limited: RPS limit exceeded for stream " + StreamRequestLimiter.this.streamName);
            }
        });
        RequestLimiterBuilder rpsSoftLimiterBuilder = RequestLimiterBuilder.newRpsLimiterBuilder().statsLogger(this.limiterStatLogger.scope("rps_soft_limit")).limit(this.dynConf.getRpsSoftWriteLimit());
        RequestLimiterBuilder bpsHardLimiterBuilder = RequestLimiterBuilder.newBpsLimiterBuilder().statsLogger(this.limiterStatLogger.scope("bps_hard_limit")).limit(this.dynConf.getBpsHardWriteLimit()).overlimit(new ComposableRequestLimiter.OverlimitFunction<StreamOp>(){

            public void apply(StreamOp op) throws OverCapacityException {
                throw new OverCapacityException("Being rate limited: BPS limit exceeded for stream " + StreamRequestLimiter.this.streamName);
            }
        });
        RequestLimiterBuilder bpsSoftLimiterBuilder = RequestLimiterBuilder.newBpsLimiterBuilder().statsLogger(this.limiterStatLogger.scope("bps_soft_limit")).limit(this.dynConf.getBpsSoftWriteLimit());
        ChainedRequestLimiter.Builder builder = new ChainedRequestLimiter.Builder();
        builder.addLimiter(rpsSoftLimiterBuilder.build());
        builder.addLimiter(rpsHardLimiterBuilder.build());
        builder.addLimiter(bpsSoftLimiterBuilder.build());
        builder.addLimiter(bpsHardLimiterBuilder.build());
        builder.statsLogger(this.limiterStatLogger);
        return builder.build();
    }
}

