/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.balancer;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.RateLimiter;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.distributedlog.client.monitor.MonitorServiceClient;
import org.apache.distributedlog.service.DistributedLogClient;
import org.apache.distributedlog.service.balancer.Balancer;
import org.apache.distributedlog.service.balancer.BalancerUtils;
import org.apache.distributedlog.service.balancer.CountBasedStreamChooser;
import org.apache.distributedlog.service.balancer.LimitedStreamChooser;
import org.apache.distributedlog.service.balancer.StreamChooser;
import org.apache.distributedlog.service.balancer.StreamMover;
import org.apache.distributedlog.service.balancer.StreamMoverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBalancer
implements Balancer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleBalancer.class);
    protected final String target1;
    protected final String target2;
    protected final DistributedLogClient targetClient1;
    protected final DistributedLogClient targetClient2;
    protected final MonitorServiceClient targetMonitor1;
    protected final MonitorServiceClient targetMonitor2;

    public SimpleBalancer(String name1, DistributedLogClient client1, MonitorServiceClient monitor1, String name2, DistributedLogClient client2, MonitorServiceClient monitor2) {
        this.target1 = name1;
        this.targetClient1 = client1;
        this.targetMonitor1 = monitor1;
        this.target2 = name2;
        this.targetClient2 = client2;
        this.targetMonitor2 = monitor2;
    }

    protected static int countNumberStreams(Map<SocketAddress, Set<String>> distribution) {
        int count = 0;
        for (Set<String> streams : distribution.values()) {
            count += streams.size();
        }
        return count;
    }

    @Override
    public void balance(int rebalanceWaterMark, double rebalanceTolerancePercentage, int rebalanceConcurrency, Optional<RateLimiter> rebalanceRateLimiter) {
        MonitorServiceClient targetMonitor;
        DistributedLogClient targetClient;
        int targetStreamCount;
        String target;
        Map srcDistribution;
        MonitorServiceClient srcMonitor;
        DistributedLogClient srcClient;
        int srcStreamCount;
        String source;
        Map distribution1 = this.targetMonitor1.getStreamOwnershipDistribution();
        Map distribution2 = this.targetMonitor2.getStreamOwnershipDistribution();
        int proxyCount1 = distribution1.size();
        int streamCount1 = SimpleBalancer.countNumberStreams(distribution1);
        int proxyCount2 = distribution2.size();
        int streamCount2 = SimpleBalancer.countNumberStreams(distribution2);
        logger.info("'{}' has {} streams by {} proxies; while '{}' has {} streams by {} proxies.", new Object[]{this.target1, streamCount1, proxyCount1, this.target2, streamCount2, proxyCount2});
        if (streamCount1 > streamCount2) {
            source = this.target1;
            srcStreamCount = streamCount1;
            srcClient = this.targetClient1;
            srcMonitor = this.targetMonitor1;
            srcDistribution = distribution1;
            target = this.target2;
            targetStreamCount = streamCount2;
            targetClient = this.targetClient2;
            targetMonitor = this.targetMonitor2;
        } else {
            source = this.target2;
            srcStreamCount = streamCount2;
            srcClient = this.targetClient2;
            srcMonitor = this.targetMonitor2;
            srcDistribution = distribution2;
            target = this.target1;
            targetStreamCount = streamCount1;
            targetClient = this.targetClient1;
            targetMonitor = this.targetMonitor1;
        }
        HashMap<String, Integer> loadDistribution = new HashMap<String, Integer>();
        loadDistribution.put(source, srcStreamCount);
        loadDistribution.put(target, targetStreamCount);
        int numStreamsToRebalance = BalancerUtils.calculateNumStreamsToRebalance(source, loadDistribution, rebalanceWaterMark, rebalanceTolerancePercentage);
        if (numStreamsToRebalance <= 0) {
            logger.info("No streams need to be rebalanced from '{}' to '{}'.", (Object)source, (Object)target);
            return;
        }
        LimitedStreamChooser streamChooser = LimitedStreamChooser.of(new CountBasedStreamChooser(srcDistribution), numStreamsToRebalance);
        StreamMoverImpl streamMover = new StreamMoverImpl(source, srcClient, srcMonitor, target, targetClient, targetMonitor);
        this.moveStreams(streamChooser, streamMover, rebalanceConcurrency, rebalanceRateLimiter);
    }

    @Override
    public void balanceAll(String source, int rebalanceConcurrency, Optional<RateLimiter> rebalanceRateLimiter) {
        MonitorServiceClient targetMonitor;
        DistributedLogClient targetClient;
        String target;
        MonitorServiceClient sourceMonitor;
        DistributedLogClient sourceClient;
        if (this.target1.equals(source)) {
            sourceClient = this.targetClient1;
            sourceMonitor = this.targetMonitor1;
            target = this.target2;
            targetClient = this.targetClient2;
            targetMonitor = this.targetMonitor2;
        } else if (this.target2.equals(source)) {
            sourceClient = this.targetClient2;
            sourceMonitor = this.targetMonitor2;
            target = this.target1;
            targetClient = this.targetClient1;
            targetMonitor = this.targetMonitor1;
        } else {
            throw new IllegalArgumentException("Unknown target " + source);
        }
        Map distribution = sourceMonitor.getStreamOwnershipDistribution();
        if (distribution.isEmpty()) {
            return;
        }
        CountBasedStreamChooser streamChooser = new CountBasedStreamChooser(distribution);
        StreamMoverImpl streamMover = new StreamMoverImpl(source, sourceClient, sourceMonitor, target, targetClient, targetMonitor);
        this.moveStreams(streamChooser, streamMover, rebalanceConcurrency, rebalanceRateLimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveStreams(StreamChooser streamChooser, StreamMover streamMover, int concurrency, Optional<RateLimiter> rateLimiter) {
        CountDownLatch doneLatch = new CountDownLatch(concurrency);
        RegionMover regionMover = new RegionMover(streamChooser, streamMover, rateLimiter, doneLatch);
        ExecutorService executorService = Executors.newFixedThreadPool(concurrency);
        try {
            for (int i = 0; i < concurrency; ++i) {
                executorService.submit(regionMover);
            }
            try {
                doneLatch.await();
            }
            catch (InterruptedException e) {
                logger.info("{} is interrupted. Stopping it ...", (Object)streamMover);
                regionMover.shutdown();
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    @Override
    public void close() {
    }

    static class RegionMover
    implements Runnable {
        final StreamChooser streamChooser;
        final StreamMover streamMover;
        final Optional<RateLimiter> rateLimiter;
        final CountDownLatch doneLatch;
        volatile boolean running = true;

        RegionMover(StreamChooser streamChooser, StreamMover streamMover, Optional<RateLimiter> rateLimiter, CountDownLatch doneLatch) {
            this.streamChooser = streamChooser;
            this.streamMover = streamMover;
            this.rateLimiter = rateLimiter;
            this.doneLatch = doneLatch;
        }

        @Override
        public void run() {
            while (this.running) {
                String stream;
                if (this.rateLimiter.isPresent()) {
                    ((RateLimiter)this.rateLimiter.get()).acquire();
                }
                if (null == (stream = this.streamChooser.choose())) break;
                this.streamMover.moveStream(stream);
            }
            this.doneLatch.countDown();
        }

        void shutdown() {
            this.running = false;
        }
    }
}

