/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.jshell;

import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.openjdk.source.tree.AssignmentTree;
import org.openjdk.source.tree.CompilationUnitTree;
import org.openjdk.source.tree.ErroneousTree;
import org.openjdk.source.tree.ExpressionTree;
import org.openjdk.source.tree.IdentifierTree;
import org.openjdk.source.tree.ImportTree;
import org.openjdk.source.tree.MemberSelectTree;
import org.openjdk.source.tree.MethodInvocationTree;
import org.openjdk.source.tree.MethodTree;
import org.openjdk.source.tree.NewClassTree;
import org.openjdk.source.tree.Scope;
import org.openjdk.source.tree.Tree;
import org.openjdk.source.tree.VariableTree;
import org.openjdk.source.util.SourcePositions;
import org.openjdk.source.util.TreePath;
import org.openjdk.source.util.TreePathScanner;
import org.openjdk.tools.javac.api.JavacScope;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javac.util.Pair;
import org.openjdk.tools.jshell.CompletenessAnalyzer;
import org.openjdk.tools.jshell.JShell;
import org.openjdk.tools.jshell.MaskCommentsAndModifiers;
import org.openjdk.tools.jshell.MemoryFileManager;
import org.openjdk.tools.jshell.OuterWrap;
import org.openjdk.tools.jshell.ReplResolve;
import org.openjdk.tools.jshell.SourceCodeAnalysis;
import org.openjdk.tools.jshell.TaskFactory;
import org.openjdk.tools.jshell.TreeDissector;
import org.openjdk.tools.jshell.Util;
import org.openjdk.tools.jshell.Wrap;

class SourceCodeAnalysisImpl
extends SourceCodeAnalysis {
    private static final Map<Path, ClassIndex> PATH_TO_INDEX = new HashMap<Path, ClassIndex>();
    private static final ExecutorService INDEXER = Executors.newFixedThreadPool(1, r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setUncaughtExceptionHandler((thread, ex) -> ex.printStackTrace());
        return t;
    });
    private final JShell proc;
    private final CompletenessAnalyzer ca;
    private final Map<Path, ClassIndex> currentIndexes = new HashMap<Path, ClassIndex>();
    private int indexVersion;
    private int classpathVersion;
    private final Object suspendLock = new Object();
    private int suspend;
    private final Pattern JAVA_IDENTIFIER = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private final Predicate<Element> TRUE = el -> true;
    private final Predicate<Element> FALSE = this.TRUE.negate();
    private final Predicate<Element> IS_STATIC = el -> el.getModifiers().contains((Object)Modifier.STATIC);
    private final Predicate<Element> IS_CONSTRUCTOR = el -> el.getKind() == ElementKind.CONSTRUCTOR;
    private final Predicate<Element> IS_METHOD = el -> el.getKind() == ElementKind.METHOD;
    private final Predicate<Element> IS_PACKAGE = el -> el.getKind() == ElementKind.PACKAGE;
    private final Predicate<Element> IS_CLASS = el -> el.getKind().isClass();
    private final Predicate<Element> IS_INTERFACE = el -> el.getKind().isInterface();
    private final Predicate<Element> IS_VOID = el -> el.asType().getKind() == TypeKind.VOID;
    private final Predicate<Element> STATIC_ONLY = el -> {
        ElementKind kind = el.getKind();
        Element encl = el.getEnclosingElement();
        ElementKind enclKind = encl != null ? encl.getKind() : ElementKind.OTHER;
        return this.IS_STATIC.or(this.IS_PACKAGE).or(this.IS_CLASS).or(this.IS_INTERFACE).test((Element)el) || this.IS_PACKAGE.test(encl) || kind == ElementKind.TYPE_PARAMETER && !enclKind.isClass() && !enclKind.isInterface();
    };
    private final Predicate<Element> INSTANCE_ONLY = el -> {
        Element encl = el.getEnclosingElement();
        return this.IS_STATIC.or(this.IS_CLASS).or(this.IS_INTERFACE).negate().test((Element)el) || this.IS_PACKAGE.test(encl);
    };
    private final Function<Element, Iterable<? extends Element>> IDENTITY = el -> Collections.singletonList(el);
    private final Function<Boolean, String> DEFAULT_PAREN = hasParams -> hasParams != false ? "(" : "()";
    private final Function<Boolean, String> NO_PAREN = hasParams -> "";

    SourceCodeAnalysisImpl(JShell proc) {
        this.proc = proc;
        this.ca = new CompletenessAnalyzer(proc);
        this.classpathVersion = 1;
        int cpVersion = 1;
        INDEXER.submit(() -> this.refreshIndexes(cpVersion));
    }

    @Override
    public SourceCodeAnalysis.CompletionInfo analyzeCompletion(String srcInput) {
        MaskCommentsAndModifiers mcm = new MaskCommentsAndModifiers(srcInput, false);
        String cleared = mcm.cleared();
        String trimmedInput = Util.trimEnd(cleared);
        if (trimmedInput.isEmpty()) {
            return new SourceCodeAnalysis.CompletionInfo(SourceCodeAnalysis.Completeness.EMPTY, srcInput.length(), srcInput, "");
        }
        CompletenessAnalyzer.CaInfo info = this.ca.scan(trimmedInput);
        SourceCodeAnalysis.Completeness status = info.status;
        int unitEndPos = info.unitEndPos;
        if (unitEndPos > srcInput.length()) {
            unitEndPos = srcInput.length();
        }
        int nonCommentNonWhiteLength = trimmedInput.length();
        String src = srcInput.substring(0, unitEndPos);
        switch (status) {
            case COMPLETE: {
                if (unitEndPos == nonCommentNonWhiteLength) {
                    String compileSource = src + mcm.mask().substring(nonCommentNonWhiteLength);
                    this.proc.debug(4, "Complete: %s\n", compileSource);
                    this.proc.debug(4, "   nothing remains.\n", new Object[0]);
                    return new SourceCodeAnalysis.CompletionInfo(status, unitEndPos, compileSource, "");
                }
                String remain = srcInput.substring(unitEndPos);
                this.proc.debug(4, "Complete: %s\n", src);
                this.proc.debug(4, "          remaining: %s\n", remain);
                return new SourceCodeAnalysis.CompletionInfo(status, unitEndPos, src, remain);
            }
            case COMPLETE_WITH_SEMI: {
                String compileSource = src + ";" + mcm.mask().substring(nonCommentNonWhiteLength);
                this.proc.debug(4, "Complete with semi: %s\n", compileSource);
                this.proc.debug(4, "   nothing remains.\n", new Object[0]);
                return new SourceCodeAnalysis.CompletionInfo(status, unitEndPos, compileSource, "");
            }
            case DEFINITELY_INCOMPLETE: {
                this.proc.debug(4, "Incomplete: %s\n", srcInput);
                return new SourceCodeAnalysis.CompletionInfo(status, unitEndPos, null, srcInput + '\n');
            }
            case CONSIDERED_INCOMPLETE: {
                this.proc.debug(4, "Considered incomplete: %s\n", srcInput);
                return new SourceCodeAnalysis.CompletionInfo(status, unitEndPos, null, srcInput + '\n');
            }
            case EMPTY: {
                this.proc.debug(4, "Detected empty: %s\n", srcInput);
                return new SourceCodeAnalysis.CompletionInfo(status, unitEndPos, srcInput, "");
            }
            case UNKNOWN: {
                this.proc.debug(4, "Detected error: %s\n", srcInput);
                return new SourceCodeAnalysis.CompletionInfo(status, unitEndPos, srcInput, "");
            }
        }
        throw new InternalError();
    }

    private OuterWrap wrapInClass(Wrap guts) {
        String imports = this.proc.maps.packageAndImportsExcept(null, null);
        return OuterWrap.wrapInClass(this.proc.maps.packageName(), "$REPL00DOESNOTMATTER", imports, "", guts);
    }

    private Tree.Kind guessKind(String code) {
        TaskFactory taskFactory = this.proc.taskFactory;
        taskFactory.getClass();
        TaskFactory.ParseTask pt = taskFactory.new TaskFactory.ParseTask(code);
        java.util.List<? extends Tree> units = pt.units();
        if (units.isEmpty()) {
            return Tree.Kind.BLOCK;
        }
        Tree unitTree = units.get(0);
        this.proc.debug(4, "Kind: %s -- %s\n", new Object[]{unitTree.getKind(), unitTree});
        return unitTree.getKind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.util.List<SourceCodeAnalysis.Suggestion> completionSuggestions(String code, int cursor, int[] anchor) {
        this.suspendIndexing();
        try {
            java.util.List<SourceCodeAnalysis.Suggestion> list = this.completionSuggestionsImpl(code, cursor, anchor);
            return list;
        }
        finally {
            this.resumeIndexing();
        }
    }

    private java.util.List<SourceCodeAnalysis.Suggestion> completionSuggestionsImpl(String code, int cursor, int[] anchor) {
        OuterWrap codeWrap;
        code = code.substring(0, cursor);
        Matcher m = this.JAVA_IDENTIFIER.matcher(code);
        String identifier = "";
        while (m.find()) {
            if (m.end() != code.length()) continue;
            cursor = m.start();
            code = code.substring(0, cursor);
            identifier = m.group();
        }
        if ((code = code.substring(0, cursor)).trim().isEmpty()) {
            code = code + ";";
        }
        switch (this.guessKind(code)) {
            case IMPORT: {
                codeWrap = OuterWrap.wrapImport(null, Wrap.importWrap(code + "any.any"));
                break;
            }
            case METHOD: {
                codeWrap = this.wrapInClass(Wrap.classMemberWrap(code));
                break;
            }
            default: {
                codeWrap = this.wrapInClass(Wrap.methodWrap(code));
            }
        }
        String requiredPrefix = identifier;
        return this.computeSuggestions(codeWrap, cursor, anchor).stream().filter(s -> s.continuation.startsWith(requiredPrefix) && !s.continuation.equals("$REPL00DOESNOTMATTER")).sorted(Comparator.comparing(s -> s.continuation)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private java.util.List<SourceCodeAnalysis.Suggestion> computeSuggestions(OuterWrap code, int cursor, int[] anchor) {
        TaskFactory taskFactory = this.proc.taskFactory;
        taskFactory.getClass();
        TaskFactory.AnalyzeTask at = taskFactory.new TaskFactory.AnalyzeTask(code);
        SourcePositions sp = at.trees().getSourcePositions();
        CompilationUnitTree topLevel = at.firstCuTree();
        ArrayList<SourceCodeAnalysis.Suggestion> result = new ArrayList<SourceCodeAnalysis.Suggestion>();
        TreePath tp = this.pathFor(topLevel, sp, code.snippetIndexToWrapIndex(cursor));
        if (tp != null) {
            Predicate<Element> smartFilter;
            Predicate<Element> smartTypeFilter;
            Scope scope = at.trees().getScope(tp);
            Predicate<Element> accessibility = this.createAccessibilityFilter(at, tp);
            Iterable<TypeMirror> targetTypes = this.findTargetType(at, tp);
            if (targetTypes != null) {
                smartTypeFilter = el -> {
                    TypeMirror resultOf = this.resultTypeOf((Element)el);
                    return Util.stream(targetTypes).anyMatch(targetType -> at.getTypes().isAssignable(resultOf, (TypeMirror)targetType));
                };
                smartFilter = this.IS_CLASS.negate().and(this.IS_INTERFACE.negate()).and(this.IS_PACKAGE.negate()).and(smartTypeFilter);
            } else {
                smartFilter = this.TRUE;
                smartTypeFilter = this.TRUE;
            }
            switch (tp.getLeaf().getKind()) {
                case MEMBER_SELECT: {
                    MemberSelectTree mst = (MemberSelectTree)tp.getLeaf();
                    if (mst.getIdentifier().contentEquals("*")) break;
                    TreePath exprPath = new TreePath(tp, mst.getExpression());
                    TypeMirror site = at.trees().getTypeMirror(exprPath);
                    boolean staticOnly = this.isStaticContext(at, exprPath);
                    ImportTree it = this.findImport(tp);
                    boolean isImport = it != null;
                    java.util.List<? extends Element> members = this.membersOf(at, site, staticOnly && !isImport);
                    Predicate<Element> filter = accessibility;
                    Function<Boolean, String> paren = this.DEFAULT_PAREN;
                    if (this.isNewClass(tp)) {
                        Predicate<Element> constructorFilter = accessibility.and(this.IS_CONSTRUCTOR).and(el -> {
                            if (el.getEnclosingElement().getEnclosingElement().getKind() == ElementKind.CLASS) {
                                return el.getEnclosingElement().getModifiers().contains((Object)Modifier.STATIC);
                            }
                            return true;
                        });
                        this.addElements(this.membersOf(at, members), constructorFilter, smartFilter, result);
                        filter = filter.and(this.IS_PACKAGE);
                    } else if (this.isThrowsClause(tp)) {
                        staticOnly = true;
                        filter = filter.and(this.IS_PACKAGE.or(this.IS_CLASS).or(this.IS_INTERFACE));
                        smartFilter = this.IS_PACKAGE.negate().and(smartTypeFilter);
                    } else if (isImport) {
                        paren = this.NO_PAREN;
                        if (!it.isStatic()) {
                            filter = filter.and(this.IS_PACKAGE.or(this.IS_CLASS).or(this.IS_INTERFACE));
                        }
                    } else {
                        filter = filter.and(this.IS_CONSTRUCTOR.negate());
                    }
                    filter = filter.and(staticOnly ? this.STATIC_ONLY : this.INSTANCE_ONLY);
                    this.addElements(members, filter, smartFilter, paren, result);
                    break;
                }
                case IDENTIFIER: {
                    if (this.isNewClass(tp)) {
                        Function<Element, Iterable<? extends Element>> listEnclosed = el -> el.getKind() == ElementKind.PACKAGE ? Collections.singletonList(el) : el.getEnclosedElements();
                        Predicate<Element> filter = accessibility.and(this.IS_CONSTRUCTOR.or(this.IS_PACKAGE));
                        NewClassTree newClassTree = (NewClassTree)tp.getParentPath().getLeaf();
                        ExpressionTree enclosingExpression = newClassTree.getEnclosingExpression();
                        if (enclosingExpression != null) {
                            TypeMirror site = at.trees().getTypeMirror(new TreePath(tp, enclosingExpression));
                            filter = filter.and(el -> el.getEnclosingElement().getKind() == ElementKind.CLASS && !el.getEnclosingElement().getModifiers().contains((Object)Modifier.STATIC));
                            this.addElements(this.membersOf(at, this.membersOf(at, site, false)), filter, smartFilter, result);
                            break;
                        }
                        this.addScopeElements(at, scope, listEnclosed, filter, smartFilter, result);
                        break;
                    }
                    if (this.isThrowsClause(tp)) {
                        Predicate<Element> accept = accessibility.and(this.STATIC_ONLY).and(this.IS_PACKAGE.or(this.IS_CLASS).or(this.IS_INTERFACE));
                        this.addScopeElements(at, scope, this.IDENTITY, accept, this.IS_PACKAGE.negate().and(smartTypeFilter), result);
                        break;
                    }
                    ImportTree it = this.findImport(tp);
                    if (it == null) break;
                    this.addElements(this.membersOf(at, at.getElements().getPackageElement("").asType(), false), it.isStatic() ? this.STATIC_ONLY.and(accessibility) : accessibility, smartFilter, result);
                    break;
                }
                case ERRONEOUS: 
                case EMPTY_STATEMENT: {
                    boolean staticOnly = ReplResolve.isStatic(((JavacScope)scope).getEnv());
                    Predicate<Element> accept = accessibility.and(staticOnly ? this.STATIC_ONLY : this.TRUE);
                    this.addScopeElements(at, scope, this.IDENTITY, accept, smartFilter, result);
                    Tree parent = tp.getParentPath().getLeaf();
                    switch (parent.getKind()) {
                        case VARIABLE: {
                            accept = ((VariableTree)parent).getType() == tp.getLeaf() ? this.IS_VOID.negate() : this.TRUE;
                            break;
                        }
                        case PARAMETERIZED_TYPE: 
                        case TYPE_PARAMETER: 
                        case CLASS: 
                        case INTERFACE: 
                        case ENUM: {
                            accept = this.FALSE;
                            break;
                        }
                        default: {
                            accept = this.TRUE;
                        }
                    }
                    this.addElements(this.primitivesOrVoid(at), accept, smartFilter, result);
                    break;
                }
            }
        }
        anchor[0] = cursor;
        return result;
    }

    private boolean isStaticContext(TaskFactory.AnalyzeTask at, TreePath path) {
        switch (path.getLeaf().getKind()) {
            case ARRAY_TYPE: 
            case PRIMITIVE_TYPE: {
                return true;
            }
        }
        Element selectEl = at.trees().getElement(path);
        return selectEl != null && (selectEl.getKind().isClass() || selectEl.getKind().isInterface() || selectEl.getKind() == ElementKind.TYPE_PARAMETER) && selectEl.asType().getKind() != TypeKind.ERROR;
    }

    private TreePath pathFor(final CompilationUnitTree topLevel, final SourcePositions sp, final int pos) {
        final TreePath[] deepest = new TreePath[1];
        new TreePathScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void p) {
                long prevEnd;
                if (tree == null) {
                    return null;
                }
                long start = sp.getStartPosition(topLevel, tree);
                long end = sp.getEndPosition(topLevel, tree);
                long l = prevEnd = deepest[0] != null ? sp.getEndPosition(topLevel, deepest[0].getLeaf()) : -1L;
                if (start <= (long)pos && (long)pos <= end && (start != end || prevEnd != end || deepest[0] == null || deepest[0].getParentPath().getLeaf() != this.getCurrentPath().getLeaf())) {
                    deepest[0] = new TreePath(this.getCurrentPath(), tree);
                    return (Void)super.scan(tree, p);
                }
                return null;
            }

            @Override
            public Void visitErroneous(ErroneousTree node, Void p) {
                return (Void)this.scan(node.getErrorTrees(), null);
            }
        }.scan((Tree)topLevel, (Void)null);
        return deepest[0];
    }

    private boolean isNewClass(TreePath tp) {
        return tp.getParentPath() != null && tp.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS && ((NewClassTree)tp.getParentPath().getLeaf()).getIdentifier() == tp.getLeaf();
    }

    private boolean isThrowsClause(TreePath tp) {
        Tree parent = tp.getParentPath().getLeaf();
        return parent.getKind() == Tree.Kind.METHOD && ((MethodTree)parent).getThrows().contains(tp.getLeaf());
    }

    private ImportTree findImport(TreePath tp) {
        while (tp != null && tp.getLeaf().getKind() != Tree.Kind.IMPORT) {
            tp = tp.getParentPath();
        }
        return tp != null ? (ImportTree)tp.getLeaf() : null;
    }

    private Predicate<Element> createAccessibilityFilter(TaskFactory.AnalyzeTask at, TreePath tp) {
        Scope scope = at.trees().getScope(tp);
        return el -> {
            switch (el.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    return at.trees().isAccessible(scope, (TypeElement)el);
                }
                case EXCEPTION_PARAMETER: 
                case LOCAL_VARIABLE: 
                case PARAMETER: 
                case RESOURCE_VARIABLE: 
                case PACKAGE: {
                    return true;
                }
            }
            TypeMirror type = el.getEnclosingElement().asType();
            if (type.getKind() == TypeKind.DECLARED) {
                return at.trees().isAccessible(scope, (Element)el, (DeclaredType)type);
            }
            return true;
        };
    }

    private void addElements(Iterable<? extends Element> elements, Predicate<Element> accept, Predicate<Element> smart, java.util.List<SourceCodeAnalysis.Suggestion> result) {
        this.addElements(elements, accept, smart, this.DEFAULT_PAREN, result);
    }

    private void addElements(Iterable<? extends Element> elements, Predicate<Element> accept, Predicate<Element> smart, Function<Boolean, String> paren, java.util.List<SourceCodeAnalysis.Suggestion> result) {
        Set hasParams = Util.stream(elements).filter(accept).filter(this.IS_CONSTRUCTOR.or(this.IS_METHOD)).filter(c -> !((ExecutableElement)c).getParameters().isEmpty()).map(this::simpleName).collect(Collectors.toSet());
        for (Element element : elements) {
            if (!accept.test(element)) continue;
            String simpleName = this.simpleName(element);
            if (element.getKind() == ElementKind.CONSTRUCTOR || element.getKind() == ElementKind.METHOD) {
                simpleName = simpleName + paren.apply(hasParams.contains(simpleName));
            }
            result.add(new SourceCodeAnalysis.Suggestion(simpleName, smart.test(element)));
        }
    }

    private String simpleName(Element el) {
        return el.getKind() == ElementKind.CONSTRUCTOR ? el.getEnclosingElement().getSimpleName().toString() : el.getSimpleName().toString();
    }

    private java.util.List<? extends Element> membersOf(TaskFactory.AnalyzeTask at, TypeMirror site, boolean shouldGenerateDotClassItem) {
        if (site == null) {
            return Collections.emptyList();
        }
        switch (site.getKind()) {
            case DECLARED: {
                TypeElement element = (TypeElement)at.getTypes().asElement(site);
                ArrayList<? extends Element> result = new ArrayList<Element>();
                result.addAll(at.getElements().getAllMembers(element));
                if (shouldGenerateDotClassItem) {
                    result.add(this.createDotClassSymbol(at, site));
                }
                result.removeIf(el -> el.getKind() == ElementKind.STATIC_INIT);
                return result;
            }
            case ERROR: {
                TypeElement typeElement = (TypeElement)at.getTypes().asElement(site);
                Element enclosingElement = typeElement.getEnclosingElement();
                String parentPackageName = enclosingElement instanceof QualifiedNameable ? ((QualifiedNameable)enclosingElement).getQualifiedName().toString() : "";
                Set<PackageElement> packages = this.listPackages(at, parentPackageName);
                return packages.stream().filter(p -> p.getQualifiedName().equals(typeElement.getQualifiedName())).findAny().map(p -> this.membersOf(at, p.asType(), false)).orElse(Collections.emptyList());
            }
            case PACKAGE: {
                String packageName = site.toString();
                ArrayList<? extends Element> result = new ArrayList<Element>();
                result.addAll(this.getEnclosedElements(at.getElements().getPackageElement(packageName)));
                result.addAll(this.listPackages(at, packageName));
                return result;
            }
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case FLOAT: 
            case LONG: 
            case DOUBLE: 
            case VOID: {
                return shouldGenerateDotClassItem ? Collections.singletonList(this.createDotClassSymbol(at, site)) : Collections.emptyList();
            }
            case ARRAY: {
                ArrayList<Element> result = new ArrayList<Element>();
                result.add(this.createArrayLengthSymbol(at, site));
                if (shouldGenerateDotClassItem) {
                    result.add(this.createDotClassSymbol(at, site));
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    private java.util.List<? extends Element> membersOf(TaskFactory.AnalyzeTask at, java.util.List<? extends Element> elements) {
        return elements.stream().flatMap(e -> this.membersOf(at, e.asType(), true).stream()).collect(Collectors.toList());
    }

    private java.util.List<? extends Element> getEnclosedElements(PackageElement packageEl) {
        if (packageEl == null) {
            return Collections.emptyList();
        }
        while (true) {
            try {
                return packageEl.getEnclosedElements().stream().filter(el -> el.asType() != null).filter(el -> el.asType().getKind() != TypeKind.ERROR).collect(Collectors.toList());
            }
            catch (Symbol.CompletionFailure completionFailure) {
                continue;
            }
            break;
        }
    }

    private java.util.List<? extends Element> primitivesOrVoid(TaskFactory.AnalyzeTask at) {
        Types types = at.getTypes();
        return Stream.of(TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT, TypeKind.VOID).map(tk -> (Type)(tk == TypeKind.VOID ? types.getNoType((TypeKind)((Object)tk)) : types.getPrimitiveType((TypeKind)((Object)tk)))).map(Type::asElement).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void classpathChanged() {
        Map<Path, ClassIndex> map = this.currentIndexes;
        synchronized (map) {
            int cpVersion = ++this.classpathVersion;
            INDEXER.submit(() -> this.refreshIndexes(cpVersion));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<PackageElement> listPackages(TaskFactory.AnalyzeTask at, String enclosingPackage) {
        Map<Path, ClassIndex> map = this.currentIndexes;
        synchronized (map) {
            return this.currentIndexes.values().stream().flatMap(idx -> idx.packages.stream()).filter(p -> enclosingPackage.isEmpty() || p.startsWith(enclosingPackage + ".")).map(p -> {
                int dot = p.indexOf(46, enclosingPackage.length() + 1);
                return dot == -1 ? p : p.substring(0, dot);
            }).distinct().map(p -> this.createPackageElement(at, (String)p)).collect(Collectors.toSet());
        }
    }

    private PackageElement createPackageElement(TaskFactory.AnalyzeTask at, String packageName) {
        Names names = Names.instance(at.getContext());
        Symtab syms = Symtab.instance(at.getContext());
        Symbol.PackageSymbol existing = syms.enterPackage(names.fromString(packageName));
        return existing;
    }

    private Element createArrayLengthSymbol(TaskFactory.AnalyzeTask at, TypeMirror site) {
        Name length = Names.instance((Context)at.getContext()).length;
        Type.JCPrimitiveType intType = Symtab.instance((Context)at.getContext()).intType;
        return new Symbol.VarSymbol(17L, length, intType, ((Type)site).tsym);
    }

    private Element createDotClassSymbol(TaskFactory.AnalyzeTask at, TypeMirror site) {
        Name _class = Names.instance((Context)at.getContext())._class;
        Type classType = Symtab.instance((Context)at.getContext()).classType;
        Type erasedSite = (Type)at.getTypes().erasure(site);
        classType = new Type.ClassType(classType.getEnclosingType(), List.of(erasedSite), classType.asElement());
        return new Symbol.VarSymbol(25L, _class, classType, erasedSite.tsym);
    }

    private Iterable<? extends Element> scopeContent(TaskFactory.AnalyzeTask at, final Scope scope, Function<Element, Iterable<? extends Element>> elementConvertor) {
        Iterable scopeIterable = () -> new Iterator<Scope>(){
            private Scope currentScope;
            {
                this.currentScope = scope;
            }

            @Override
            public boolean hasNext() {
                return this.currentScope != null;
            }

            @Override
            public Scope next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Scope scope2 = this.currentScope;
                    return scope2;
                }
                finally {
                    this.currentScope = this.currentScope.getEnclosingScope();
                }
            }
        };
        java.util.List result = Util.stream(scopeIterable).flatMap(s -> Util.stream(s.getLocalElements())).flatMap(el -> Util.stream((Iterable)elementConvertor.apply((Element)el))).collect(Collectors.toCollection(ArrayList::new));
        result.addAll(this.listPackages(at, ""));
        return result;
    }

    private Iterable<TypeMirror> findTargetType(TaskFactory.AnalyzeTask at, TreePath forPath) {
        if (forPath.getParentPath() == null) {
            return null;
        }
        Tree current = forPath.getLeaf();
        switch (forPath.getParentPath().getLeaf().getKind()) {
            case ASSIGNMENT: {
                AssignmentTree tree = (AssignmentTree)forPath.getParentPath().getLeaf();
                if (tree.getExpression() != current) break;
                return Collections.singletonList(at.trees().getTypeMirror(new TreePath(forPath.getParentPath(), tree.getVariable())));
            }
            case VARIABLE: {
                VariableTree tree = (VariableTree)forPath.getParentPath().getLeaf();
                if (tree.getInitializer() != current) break;
                return Collections.singletonList(at.trees().getTypeMirror(forPath.getParentPath()));
            }
            case ERRONEOUS: {
                return this.findTargetType(at, forPath.getParentPath());
            }
            case NEW_CLASS: {
                NewClassTree nct = (NewClassTree)forPath.getParentPath().getLeaf();
                java.util.List<TypeMirror> actuals = this.computeActualInvocationTypes(at, nct.getArguments(), forPath);
                if (actuals != null) {
                    Iterable<Pair<ExecutableElement, ExecutableType>> candidateConstructors = this.newClassCandidates(at, forPath.getParentPath());
                    return this.computeSmartTypesForExecutableType(at, candidateConstructors, actuals);
                }
                return this.findTargetType(at, forPath.getParentPath());
            }
            case METHOD: {
                if (!this.isThrowsClause(forPath)) break;
            }
            case THROW: {
                return Collections.singletonList(at.getElements().getTypeElement("java.lang.Throwable").asType());
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree mit = (MethodInvocationTree)forPath.getParentPath().getLeaf();
                java.util.List<TypeMirror> actuals = this.computeActualInvocationTypes(at, mit.getArguments(), forPath);
                if (actuals == null) {
                    return null;
                }
                Iterable<Pair<ExecutableElement, ExecutableType>> candidateMethods = this.methodCandidates(at, forPath.getParentPath());
                return this.computeSmartTypesForExecutableType(at, candidateMethods, actuals);
            }
        }
        return null;
    }

    private java.util.List<TypeMirror> computeActualInvocationTypes(TaskFactory.AnalyzeTask at, java.util.List<? extends ExpressionTree> arguments, TreePath currentArgument) {
        if (currentArgument == null) {
            return null;
        }
        int paramIndex = arguments.indexOf(currentArgument.getLeaf());
        if (paramIndex == -1) {
            return null;
        }
        ArrayList<TypeMirror> actuals = new ArrayList<TypeMirror>();
        for (ExpressionTree expressionTree : arguments.subList(0, paramIndex)) {
            actuals.add(at.trees().getTypeMirror(new TreePath(currentArgument.getParentPath(), expressionTree)));
        }
        return actuals;
    }

    private java.util.List<Pair<ExecutableElement, ExecutableType>> filterExecutableTypesByArguments(TaskFactory.AnalyzeTask at, Iterable<Pair<ExecutableElement, ExecutableType>> candidateMethods, java.util.List<TypeMirror> precedingActualTypes) {
        ArrayList<Pair<ExecutableElement, ExecutableType>> candidate = new ArrayList<Pair<ExecutableElement, ExecutableType>>();
        int paramIndex = precedingActualTypes.size();
        block0: for (Pair<ExecutableElement, ExecutableType> method : candidateMethods) {
            boolean varargInvocation = paramIndex >= ((ExecutableType)method.snd).getParameterTypes().size();
            for (int i = 0; i < paramIndex; ++i) {
                TypeMirror actual = precedingActualTypes.get(i);
                if (this.parameterType((ExecutableElement)method.fst, (ExecutableType)method.snd, i, !varargInvocation).noneMatch(formal -> at.getTypes().isAssignable(actual, (TypeMirror)formal))) continue block0;
            }
            candidate.add(method);
        }
        return candidate;
    }

    private Stream<TypeMirror> parameterType(ExecutableElement method, ExecutableType methodType, int paramIndex, boolean allowVarArgsArray) {
        int paramCount = methodType.getParameterTypes().size();
        if (paramIndex >= paramCount && !method.isVarArgs()) {
            return Stream.empty();
        }
        if (paramIndex < paramCount - 1 || !method.isVarArgs()) {
            return Stream.of(methodType.getParameterTypes().get(paramIndex));
        }
        TypeMirror varargType = methodType.getParameterTypes().get(paramCount - 1);
        TypeMirror elemenType = ((ArrayType)varargType).getComponentType();
        if (paramIndex >= paramCount || !allowVarArgsArray) {
            return Stream.of(elemenType);
        }
        return Stream.of(varargType, elemenType);
    }

    private java.util.List<TypeMirror> computeSmartTypesForExecutableType(TaskFactory.AnalyzeTask at, Iterable<Pair<ExecutableElement, ExecutableType>> candidateMethods, java.util.List<TypeMirror> precedingActualTypes) {
        ArrayList<TypeMirror> candidate = new ArrayList<TypeMirror>();
        int paramIndex = precedingActualTypes.size();
        this.filterExecutableTypesByArguments(at, candidateMethods, precedingActualTypes).stream().flatMap(method -> this.parameterType((ExecutableElement)method.fst, (ExecutableType)method.snd, paramIndex, true)).forEach(candidate::add);
        return candidate;
    }

    private TypeMirror resultTypeOf(Element el) {
        switch (el.getKind()) {
            case METHOD: {
                return ((ExecutableElement)el).getReturnType();
            }
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: {
                return el.getEnclosingElement().asType();
            }
        }
        return el.asType();
    }

    private void addScopeElements(TaskFactory.AnalyzeTask at, Scope scope, Function<Element, Iterable<? extends Element>> elementConvertor, Predicate<Element> filter, Predicate<Element> smartFilter, java.util.List<SourceCodeAnalysis.Suggestion> result) {
        this.addElements(this.scopeContent(at, scope, elementConvertor), filter, smartFilter, result);
    }

    private Iterable<Pair<ExecutableElement, ExecutableType>> methodCandidates(TaskFactory.AnalyzeTask at, TreePath invocation) {
        MethodInvocationTree mit = (MethodInvocationTree)invocation.getLeaf();
        ExpressionTree select = mit.getMethodSelect();
        ArrayList<Pair<ExecutableElement, ExecutableType>> result = new ArrayList<Pair<ExecutableElement, ExecutableType>>();
        Predicate<Element> accessibility = this.createAccessibilityFilter(at, invocation);
        switch (select.getKind()) {
            case MEMBER_SELECT: {
                Element siteEl;
                MemberSelectTree mst = (MemberSelectTree)select;
                TreePath tp = new TreePath(new TreePath(invocation, select), mst.getExpression());
                TypeMirror site = at.trees().getTypeMirror(tp);
                if (site == null || site.getKind() != TypeKind.DECLARED || (siteEl = at.getTypes().asElement(site)) == null) break;
                if (this.isStaticContext(at, tp)) {
                    accessibility = accessibility.and(this.STATIC_ONLY);
                }
                for (ExecutableElement ee : ElementFilter.methodsIn(this.membersOf(at, siteEl.asType(), false))) {
                    if (!ee.getSimpleName().contentEquals(mst.getIdentifier()) || !accessibility.test(ee)) continue;
                    result.add(Pair.of(ee, (ExecutableType)at.getTypes().asMemberOf((DeclaredType)site, ee)));
                }
                break;
            }
            case IDENTIFIER: {
                IdentifierTree it = (IdentifierTree)select;
                for (ExecutableElement ee : ElementFilter.methodsIn(this.scopeContent(at, at.trees().getScope(invocation), this.IDENTITY))) {
                    if (!ee.getSimpleName().contentEquals(it.getName()) || !accessibility.test(ee)) continue;
                    result.add(Pair.of(ee, (ExecutableType)ee.asType()));
                }
                break;
            }
        }
        return result;
    }

    private Iterable<Pair<ExecutableElement, ExecutableType>> newClassCandidates(TaskFactory.AnalyzeTask at, TreePath newClassPath) {
        NewClassTree nct = (NewClassTree)newClassPath.getLeaf();
        Element type = at.trees().getElement(new TreePath(newClassPath.getParentPath(), nct.getIdentifier()));
        TypeMirror targetType = at.trees().getTypeMirror(newClassPath);
        if (targetType == null || targetType.getKind() != TypeKind.DECLARED) {
            Iterable<TypeMirror> targetTypes = this.findTargetType(at, newClassPath);
            if (targetTypes == null) {
                targetTypes = Collections.emptyList();
            }
            targetType = StreamSupport.stream(targetTypes.spliterator(), false).filter(t -> at.getTypes().asElement((TypeMirror)t) == type).findAny().orElse(at.getTypes().erasure(type.asType()));
        }
        ArrayList<Pair<ExecutableElement, ExecutableType>> candidateConstructors = new ArrayList<Pair<ExecutableElement, ExecutableType>>();
        Predicate<Element> accessibility = this.createAccessibilityFilter(at, newClassPath);
        if (targetType != null && targetType.getKind() == TypeKind.DECLARED && type != null && (type.getKind().isClass() || type.getKind().isInterface())) {
            for (ExecutableElement constr : ElementFilter.constructorsIn(type.getEnclosedElements())) {
                if (!accessibility.test(constr)) continue;
                ExecutableType constrType = (ExecutableType)at.getTypes().asMemberOf((DeclaredType)targetType, constr);
                candidateConstructors.add(Pair.of(constr, constrType));
            }
        }
        return candidateConstructors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String documentation(String code, int cursor) {
        this.suspendIndexing();
        try {
            String string = this.documentationImpl(code, cursor);
            return string;
        }
        finally {
            this.resumeIndexing();
        }
    }

    private String documentationImpl(String code, int cursor) {
        java.util.List<? extends ExpressionTree> arguments;
        Iterable candidates;
        TreePath tp;
        if ((code = code.substring(0, cursor)).trim().isEmpty()) {
            code = code + ";";
        }
        if (this.guessKind(code) == Tree.Kind.IMPORT) {
            return null;
        }
        OuterWrap codeWrap = this.wrapInClass(Wrap.methodWrap(code));
        TaskFactory taskFactory = this.proc.taskFactory;
        taskFactory.getClass();
        TaskFactory.AnalyzeTask at = taskFactory.new TaskFactory.AnalyzeTask(codeWrap);
        SourcePositions sp = at.trees().getSourcePositions();
        CompilationUnitTree topLevel = at.firstCuTree();
        if (tp == null) {
            return null;
        }
        TreePath prevPath = null;
        for (tp = this.pathFor(topLevel, sp, codeWrap.snippetIndexToWrapIndex(cursor)); tp != null && tp.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION && tp.getLeaf().getKind() != Tree.Kind.NEW_CLASS; tp = tp.getParentPath()) {
            prevPath = tp;
        }
        if (tp == null) {
            return null;
        }
        if (tp.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree mit = (MethodInvocationTree)tp.getLeaf();
            candidates = this.methodCandidates(at, tp);
            arguments = mit.getArguments();
        } else {
            NewClassTree nct = (NewClassTree)tp.getLeaf();
            candidates = this.newClassCandidates(at, tp);
            arguments = nct.getArguments();
        }
        if (!this.isEmptyArgumentsContext(arguments)) {
            java.util.List<TypeMirror> actuals = this.computeActualInvocationTypes(at, arguments, prevPath);
            java.util.List<TypeMirror> fullActuals = actuals != null ? actuals : Collections.emptyList();
            candidates = this.filterExecutableTypesByArguments(at, candidates, fullActuals).stream().filter(method -> this.parameterType((ExecutableElement)method.fst, (ExecutableType)method.snd, fullActuals.size(), true).findAny().isPresent()).collect(Collectors.toList());
        }
        return Util.stream(candidates).map(method -> Util.expunge(this.element2String((Element)method.fst))).collect(Collectors.joining("\n"));
    }

    private boolean isEmptyArgumentsContext(java.util.List<? extends ExpressionTree> arguments) {
        if (arguments.size() == 1) {
            Tree firstArgument = arguments.get(0);
            return firstArgument.getKind() == Tree.Kind.ERRONEOUS;
        }
        return false;
    }

    private String element2String(Element el) {
        switch (el.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return ((TypeElement)el).getQualifiedName().toString();
            }
            case FIELD: {
                return this.element2String(el.getEnclosingElement()) + "." + el.getSimpleName() + ":" + el.asType();
            }
            case ENUM_CONSTANT: {
                return this.element2String(el.getEnclosingElement()) + "." + el.getSimpleName();
            }
            case EXCEPTION_PARAMETER: 
            case LOCAL_VARIABLE: 
            case PARAMETER: 
            case RESOURCE_VARIABLE: {
                return el.getSimpleName() + ":" + el.asType();
            }
            case METHOD: 
            case CONSTRUCTOR: {
                StringBuilder header = new StringBuilder();
                header.append(this.element2String(el.getEnclosingElement()));
                if (el.getKind() == ElementKind.METHOD) {
                    header.append(".");
                    header.append(el.getSimpleName());
                }
                header.append("(");
                String sep = "";
                ExecutableElement method = (ExecutableElement)el;
                Iterator<? extends VariableElement> i = method.getParameters().iterator();
                while (i.hasNext()) {
                    VariableElement p = i.next();
                    header.append(sep);
                    if (!i.hasNext() && method.isVarArgs()) {
                        header.append(this.unwrapArrayType(p.asType()));
                        header.append("...");
                    } else {
                        header.append(p.asType());
                    }
                    header.append(" ");
                    header.append(p.getSimpleName());
                    sep = ", ";
                }
                header.append(")");
                return header.toString();
            }
        }
        return el.toString();
    }

    private TypeMirror unwrapArrayType(TypeMirror arrayType) {
        if (arrayType.getKind() == TypeKind.ARRAY) {
            return ((ArrayType)arrayType).getComponentType();
        }
        return arrayType;
    }

    @Override
    public String analyzeType(String code, int cursor) {
        code = code.substring(0, cursor);
        SourceCodeAnalysis.CompletionInfo completionInfo = this.analyzeCompletion(code);
        if (!completionInfo.completeness.isComplete) {
            return null;
        }
        if (completionInfo.completeness == SourceCodeAnalysis.Completeness.COMPLETE_WITH_SEMI) {
            code = code + ";";
        }
        switch (this.guessKind(code)) {
            case IMPORT: 
            case METHOD: 
            case VARIABLE: 
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                return null;
            }
        }
        OuterWrap codeWrap = this.wrapInClass(Wrap.methodWrap(code));
        TaskFactory taskFactory = this.proc.taskFactory;
        taskFactory.getClass();
        TaskFactory.AnalyzeTask at = taskFactory.new TaskFactory.AnalyzeTask(codeWrap);
        SourcePositions sp = at.trees().getSourcePositions();
        CompilationUnitTree topLevel = at.firstCuTree();
        int pos = codeWrap.snippetIndexToWrapIndex(code.length());
        TreePath tp = this.pathFor(topLevel, sp, pos);
        while (ExpressionTree.class.isAssignableFrom(tp.getParentPath().getLeaf().getKind().asInterface()) && tp.getParentPath().getLeaf().getKind() != Tree.Kind.ERRONEOUS && tp.getParentPath().getParentPath() != null) {
            tp = tp.getParentPath();
        }
        TypeMirror type = at.trees().getTypeMirror(tp);
        if (type == null) {
            return null;
        }
        switch (type.getKind()) {
            case ERROR: 
            case PACKAGE: 
            case VOID: 
            case NONE: 
            case OTHER: {
                return null;
            }
            case NULL: {
                type = at.getElements().getTypeElement("java.lang.Object").asType();
            }
        }
        return TreeDissector.printType(at, this.proc, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceCodeAnalysis.QualifiedNames listQualifiedNames(String code, int cursor) {
        java.util.List<String> result;
        boolean upToDate;
        OuterWrap codeWrap;
        if ((code = code.substring(0, cursor)).trim().isEmpty()) {
            return new SourceCodeAnalysis.QualifiedNames(Collections.emptyList(), -1, true, false);
        }
        switch (this.guessKind(code)) {
            case IMPORT: {
                return new SourceCodeAnalysis.QualifiedNames(Collections.emptyList(), -1, true, false);
            }
            case METHOD: {
                codeWrap = this.wrapInClass(Wrap.classMemberWrap(code));
                break;
            }
            default: {
                codeWrap = this.wrapInClass(Wrap.methodWrap(code));
            }
        }
        TaskFactory taskFactory = this.proc.taskFactory;
        taskFactory.getClass();
        TaskFactory.AnalyzeTask at = taskFactory.new TaskFactory.AnalyzeTask(codeWrap);
        SourcePositions sp = at.trees().getSourcePositions();
        CompilationUnitTree topLevel = at.firstCuTree();
        TreePath tp = this.pathFor(topLevel, sp, codeWrap.snippetIndexToWrapIndex(code.length()));
        if (tp.getLeaf().getKind() != Tree.Kind.IDENTIFIER) {
            return new SourceCodeAnalysis.QualifiedNames(Collections.emptyList(), -1, true, false);
        }
        Scope scope = at.trees().getScope(tp);
        TypeMirror type = at.trees().getTypeMirror(tp);
        Element el = at.trees().getElement(tp);
        boolean erroneous = type.getKind() == TypeKind.ERROR && el.getKind() == ElementKind.CLASS || el.getKind() == ElementKind.PACKAGE && el.getEnclosedElements().isEmpty();
        String simpleName = ((IdentifierTree)tp.getLeaf()).getName().toString();
        Map<Path, ClassIndex> map = this.currentIndexes;
        synchronized (map) {
            upToDate = this.classpathVersion == this.indexVersion;
            result = this.currentIndexes.values().stream().flatMap(idx -> ((Collection)idx.classSimpleName2FQN.getOrDefault(simpleName, Collections.emptyList())).stream()).distinct().filter(fqn -> this.isAccessible(at, scope, (String)fqn)).sorted().collect(Collectors.toList());
        }
        return new SourceCodeAnalysis.QualifiedNames(result, simpleName.length(), upToDate, !erroneous);
    }

    private boolean isAccessible(TaskFactory.AnalyzeTask at, Scope scope, String fqn) {
        TypeElement type = at.getElements().getTypeElement(fqn);
        if (type == null) {
            return false;
        }
        return at.trees().isAccessible(scope, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIndexingNotSuspended() {
        boolean suspendedNotified = false;
        Object object = this.suspendLock;
        synchronized (object) {
            while (this.suspend > 0) {
                if (!suspendedNotified) {
                    suspendedNotified = true;
                }
                try {
                    this.suspendLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendIndexing() {
        Object object = this.suspendLock;
        synchronized (object) {
            ++this.suspend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeIndexing() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (--this.suspend == 0) {
                this.suspendLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshIndexes(int version2) {
        try {
            ClassIndex index;
            Path p;
            ArrayList<Path> paths = new ArrayList<Path>();
            MemoryFileManager fm = this.proc.taskFactory.fileManager();
            this.appendPaths(fm, StandardLocation.PLATFORM_CLASS_PATH, paths);
            this.appendPaths(fm, StandardLocation.CLASS_PATH, paths);
            this.appendPaths(fm, StandardLocation.SOURCE_PATH, paths);
            HashMap<Path, ClassIndex> newIndexes = new HashMap<Path, ClassIndex>();
            Object object = paths.iterator();
            while (object.hasNext()) {
                p = (Path)object.next();
                index = PATH_TO_INDEX.get(p);
                if (index == null) continue;
                newIndexes.put(p, index);
            }
            object = this.currentIndexes;
            synchronized (object) {
                this.currentIndexes.clear();
                this.currentIndexes.putAll(newIndexes);
            }
            object = paths.iterator();
            while (object.hasNext()) {
                p = (Path)object.next();
                this.waitIndexingNotSuspended();
                index = this.indexForPath(p);
                newIndexes.put(p, index);
            }
            object = this.currentIndexes;
            synchronized (object) {
                this.currentIndexes.clear();
                this.currentIndexes.putAll(newIndexes);
            }
        }
        catch (Exception ex) {
            this.proc.debug(ex, "SourceCodeAnalysisImpl.refreshIndexes(" + version2 + ")");
        }
        finally {
            Map<Path, ClassIndex> map = this.currentIndexes;
            synchronized (map) {
                this.indexVersion = version2;
            }
        }
    }

    private void appendPaths(MemoryFileManager fm, JavaFileManager.Location loc, Collection<Path> paths) {
        Iterable<? extends Path> locationPaths = fm.getLocationAsPaths(loc);
        if (locationPaths == null) {
            return;
        }
        for (Path path : locationPaths) {
            if (".".equals(path.toString())) continue;
            paths.add(path);
        }
    }

    private ClassIndex indexForPath(Path path) {
        if (SourceCodeAnalysisImpl.isJRTMarkerFile(path)) {
            FileSystem jrtfs = FileSystems.getFileSystem(URI.create("jrt:/"));
            Path modules = jrtfs.getPath("modules", new String[0]);
            return PATH_TO_INDEX.compute(path, (p, index) -> {
                try {
                    long lastModified = Files.getLastModifiedTime(modules, new LinkOption[0]).toMillis();
                    if (index == null || index.timestamp != lastModified) {
                        try (DirectoryStream<Path> stream = Files.newDirectoryStream(modules);){
                            index = this.doIndex(lastModified, path, stream);
                        }
                    }
                    return index;
                }
                catch (IOException ex) {
                    this.proc.debug(ex, "SourceCodeAnalysisImpl.indexesForPath(" + path.toString() + ")");
                    return new ClassIndex(-1L, path, Collections.emptySet(), Collections.emptyMap());
                }
            });
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            if (Files.exists(path, new LinkOption[0])) {
                return PATH_TO_INDEX.compute(path, (p, index) -> {
                    try {
                        long lastModified = Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
                        if (index == null || index.timestamp != lastModified) {
                            ClassLoader cl = SourceCodeAnalysisImpl.class.getClassLoader();
                            try (FileSystem zip = FileSystems.newFileSystem(path, cl);){
                                index = this.doIndex(lastModified, path, zip.getRootDirectories());
                            }
                        }
                        return index;
                    }
                    catch (IOException ex) {
                        this.proc.debug(ex, "SourceCodeAnalysisImpl.indexesForPath(" + path.toString() + ")");
                        return new ClassIndex(-1L, path, Collections.emptySet(), Collections.emptyMap());
                    }
                });
            }
            return new ClassIndex(-1L, path, Collections.emptySet(), Collections.emptyMap());
        }
        return PATH_TO_INDEX.compute(path, (p, index) -> {
            if (index == null) {
                index = this.doIndex(-1L, path, Arrays.asList(p));
            }
            return index;
        });
    }

    static boolean isJRTMarkerFile(Path path) {
        return path.equals(Paths.get("JRT_MARKER_FILE", new String[0]));
    }

    private ClassIndex doIndex(long timestamp, Path originalPath, Iterable<? extends Path> dirs) {
        final HashSet<String> packages = new HashSet<String>();
        final HashMap<String, Collection<String>> classSimpleName2FQN = new HashMap<String, Collection<String>>();
        for (final Path path : dirs) {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){
                    int depth;

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        String sep;
                        SourceCodeAnalysisImpl.this.waitIndexingNotSuspended();
                        if (this.depth++ == 0) {
                            return FileVisitResult.CONTINUE;
                        }
                        String dirName = dir.getFileName().toString();
                        String string = dirName = dirName.endsWith(sep = dir.getFileSystem().getSeparator()) ? dirName.substring(0, dirName.length() - sep.length()) : dirName;
                        if (SourceVersion.isIdentifier(dirName)) {
                            return FileVisitResult.CONTINUE;
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        SourceCodeAnalysisImpl.this.waitIndexingNotSuspended();
                        if (file.getFileName().toString().endsWith(".class")) {
                            String relativePath = path.relativize(file).toString();
                            String binaryName = relativePath.substring(0, relativePath.length() - 6).replace('/', '.');
                            int packageDot = binaryName.lastIndexOf(46);
                            if (packageDot > -1) {
                                packages.add(binaryName.substring(0, packageDot));
                            }
                            String typeName = binaryName.replace('$', '.');
                            SourceCodeAnalysisImpl.addClassName2Map(classSimpleName2FQN, typeName);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        --this.depth;
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                this.proc.debug(ex, "doIndex(" + path.toString() + ")");
            }
        }
        return new ClassIndex(timestamp, originalPath, packages, classSimpleName2FQN);
    }

    private static void addClassName2Map(Map<String, Collection<String>> classSimpleName2FQN, String typeName) {
        int simpleNameDot = typeName.lastIndexOf(46);
        classSimpleName2FQN.computeIfAbsent(typeName.substring(simpleNameDot + 1), n -> new LinkedHashSet()).add(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitBackgroundTaskFinished() throws Exception {
        boolean upToDate;
        Map<Path, ClassIndex> map = this.currentIndexes;
        synchronized (map) {
            upToDate = this.classpathVersion == this.indexVersion;
        }
        while (!upToDate) {
            INDEXER.submit(() -> {}).get();
            map = this.currentIndexes;
            synchronized (map) {
                upToDate = this.classpathVersion == this.indexVersion;
            }
        }
    }

    public static final class ClassIndex {
        public final long timestamp;
        public final Path forPath;
        public final Set<String> packages;
        public final Map<String, Collection<String>> classSimpleName2FQN;

        public ClassIndex(long timestamp, Path forPath, Set<String> packages, Map<String, Collection<String>> classSimpleName2FQN) {
            this.timestamp = timestamp;
            this.forPath = forPath;
            this.packages = packages;
            this.classSimpleName2FQN = classSimpleName2FQN;
        }
    }
}

