/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class DeprecatedAPIListBuilder {
    private final Map<DeprElementKind, SortedSet<Element>> deprecatedMap;
    private final Configuration configuration;
    private final Utils utils;

    public DeprecatedAPIListBuilder(Configuration configuration) {
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.deprecatedMap = new EnumMap<DeprElementKind, SortedSet<Element>>(DeprElementKind.class);
        for (DeprElementKind kind : DeprElementKind.values()) {
            this.deprecatedMap.put(kind, new TreeSet<Element>(this.utils.makeGeneralPurposeComparator()));
        }
        this.buildDeprecatedAPIInfo();
    }

    private void buildDeprecatedAPIInfo() {
        SortedSet<PackageElement> packages = this.configuration.packages;
        SortedSet<Element> pset = this.deprecatedMap.get((Object)DeprElementKind.PACKAGE);
        for (Element element : packages) {
            if (!this.utils.isDeprecated(element)) continue;
            pset.add(element);
        }
        this.deprecatedMap.put(DeprElementKind.PACKAGE, pset);
        for (Element element : this.configuration.root.getIncludedClasses()) {
            TypeElement te = (TypeElement)element;
            if (this.utils.isDeprecated(element)) {
                switch (element.getKind()) {
                    case ANNOTATION_TYPE: {
                        SortedSet<Element> eset = this.deprecatedMap.get((Object)DeprElementKind.ANNOTATION_TYPE);
                        eset.add(element);
                        break;
                    }
                    case CLASS: {
                        SortedSet<Element> eset = this.utils.isError(te) ? this.deprecatedMap.get((Object)DeprElementKind.ERROR) : (this.utils.isException(te) ? this.deprecatedMap.get((Object)DeprElementKind.EXCEPTION) : this.deprecatedMap.get((Object)DeprElementKind.CLASS));
                        eset.add(element);
                        break;
                    }
                    case INTERFACE: {
                        SortedSet<Element> eset = this.deprecatedMap.get((Object)DeprElementKind.INTERFACE);
                        eset.add(element);
                        break;
                    }
                    case ENUM: {
                        SortedSet<Element> eset = this.deprecatedMap.get((Object)DeprElementKind.ENUM);
                        eset.add(element);
                    }
                }
            }
            this.composeDeprecatedList(this.deprecatedMap.get((Object)DeprElementKind.FIELD), this.utils.getFields(te));
            this.composeDeprecatedList(this.deprecatedMap.get((Object)DeprElementKind.METHOD), this.utils.getMethods(te));
            this.composeDeprecatedList(this.deprecatedMap.get((Object)DeprElementKind.CONSTRUCTOR), this.utils.getConstructors(te));
            if (this.utils.isEnum(element)) {
                this.composeDeprecatedList(this.deprecatedMap.get((Object)DeprElementKind.ENUM_CONSTANT), this.utils.getEnumConstants(te));
            }
            if (!this.utils.isAnnotationType(element)) continue;
            this.composeDeprecatedList(this.deprecatedMap.get((Object)DeprElementKind.ANNOTATION_TYPE_MEMBER), this.utils.getAnnotationMembers(te));
        }
    }

    private void composeDeprecatedList(SortedSet<Element> sset, List<? extends Element> members) {
        for (Element element : members) {
            if (!this.utils.isDeprecated(element)) continue;
            sset.add(element);
        }
    }

    public SortedSet<Element> getSet(DeprElementKind kind) {
        return this.deprecatedMap.get((Object)kind);
    }

    public boolean hasDocumentation(DeprElementKind kind) {
        return !this.deprecatedMap.get((Object)kind).isEmpty();
    }

    public static enum DeprElementKind {
        PACKAGE,
        INTERFACE,
        CLASS,
        ENUM,
        EXCEPTION,
        ERROR,
        ANNOTATION_TYPE,
        FIELD,
        METHOD,
        CONSTRUCTOR,
        ENUM_CONSTANT,
        ANNOTATION_TYPE_MEMBER;

    }
}

