/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.collections;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public final class Multimaps {
    private Multimaps() {
    }

    public static <K, V> Multimap<K, V> prune(Multimap<K, V> map, Predicate<Collection<V>> filterRule) {
        Preconditions.checkNotNull(map);
        Preconditions.checkNotNull(filterRule);
        HashSet prunedKeys = Sets.newHashSet();
        for (Object key : map.keySet()) {
            if (filterRule.apply((Object)map.get(key))) continue;
            prunedKeys.add(key);
        }
        ArrayListMultimap pruned = ArrayListMultimap.create();
        for (Object key : prunedKeys) {
            pruned.putAll(key, (Iterable)map.removeAll(key));
        }
        return pruned;
    }

    public static <K, V> Multimap<K, V> prune(Multimap<K, V> map, final int minSize) {
        return Multimaps.prune(map, new Predicate<Collection<V>>(){

            public boolean apply(Collection<V> input) {
                return input.size() >= minSize;
            }
        });
    }

    public static <K> Set<K> getLargeGroups(Multimap<K, ?> map, int minSize) {
        HashSet largeKeys = Sets.newHashSet();
        for (Object key : map.keySet()) {
            if (map.get(key).size() < minSize) continue;
            largeKeys.add(key);
        }
        return largeKeys;
    }

    public static <K> Set<K> getLargestGroups(Multimap<K, ?> map, int topValues) {
        class Grouping
        implements Comparable<Grouping> {
            private K key;
            private int size;

            public Grouping(K key, int size) {
                this.key = key;
                this.size = size;
            }

            public int hashCode() {
                return this.size;
            }

            @Override
            public int compareTo(Grouping grouping) {
                return this.size - grouping.size;
            }

            public boolean equals(Object o) {
                if (!(o instanceof Grouping)) {
                    return false;
                }
                Grouping other = (Grouping)o;
                return this.key.equals(other.key);
            }
        }
        TreeSet topGroups = Sets.newTreeSet();
        for (Object key : map.keySet()) {
            topGroups.add(new Grouping(key, map.get(key).size()));
            if (topGroups.size() <= topValues) continue;
            topGroups.remove(topGroups.first());
        }
        HashSet topKeys = Sets.newHashSet();
        for (Grouping group : topGroups) {
            topKeys.add(group.key);
        }
        return topKeys;
    }
}

