/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.subscription;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.api.subscription.SubscriptionStateStore;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKSubscriptionStateStore
implements SubscriptionStateStore {
    static final Logger logger = LoggerFactory.getLogger(ZKSubscriptionStateStore.class);
    private final ZooKeeperClient zooKeeperClient;
    private final String zkPath;
    private AtomicReference<DLSN> lastCommittedPosition = new AtomicReference<Object>(null);

    public ZKSubscriptionStateStore(ZooKeeperClient zooKeeperClient, String zkPath) {
        this.zooKeeperClient = zooKeeperClient;
        this.zkPath = zkPath;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public CompletableFuture<DLSN> getLastCommitPosition() {
        if (null != this.lastCommittedPosition.get()) {
            return FutureUtils.value((Object)this.lastCommittedPosition.get());
        }
        return this.getLastCommitPositionFromZK();
    }

    CompletableFuture<DLSN> getLastCommitPositionFromZK() {
        final CompletableFuture<DLSN> result = new CompletableFuture<DLSN>();
        try {
            logger.debug("Reading last commit position from path {}", (Object)this.zkPath);
            this.zooKeeperClient.get().getData(this.zkPath, false, new AsyncCallback.DataCallback(){

                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                    logger.debug("Read last commit position from path {}: rc = {}", (Object)ZKSubscriptionStateStore.this.zkPath, (Object)rc);
                    if (KeeperException.Code.NONODE.intValue() == rc) {
                        result.complete(DLSN.NonInclusiveLowerBound);
                    } else if (KeeperException.Code.OK.intValue() != rc) {
                        result.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    } else {
                        try {
                            DLSN dlsn = DLSN.deserialize((String)new String(data, Charsets.UTF_8));
                            result.complete(dlsn);
                        }
                        catch (Exception t) {
                            logger.warn("Invalid last commit position found from path {}", (Object)ZKSubscriptionStateStore.this.zkPath, (Object)t);
                            result.complete(DLSN.NonInclusiveLowerBound);
                        }
                    }
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException zkce) {
            result.completeExceptionally(zkce);
        }
        catch (InterruptedException ie) {
            result.completeExceptionally(new DLInterruptedException("getLastCommitPosition was interrupted", (Throwable)ie));
        }
        return result;
    }

    @Override
    public CompletableFuture<Void> advanceCommitPosition(DLSN newPosition) {
        if (null == this.lastCommittedPosition.get() || newPosition.compareTo(this.lastCommittedPosition.get()) > 0) {
            this.lastCommittedPosition.set(newPosition);
            return Utils.zkAsyncCreateFullPathOptimisticAndSetData(this.zooKeeperClient, this.zkPath, newPosition.serialize().getBytes(Charsets.UTF_8), this.zooKeeperClient.getDefaultACL(), CreateMode.PERSISTENT);
        }
        return FutureUtils.Void();
    }
}

