/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.callback.NamespaceListener;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.impl.ZKNamespaceWatcher;
import org.apache.distributedlog.metadata.LogMetadataStore;
import org.apache.distributedlog.util.DLUtils;
import org.apache.distributedlog.util.OrderedScheduler;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZKLogMetadataStore
implements LogMetadataStore {
    final URI namespace;
    final Optional<URI> nsOptional;
    final ZooKeeperClient zkc;
    final ZKNamespaceWatcher nsWatcher;

    public ZKLogMetadataStore(DistributedLogConfiguration conf, URI namespace, ZooKeeperClient zkc, OrderedScheduler scheduler) {
        this.namespace = namespace;
        this.nsOptional = Optional.of((Object)this.namespace);
        this.zkc = zkc;
        this.nsWatcher = new ZKNamespaceWatcher(conf, namespace, zkc, scheduler);
    }

    @Override
    public CompletableFuture<URI> createLog(String logName) {
        return FutureUtils.value((Object)this.namespace);
    }

    @Override
    public CompletableFuture<Optional<URI>> getLogLocation(String logName) {
        return FutureUtils.value(this.nsOptional);
    }

    @Override
    public CompletableFuture<Iterator<String>> getLogs() {
        final CompletableFuture<Iterator<String>> promise = new CompletableFuture<Iterator<String>>();
        final String nsRootPath = this.namespace.getPath();
        try {
            final ZooKeeper zk = this.zkc.get();
            zk.sync(nsRootPath, new AsyncCallback.VoidCallback(){

                public void processResult(int syncRc, String syncPath, Object ctx) {
                    if (KeeperException.Code.OK.intValue() == syncRc) {
                        zk.getChildren(nsRootPath, false, new AsyncCallback.Children2Callback(){

                            public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                                if (KeeperException.Code.OK.intValue() == rc) {
                                    ArrayList results = Lists.newArrayListWithExpectedSize((int)children.size());
                                    for (String child : children) {
                                        if (DLUtils.isReservedStreamName(child)) continue;
                                        results.add(child);
                                    }
                                    promise.complete(results.iterator());
                                } else if (KeeperException.Code.NONODE.intValue() == rc) {
                                    LinkedList streams = Lists.newLinkedList();
                                    promise.complete(streams.iterator());
                                } else {
                                    promise.completeExceptionally((Throwable)((Object)new ZKException("Error reading namespace " + nsRootPath, KeeperException.Code.get((int)rc))));
                                }
                            }
                        }, null);
                    } else if (KeeperException.Code.NONODE.intValue() == syncRc) {
                        LinkedList streams = Lists.newLinkedList();
                        promise.complete(streams.iterator());
                    } else {
                        promise.completeExceptionally((Throwable)((Object)new ZKException("Error reading namespace " + nsRootPath, KeeperException.Code.get((int)syncRc))));
                    }
                }
            }, null);
            this.zkc.get();
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            promise.completeExceptionally(e);
        }
        catch (InterruptedException e) {
            promise.completeExceptionally(e);
        }
        return promise;
    }

    @Override
    public void registerNamespaceListener(NamespaceListener listener) {
        this.nsWatcher.registerListener(listener);
    }
}

