/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.Endpoint;
import org.apache.sandesha2.wsrm.Expires;
import org.apache.sandesha2.wsrm.IOMRMElement;
import org.apache.sandesha2.wsrm.Identifier;

public class SequenceOffer
implements IOMRMElement {
    private Identifier identifier = null;
    private Expires expires = null;
    private Endpoint endpoint = null;
    private String namespaceValue = null;

    public SequenceOffer(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement createSequenceElement) throws OMException, AxisFault {
        OMElement endpointPart;
        OMElement expiresPart;
        OMElement sequenceOfferPart = createSequenceElement.getFirstChildWithName(new QName(this.namespaceValue, "Offer"));
        if (sequenceOfferPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noSeqOfferInElement", createSequenceElement.toString()));
        }
        this.identifier = new Identifier(this.namespaceValue);
        OMElement identifierPart = sequenceOfferPart.getFirstChildWithName(new QName(this.namespaceValue, "Identifier"));
        if (identifierPart != null) {
            this.identifier.fromOMElement(identifierPart);
        }
        if ((expiresPart = sequenceOfferPart.getFirstChildWithName(new QName(this.namespaceValue, "Expires"))) != null) {
            this.expires = new Expires(this.namespaceValue);
            this.expires.fromOMElement(sequenceOfferPart);
        }
        if ((endpointPart = sequenceOfferPart.getFirstChildWithName(new QName(this.namespaceValue, "Endpoint"))) != null) {
            this.endpoint = new Endpoint(this.namespaceValue);
            this.endpoint.fromOMElement(endpointPart);
        }
        return this;
    }

    public OMElement toOMElement(OMElement createSequenceElement) throws OMException, AxisFault {
        if (this.identifier == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("nullMsgId"));
        }
        OMFactory factory = createSequenceElement.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        OMElement sequenceOfferElement = factory.createOMElement("Offer", rmNamespace);
        this.identifier.toOMElement(sequenceOfferElement, rmNamespace);
        if (this.endpoint != null) {
            this.endpoint.toOMElement(sequenceOfferElement);
        } else if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(this.namespaceValue)) {
            String message = SandeshaMessageHelper.getMessage("elementMustForSpec", "Endpoint", "http://docs.oasis-open.org/ws-rx/wsrm/200702");
            throw new SandeshaException(message);
        }
        if (this.expires != null) {
            this.expires.toOMElement(sequenceOfferElement);
        }
        createSequenceElement.addChild((OMNode)sequenceOfferElement);
        return createSequenceElement;
    }

    public Identifier getIdentifer() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

