/*
 * Decompiled with CFR 0.152.
 */
package sandesha2.samples.userguide;

import java.io.File;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import sandesha2.samples.userguide.TestCallback;

public class UserguideEchoClient {
    private static final String applicationNamespaceName = "http://tempuri.org/";
    private static final String echoString = "echoString";
    private static final String Text = "Text";
    private static final String Sequence = "Sequence";
    private static String toEPR = "http://127.0.0.1:8070/axis2/services/RMSampleService";
    private static String CLIENT_REPO_PATH = "Full path to the Client Repo folder";

    public static void main(String[] args) throws Exception {
        String axis2_xml = CLIENT_REPO_PATH + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)CLIENT_REPO_PATH, (String)axis2_xml);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        Options clientOptions = new Options();
        clientOptions.setTo(new EndpointReference(toEPR));
        clientOptions.setTransportInProtocol("http");
        clientOptions.setUseSeparateListener(true);
        serviceClient.setOptions(clientOptions);
        TestCallback callback1 = new TestCallback("Callback 1");
        serviceClient.sendReceiveNonBlocking(UserguideEchoClient.getEchoOMBlock("echo1", "sequence1"), (AxisCallback)callback1);
        TestCallback callback2 = new TestCallback("Callback 2");
        serviceClient.sendReceiveNonBlocking(UserguideEchoClient.getEchoOMBlock("echo2", "sequence1"), (AxisCallback)callback2);
        clientOptions.setProperty("Sandesha2LastMessage", (Object)"true");
        TestCallback callback3 = new TestCallback("Callback 3");
        serviceClient.sendReceiveNonBlocking(UserguideEchoClient.getEchoOMBlock("echo3", "sequence1"), (AxisCallback)callback3);
        while (!callback3.isComplete()) {
            Thread.sleep(1000L);
        }
        Thread.sleep(4000L);
    }

    private static OMElement getEchoOMBlock(String text, String sequenceKey) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace applicationNamespace = fac.createOMNamespace(applicationNamespaceName, "ns1");
        OMElement echoStringElement = fac.createOMElement(echoString, applicationNamespace);
        OMElement textElem = fac.createOMElement(Text, applicationNamespace);
        OMElement sequenceElem = fac.createOMElement(Sequence, applicationNamespace);
        textElem.setText(text);
        sequenceElem.setText(sequenceKey);
        echoStringElement.addChild((OMNode)textElem);
        echoStringElement.addChild((OMNode)sequenceElem);
        return echoStringElement;
    }
}

