/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
declare namespace ProtoModule {
  type EditMode = 'create' | 'update';

  type ProtoData = {
    id: ?string;
    content: string;
    desc: string;
  };

  type ProtoDrawerProps = {
    protoData: ProtoData;
    setProtoData: (protoData: ProtoData) => void;
    visible: boolean;
    setVisible: (visible: boolean) => void;
    editMode: EditMode;
    refreshTable: () => void;
  };

  type ResponseBody = {
    id: string;
    create_time: number;
    update_time: number;
    desc: string;
    content: string;
  };
}
