/*
 * Decompiled with CFR 0.152.
 */
package storm.starter.tools;

import backtype.storm.utils.Time;
import org.apache.commons.collections.buffer.CircularFifoBuffer;

public class NthLastModifiedTimeTracker {
    private static final int MILLIS_IN_SEC = 1000;
    private final CircularFifoBuffer lastModifiedTimesMillis;

    public NthLastModifiedTimeTracker(int numTimesToTrack) {
        if (numTimesToTrack < 1) {
            throw new IllegalArgumentException("numTimesToTrack must be greater than zero (you requested " + numTimesToTrack + ")");
        }
        this.lastModifiedTimesMillis = new CircularFifoBuffer(numTimesToTrack);
        this.initLastModifiedTimesMillis();
    }

    private void initLastModifiedTimesMillis() {
        long nowCached = this.now();
        for (int i = 0; i < this.lastModifiedTimesMillis.maxSize(); ++i) {
            this.lastModifiedTimesMillis.add((Object)nowCached);
        }
    }

    private long now() {
        return Time.currentTimeMillis();
    }

    public int secondsSinceOldestModification() {
        long modifiedTimeMillis = (Long)this.lastModifiedTimesMillis.get();
        return (int)((this.now() - modifiedTimeMillis) / 1000L);
    }

    public void markAsModified() {
        this.updateLastModifiedTime();
    }

    private void updateLastModifiedTime() {
        this.lastModifiedTimesMillis.add((Object)this.now());
    }
}

