/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.ResourceFactory;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.RuntimeCompassSettings;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineIndexManager;
import org.compass.core.engine.SearchEngineOptimizer;
import org.compass.core.engine.event.SearchEngineEventManager;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.engine.spellcheck.SearchEngineSpellCheckManager;
import org.compass.core.engine.spi.InternalSearchEngineFactory;
import org.compass.core.executor.ExecutorManager;
import org.compass.core.lucene.LuceneResourceFactory;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerManager;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterManager;
import org.compass.core.lucene.engine.indexdeletionpolicy.IndexDeletionPolicyFactory;
import org.compass.core.lucene.engine.manager.DefaultLuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.optimizer.LuceneSearchEngineOptimizerManager;
import org.compass.core.lucene.engine.queryparser.LuceneQueryParserManager;
import org.compass.core.lucene.engine.spellcheck.DefaultLuceneSpellCheckManager;
import org.compass.core.lucene.engine.spellcheck.InternalLuceneSearchEngineSpellCheckManager;
import org.compass.core.lucene.engine.store.DefaultLuceneSearchEngineStore;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.transaction.context.TransactionContext;
import org.compass.core.util.ClassUtils;

public class LuceneSearchEngineFactory
implements InternalSearchEngineFactory {
    private static final Log log = LogFactory.getLog(LuceneSearchEngineFactory.class);
    private CompassMapping mapping;
    private PropertyNamingStrategy propertyNamingStrategy;
    private LuceneSettings luceneSettings;
    private ResourceFactory resourceFactory;
    private SearchEngineOptimizer searchEngineOptimizer;
    private InternalLuceneSearchEngineSpellCheckManager spellCheckManager;
    private LuceneSearchEngineIndexManager indexManager;
    private ExecutorManager executorManager;
    private TransactionContext transactionContext;
    private LuceneAnalyzerManager analyzerManager;
    private LuceneHighlighterManager highlighterManager;
    private LuceneQueryParserManager queryParserManager;
    private IndexDeletionPolicyFactory indexDeletionPolicyManager;
    private CompassSettings settings;
    private SearchEngineEventManager eventManager = new SearchEngineEventManager();

    public LuceneSearchEngineFactory(PropertyNamingStrategy propertyNamingStrategy, CompassSettings settings, CompassMapping mapping, ExecutorManager executorManager) {
        this.propertyNamingStrategy = propertyNamingStrategy;
        this.mapping = mapping;
        this.executorManager = executorManager;
        this.settings = settings;
        this.luceneSettings = new LuceneSettings();
        this.luceneSettings.configure(settings);
        this.configure(settings, mapping);
    }

    public void close() throws SearchEngineException {
        if (this.spellCheckManager != null) {
            this.spellCheckManager.close();
        }
        this.indexManager.close();
    }

    public SearchEngine openSearchEngine(RuntimeCompassSettings runtimeSettings) {
        return new LuceneSearchEngine(runtimeSettings, this);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public ExecutorManager getExecutorManager() {
        return this.executorManager;
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    private void configure(CompassSettings settings, CompassMapping mapping) {
        block5: {
            this.resourceFactory = new LuceneResourceFactory(this);
            this.analyzerManager = new LuceneAnalyzerManager();
            this.analyzerManager.configure(settings, mapping, this.luceneSettings);
            DefaultLuceneSearchEngineStore searchEngineStore = new DefaultLuceneSearchEngineStore();
            searchEngineStore.configure(this, settings, mapping);
            this.indexManager = new DefaultLuceneSearchEngineIndexManager(this, searchEngineStore);
            this.indexDeletionPolicyManager = new IndexDeletionPolicyFactory(this.indexManager);
            this.indexDeletionPolicyManager.configure(settings);
            try {
                ClassUtils.forName("org.apache.lucene.search.highlight.Highlighter", settings.getClassLoader());
                this.highlighterManager = new LuceneHighlighterManager();
                this.highlighterManager.configure(settings);
            }
            catch (ClassNotFoundException e1) {
                log.info((Object)"Not using highlighter - no highlighter jar included.");
            }
            this.searchEngineOptimizer = new LuceneSearchEngineOptimizerManager(this);
            ((CompassConfigurable)((Object)this.searchEngineOptimizer)).configure(settings);
            if (settings.getSettingAsBoolean("compass.engine.spellcheck.enable", false)) {
                try {
                    ClassUtils.forName("org.apache.lucene.search.spell.SpellChecker", settings.getClassLoader());
                    this.spellCheckManager = new DefaultLuceneSpellCheckManager();
                    this.spellCheckManager.configure(this, settings, mapping);
                }
                catch (ClassNotFoundException e) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn((Object)"No spell checker jar file found in classpath, disabling spell checker");
                }
            }
        }
        this.queryParserManager = new LuceneQueryParserManager(this);
        this.queryParserManager.configure(settings);
    }

    public void start() {
        this.searchEngineOptimizer.start();
        this.indexManager.start();
        if (this.spellCheckManager != null) {
            this.spellCheckManager.start();
        }
    }

    public void stop() {
        this.searchEngineOptimizer.stop();
        this.indexManager.stop();
        if (this.spellCheckManager != null) {
            this.spellCheckManager.stop();
        }
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public String getAliasProperty() {
        return this.luceneSettings.getAliasProperty();
    }

    public String getExtendedAliasProperty() {
        return this.luceneSettings.getExtendedAliasProperty();
    }

    public String getAllProperty() {
        return this.luceneSettings.getAllProperty();
    }

    public CompassMapping getMapping() {
        return this.mapping;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }

    public SearchEngineOptimizer getOptimizer() {
        return this.searchEngineOptimizer;
    }

    public SearchEngineSpellCheckManager getSpellCheckManager() {
        return this.spellCheckManager;
    }

    public SearchEngineIndexManager getIndexManager() {
        return this.indexManager;
    }

    public LuceneSearchEngineIndexManager getLuceneIndexManager() {
        return this.indexManager;
    }

    public LuceneSettings getLuceneSettings() {
        return this.luceneSettings;
    }

    public CompassSettings getSettings() {
        return this.settings;
    }

    public LuceneAnalyzerManager getAnalyzerManager() {
        return this.analyzerManager;
    }

    public SearchEngineEventManager getEventManager() {
        return this.eventManager;
    }

    public LuceneHighlighterManager getHighlighterManager() throws SearchEngineException {
        if (this.highlighterManager == null) {
            throw new SearchEngineException("Trying to use highlighter, but no highlighter jar included");
        }
        return this.highlighterManager;
    }

    public LuceneQueryParserManager getQueryParserManager() {
        return this.queryParserManager;
    }

    public IndexDeletionPolicyFactory getIndexDeletionPolicyManager() {
        return this.indexDeletionPolicyManager;
    }
}

