/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.text.ParseException;
import org.compass.core.converter.basic.AbstractNumberConverter;
import org.compass.core.converter.basic.format.Formatter;
import org.compass.core.converter.basic.format.NumberUtils;
import org.compass.core.mapping.ResourcePropertyMapping;

public class LongConverter
extends AbstractNumberConverter {
    protected Object defaultFromString(String str, ResourcePropertyMapping resourcePropertyMapping) {
        return Long.valueOf(str);
    }

    protected Object fromNumber(Number number) {
        return number.longValue();
    }

    protected Formatter createSortableFormatter() {
        return new Formatter(){

            public String format(Object obj) {
                long val = ((Number)obj).longValue();
                return NumberUtils.long2sortableStr(val);
            }

            public Object parse(String str) throws ParseException {
                return NumberUtils.SortableStr2long(str);
            }

            public boolean isThreadSafe() {
                return true;
            }
        };
    }
}

