/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.index;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.index.AbstractJdbcIndexOutput;

public class RAMJdbcIndexOutput
extends AbstractJdbcIndexOutput {
    private RAMFile file;
    private int pointer = 0;

    public void configure(String name, JdbcDirectory jdbcDirectory, JdbcFileEntrySettings settings) throws IOException {
        super.configure(name, jdbcDirectory, settings);
        this.file = new RAMFile();
        this.name = name;
        this.jdbcDirectory = jdbcDirectory;
    }

    public void flushBuffer(byte[] src, int offset, int len) {
        int bufferPos = offset;
        while (bufferPos != len) {
            byte[] buffer;
            int bytesToCopy;
            int bufferNumber = this.pointer / this.bufferSize;
            int bufferOffset = this.pointer % this.bufferSize;
            int bytesInBuffer = this.bufferSize - bufferOffset;
            int remainInSrcBuffer = len - bufferPos;
            int n = bytesToCopy = bytesInBuffer >= remainInSrcBuffer ? remainInSrcBuffer : bytesInBuffer;
            if (bufferNumber == this.file.buffers.size()) {
                buffer = new byte[this.bufferSize];
                this.file.buffers.add(buffer);
            } else {
                buffer = (byte[])this.file.buffers.get(bufferNumber);
            }
            System.arraycopy(src, bufferPos, buffer, bufferOffset, bytesToCopy);
            bufferPos += bytesToCopy;
            this.pointer += bytesToCopy;
        }
        if ((long)this.pointer > this.file.length) {
            this.file.length = this.pointer;
        }
    }

    protected InputStream openInputStream() throws IOException {
        return new RAMInputStream();
    }

    protected void doAfterClose() throws IOException {
        this.file = null;
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.pointer = (int)pos;
    }

    public long length() {
        return this.file.length;
    }

    public void flushToIndexOutput(IndexOutput indexOutput) throws IOException {
        int i;
        super.flush();
        if (this.file.buffers.size() == 0) {
            return;
        }
        if (this.file.buffers.size() == 1) {
            indexOutput.writeBytes((byte[])this.file.buffers.get(0), (int)this.file.length);
            return;
        }
        int tempSize = this.file.buffers.size() - 1;
        for (i = 0; i < tempSize; ++i) {
            indexOutput.writeBytes((byte[])this.file.buffers.get(i), this.bufferSize);
        }
        int leftOver = (int)(this.file.length % (long)this.bufferSize);
        if (leftOver == 0) {
            indexOutput.writeBytes((byte[])this.file.buffers.get(i), this.bufferSize);
        } else {
            indexOutput.writeBytes((byte[])this.file.buffers.get(i), leftOver);
        }
    }

    private class RAMInputStream
    extends InputStream {
        private long position;
        private int buffer;
        private int bufferPos;
        private long markedPosition;

        private RAMInputStream() {
        }

        public synchronized void reset() throws IOException {
            this.position = this.markedPosition;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int readlimit) {
            this.markedPosition = this.position;
        }

        public int read(byte[] dest, int destOffset, int len) throws IOException {
            int bytesToCopy;
            if (this.position == ((RAMJdbcIndexOutput)RAMJdbcIndexOutput.this).file.length) {
                return -1;
            }
            long oldPosition = this.position;
            for (int remainder = (int)(this.position + (long)len > ((RAMJdbcIndexOutput)RAMJdbcIndexOutput.this).file.length ? ((RAMJdbcIndexOutput)RAMJdbcIndexOutput.this).file.length - this.position : (long)len); remainder != 0; remainder -= bytesToCopy) {
                if (this.bufferPos == RAMJdbcIndexOutput.this.bufferSize) {
                    this.bufferPos = 0;
                    ++this.buffer;
                }
                bytesToCopy = (bytesToCopy = RAMJdbcIndexOutput.this.bufferSize - this.bufferPos) >= remainder ? remainder : bytesToCopy;
                byte[] buf = (byte[])((RAMJdbcIndexOutput)RAMJdbcIndexOutput.this).file.buffers.get(this.buffer);
                System.arraycopy(buf, this.bufferPos, dest, destOffset, bytesToCopy);
                destOffset += bytesToCopy;
                this.position += (long)bytesToCopy;
                this.bufferPos += bytesToCopy;
            }
            return (int)(this.position - oldPosition);
        }

        public int read() throws IOException {
            if (this.position == ((RAMJdbcIndexOutput)RAMJdbcIndexOutput.this).file.length) {
                return -1;
            }
            if (this.bufferPos == RAMJdbcIndexOutput.this.bufferSize) {
                this.bufferPos = 0;
                ++this.buffer;
            }
            byte[] buf = (byte[])((RAMJdbcIndexOutput)RAMJdbcIndexOutput.this).file.buffers.get(this.buffer);
            ++this.position;
            return buf[this.bufferPos++] & 0xFF;
        }
    }

    private class RAMFile {
        ArrayList buffers = new ArrayList();
        long length;

        private RAMFile() {
        }
    }
}

