/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.util;

import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.util.LoggingConfigurationTags;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.SimpleFormatter;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class LoggerProvider
implements Provider<MyLoggingFacade>,
LoggingConfigurationTags {
    String logFile;
    boolean debugOn;
    String loggerName;
    int fileCount = -1;
    int maxFileSize = -1;
    boolean appendOn = true;
    boolean disableLog4j = true;
    ConfigurationNode configurationNode;
    MyLoggingFacade logger;
    String logFileName = null;

    public LoggerProvider(String logFile, String loggerName, int fileCount, int maxFileSize, boolean disableLog4j, boolean debugOn, boolean appendOn) {
        this.debugOn = debugOn;
        this.logFile = logFile;
        this.loggerName = loggerName;
        this.appendOn = appendOn;
        this.fileCount = fileCount;
        this.maxFileSize = maxFileSize;
        this.disableLog4j = disableLog4j;
    }

    public LoggerProvider(ConfigurationNode configurationNode) {
        this.configurationNode = configurationNode;
        this.setup();
    }

    protected void setup() {
        if (this.configurationNode == null) {
            return;
        }
        this.logFile = Configurations.getFirstAttribute(this.configurationNode, "logFileName");
        this.loggerName = Configurations.getFirstAttribute(this.configurationNode, "logName");
        try {
            this.debugOn = Boolean.parseBoolean(Configurations.getFirstAttribute(this.configurationNode, "debug"));
        }
        catch (Exception x) {
            this.debugOn = false;
        }
        try {
            this.fileCount = Integer.parseInt(Configurations.getFirstAttribute(this.configurationNode, "logFileCount"));
        }
        catch (Exception x) {
            this.fileCount = 1;
        }
        try {
            this.maxFileSize = Integer.parseInt(Configurations.getFirstAttribute(this.configurationNode, "logFileSize"));
        }
        catch (Exception e) {
            this.maxFileSize = 1000000;
        }
        try {
            this.appendOn = Boolean.parseBoolean(Configurations.getFirstAttribute(this.configurationNode, "append"));
        }
        catch (Exception e) {
            this.appendOn = true;
        }
        try {
            this.disableLog4j = Boolean.parseBoolean(Configurations.getFirstAttribute(this.configurationNode, "disableLog4j"));
        }
        catch (Exception e) {
            this.disableLog4j = false;
        }
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public MyLoggingFacade get() {
        if (this.logger == null) {
            if (this.disableLog4j) {
                Configurations.killLog4J();
            }
            if (this.loggerName == null) {
                this.loggerName = "OAuth for MyProxy";
            }
            this.logger = new MyLoggingFacade(this.loggerName);
            this.logFileName = null;
            if (this.logFile != null) {
                FileHandler fileHandler = null;
                try {
                    File log = new File(this.logFile);
                    this.logFileName = log.canWrite() ? log.getCanonicalPath() : this.logFile;
                    fileHandler = new FileHandler(this.logFile, this.maxFileSize, this.fileCount, true);
                    fileHandler.setFormatter(new SimpleFormatter());
                    this.logger.getLogger().addHandler(fileHandler);
                    this.logger.getLogger().setUseParentHandlers(false);
                    this.logger.info("Logging to file " + this.logFileName);
                }
                catch (IOException e) {
                    this.logger.info("Warning: could not setup logging to file. Message:\"" + e.getMessage() + "\". Logging to console. Processing will continue.");
                    this.logger.info("You probably should configure logging explicitly.");
                }
                this.logger.setDebugOn(this.debugOn);
            }
        }
        return this.logger;
    }
}

