/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.tx;

import com.hazelcast.map.MapRecordKey;
import com.hazelcast.map.tx.MapTxnOperation;
import com.hazelcast.map.tx.TxnPrepareOperation;
import com.hazelcast.map.tx.TxnRollbackOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.impl.KeyAwareTransactionLog;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.io.IOException;
import java.util.concurrent.Future;

public class MapTransactionLog
implements KeyAwareTransactionLog {
    long version;
    String name;
    Data key;
    int threadId = ThreadUtil.getThreadId();
    Operation op;

    public MapTransactionLog() {
    }

    public MapTransactionLog(String name, Data key, Operation op, long version) {
        this.name = name;
        this.key = key;
        this.version = version;
        if (!(op instanceof MapTxnOperation)) {
            throw new IllegalArgumentException();
        }
        this.op = op;
    }

    @Override
    public Future prepare(NodeEngine nodeEngine) throws TransactionException {
        TxnPrepareOperation operation = new TxnPrepareOperation(this.name, this.key);
        operation.setThreadId(this.threadId);
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(this.key);
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).build();
            return invocation.invoke();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Future commit(NodeEngine nodeEngine) {
        MapTxnOperation txnOp = (MapTxnOperation)((Object)this.op);
        txnOp.setThreadId(this.threadId);
        txnOp.setVersion(this.version);
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(this.key);
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", this.op, partitionId).build();
            return invocation.invoke();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Future rollback(NodeEngine nodeEngine) {
        int partitionId = nodeEngine.getPartitionService().getPartitionId(this.key);
        TxnRollbackOperation operation = new TxnRollbackOperation(this.name, this.key);
        operation.setThreadId(this.threadId);
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).build();
            return invocation.invoke();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.version);
        boolean isNullKey = this.key == null;
        out.writeBoolean(isNullKey);
        if (!isNullKey) {
            this.key.writeData(out);
        }
        out.writeInt(this.threadId);
        out.writeObject(this.op);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.version = in.readLong();
        boolean isNullKey = in.readBoolean();
        if (!isNullKey) {
            this.key = new Data();
            this.key.readData(in);
        }
        this.threadId = in.readInt();
        this.op = (Operation)in.readObject();
    }

    @Override
    public Object getKey() {
        return new MapRecordKey(this.name, this.key);
    }
}

