/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.validators;

import eu.unicore.samly2.exceptions.SAMLValidationException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReplayAttackChecker {
    private Map<String, Long> usedIds = new HashMap<String, Long>();

    public synchronized void checkAndStore(String id, Calendar maxValidity) throws SAMLValidationException {
        this.checkAndStore(id, maxValidity.getTimeInMillis());
    }

    public synchronized void checkAndStore(String id, long maxValidity) throws SAMLValidationException {
        this.purgeOutdated();
        if (this.usedIds.containsKey(id)) {
            throw new SAMLValidationException("Replay attack detected. Reused SAML ID is: " + id);
        }
        this.usedIds.put(id, maxValidity);
    }

    private void purgeOutdated() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<String, Long>> iterator = this.usedIds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (entry.getValue() >= now) continue;
            iterator.remove();
        }
    }
}

