/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import eu.emi.security.authn.x509.helpers.ns.NamespacesParser;
import eu.emi.security.authn.x509.helpers.ns.OpensslNamespacePolicyImpl;
import eu.emi.security.authn.x509.helpers.ns.ParserUtils;
import eu.emi.security.authn.x509.helpers.trust.OpensslTruststoreHelper;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class GlobusNamespacesParser
implements NamespacesParser {
    public static String ACCESS_ID_CA = "access_id_CA";
    public static String DEF_AUTH_X509 = "X509";
    public static String DEF_AUTH_GLOBUS = "globus";
    public static String POS_RIGHTS = "pos_rights";
    public static String CONDITION_SUBJECT = "cond_subjects";
    public static String VALUE_CA_SIGN = "CA:sign";
    public static final String NS_REGEXP = "^([0-9a-fA-F]{8})\\.signing_policy$";
    private String filePath;
    private String hash;
    private String issuer;
    private List<NamespacePolicy> ret;

    public GlobusNamespacesParser(String filePath) {
        this.filePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NamespacePolicy> parse() throws IOException {
        this.hash = OpensslTruststoreHelper.getFileHash(this.filePath, NS_REGEXP);
        if (this.hash == null) {
            throw new IOException("Policy file name " + this.filePath + " is incorrect: it must be formed from 8 charater subject hash and " + "'.signing_policy' extension.");
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.filePath));
        try {
            String line;
            this.ret = new ArrayList<NamespacePolicy>();
            while ((line = reader.readLine()) != null) {
                if (!this.isValid(line = line.trim()) || !line.startsWith(ACCESS_ID_CA)) continue;
                this.handleCABlock(line, reader);
            }
            List<NamespacePolicy> list = this.ret;
            return list;
        }
        finally {
            reader.close();
        }
    }

    private void handleCABlock(String line, BufferedReader reader) throws IOException {
        char[] caChars = line.toCharArray();
        int i = ACCESS_ID_CA.length();
        i += this.eatSpaces(caChars, i, true);
        i += ParserUtils.checkToken(DEF_AUTH_X509, caChars, i, true);
        i += this.eatSpaces(caChars, i, true);
        StringBuilder issuerBuf = new StringBuilder();
        i += this.getQuoted(caChars, i, '\'', issuerBuf);
        this.issuer = issuerBuf.toString();
        ParserUtils.checkEndOfLine(caChars, i);
        while ((line = reader.readLine()) != null) {
            if (!this.isValid(line = line.trim())) continue;
            this.handleAuthEntry(line, reader);
            break;
        }
    }

    private void handleAuthEntry(String line, BufferedReader reader) throws IOException {
        char[] chars = line.toCharArray();
        int j = 0;
        j += ParserUtils.checkToken(POS_RIGHTS, chars, j, true);
        j += this.eatSpaces(chars, j, true);
        j += ParserUtils.checkToken(DEF_AUTH_GLOBUS, chars, j, true);
        j += this.eatSpaces(chars, j, true);
        j += ParserUtils.checkToken(VALUE_CA_SIGN, chars, j, true);
        ParserUtils.checkEndOfLine(chars, j);
        while ((line = reader.readLine()) != null) {
            if (!this.isValid(line = line.trim())) continue;
            this.handlePermitEntry(line, reader);
            break;
        }
    }

    private void handlePermitEntry(String line, BufferedReader reader) throws IOException {
        char[] chars = line.toCharArray();
        int j = 0;
        j += ParserUtils.checkToken(CONDITION_SUBJECT, chars, j, true);
        j += this.eatSpaces(chars, j, true);
        j += ParserUtils.checkToken(DEF_AUTH_GLOBUS, chars, j, true);
        j += this.eatSpaces(chars, j, true);
        StringBuilder subject = new StringBuilder();
        j += this.getQuoted(chars, j, '\'', subject);
        ParserUtils.checkEndOfLine(chars, j);
        this.addPermitted(subject.toString());
    }

    private void addPermitted(String permitted) throws IOException {
        char[] subjectWildcards = permitted.toCharArray();
        int i = 0;
        while (true) {
            int spaces;
            if ((i += (spaces = this.eatSpaces(subjectWildcards, i, false))) == 0) {
                ++spaces;
            }
            StringBuilder permittedBuf = new StringBuilder();
            i += this.getQuoted(subjectWildcards, i, '\"', permittedBuf);
            permitted = permittedBuf.toString().trim();
            if (permitted.length() == 0) break;
            if (spaces == 0) {
                throw new IOException("Syntax problem, space character(s) missing in: " + new String(subjectWildcards, 0, subjectWildcards.length));
            }
            String permittedNormal = GlobusNamespacesParser.normalize(permitted);
            OpensslNamespacePolicyImpl policy = new OpensslNamespacePolicyImpl(OpensslNameUtils.normalize(this.issuer), permittedNormal, this.hash, true, this.filePath);
            this.ret.add(policy);
        }
    }

    private int getQuoted(char[] string, int offset, char quoteChar, StringBuilder ret) throws IOException {
        int count;
        int all = count = string.length - offset;
        if (count <= 0) {
            return 0;
        }
        if (string[offset] == quoteChar) {
            if (count < 2) {
                throw new IOException("Syntax problem, quoted string is not properly ended: '" + new String(string, offset, string.length - offset));
            }
            int finish = ++offset + this.eatUntil(string, offset, quoteChar);
            count = finish - offset;
            all = count + 2;
        }
        ret.append(string, offset, count);
        return all;
    }

    private boolean isValid(String line) {
        return !line.equals("") && !line.startsWith("#");
    }

    private int eatSpaces(char[] string, int offset, boolean atLeastOne) throws IOException {
        int i = 0;
        while (i + offset < string.length && (string[i + offset] == ' ' || string[i + offset] == '\t')) {
            ++i;
        }
        if (atLeastOne && i == 0) {
            throw new IOException("Syntax problem, expected space character(s) here: " + new String(string, offset, string.length - offset));
        }
        return i;
    }

    private int eatUntil(char[] string, int offset, char delimiter) throws IOException {
        int i = 0;
        while (i + offset < string.length && string[i + offset] != delimiter) {
            ++i;
        }
        if (i + offset == string.length) {
            throw new IOException("Syntax problem, quoted string is not properly ended: '" + new String(string, offset, string.length - offset));
        }
        return i;
    }

    public static String normalize(String dn) {
        dn = OpensslNameUtils.normalize(dn);
        return GlobusNamespacesParser.makeRegexpClassicWildcard(dn);
    }

    public static String makeRegexpClassicWildcard(String pattern) {
        String wPattern = pattern;
        String REP_STAR = ".*";
        String REP_QUESTION = ".";
        StringBuilder patternB = new StringBuilder();
        int pos = 0;
        while (wPattern.startsWith("*") || wPattern.startsWith("?")) {
            if (wPattern.startsWith("*")) {
                patternB.append(REP_STAR);
            } else {
                patternB.append(REP_QUESTION);
            }
            wPattern = wPattern.substring(1);
        }
        int endingSize = 0;
        while (wPattern.endsWith("*") || wPattern.endsWith("?")) {
            wPattern = wPattern.substring(0, wPattern.length() - 1);
            ++endingSize;
        }
        String[] rPNames = wPattern.split("\\*|\\?");
        for (int i = 0; i < rPNames.length; ++i) {
            if (rPNames[i].length() > 0) {
                patternB.append(Pattern.quote(rPNames[i]));
                pos += rPNames[i].length();
            }
            if (i + 1 >= rPNames.length) continue;
            char orig = wPattern.charAt(pos);
            if (orig == '?') {
                patternB.append(REP_QUESTION);
            } else if (orig == '*') {
                patternB.append(REP_STAR);
            } else {
                throw new RuntimeException("Bug: should get ? or * on the split position");
            }
            ++pos;
        }
        char[] patternC = pattern.toCharArray();
        for (int i = patternC.length - endingSize; i < patternC.length; ++i) {
            if (patternC[i] == '*') {
                patternB.append(REP_STAR);
                continue;
            }
            patternB.append(REP_QUESTION);
        }
        return patternB.toString();
    }
}

