/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DetachInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DetachInstancesRequestMarshaller
implements Marshaller<Request<DetachInstancesRequest>, DetachInstancesRequest> {
    public Request<DetachInstancesRequest> marshall(DetachInstancesRequest detachInstancesRequest) {
        if (detachInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachInstancesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DetachInstances");
        request.addParameter("Version", "2011-01-01");
        List<String> instanceIdsList = detachInstancesRequest.getInstanceIds();
        int instanceIdsListIndex = 1;
        for (String instanceIdsListValue : instanceIdsList) {
            if (instanceIdsListValue != null) {
                request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringUtils.fromString((String)instanceIdsListValue));
            }
            ++instanceIdsListIndex;
        }
        if (detachInstancesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)detachInstancesRequest.getAutoScalingGroupName()));
        }
        if (detachInstancesRequest.isShouldDecrementDesiredCapacity() != null) {
            request.addParameter("ShouldDecrementDesiredCapacity", StringUtils.fromBoolean((Boolean)detachInstancesRequest.isShouldDecrementDesiredCapacity()));
        }
        return request;
    }
}

